/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterNature;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.HSSFColor;

public class JRXlsExporter
extends JRXlsAbstractExporter {
    private static final Log log = LogFactory.getLog(JRXlsAbstractExporter.class);
    private static Map hssfColorsCache = new ReferenceMap();
    protected Map loadedCellStyles = new HashMap();
    protected HSSFWorkbook workbook = null;
    protected HSSFSheet sheet = null;
    protected HSSFRow row = null;
    protected HSSFCell cell = null;
    protected HSSFCellStyle emptyCellStyle = null;
    protected short whiteIndex = new HSSFColor.WHITE().getIndex();
    protected short blackIndex = new HSSFColor.BLACK().getIndex();
    protected short backgroundMode = 1;
    protected HSSFDataFormat dataFormat = null;
    protected Map formatPatternsMap = null;
    protected ExporterNature nature = null;
    protected HSSFPatriarch patriarch = null;

    protected void setParameters() {
        super.setParameters();
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
        this.nature = new JRXlsExporterNature(this.filter, this.isIgnoreGraphics, this.isIgnorePageMargins);
    }

    protected void setBackground() {
        if (!this.isWhitePageBackground) {
            this.backgroundMode = 0;
        }
    }

    protected void openWorkbook(OutputStream os) {
        this.workbook = new HSSFWorkbook();
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
        this.dataFormat = this.workbook.createDataFormat();
    }

    protected void createSheet(String name) {
        this.sheet = this.workbook.createSheet(name);
        this.patriarch = this.sheet.createDrawingPatriarch();
        this.sheet.getPrintSetup().setLandscape(this.jasperPrint.getOrientation() == 2);
        short paperSize = this.getSuitablePaperSize(this.jasperPrint);
        if (paperSize != -1) {
            this.sheet.getPrintSetup().setPaperSize(paperSize);
        }
    }

    protected void closeWorkbook(OutputStream os) throws JRException {
        try {
            this.workbook.write(os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void setColumnWidth(int col, int width) {
        this.sheet.setColumnWidth(col, width);
    }

    protected void setRowHeight(int rowIndex, int lastRowHeight) {
        this.row = this.sheet.getRow(rowIndex);
        if (this.row == null) {
            this.row = this.sheet.createRow(rowIndex);
        }
        this.row.setHeightInPoints((float)lastRowHeight);
    }

    protected void setCell(int colIndex, int rowIndex) {
        HSSFCell emptyCell = this.row.getCell(colIndex);
        if (emptyCell == null) {
            emptyCell = this.row.createCell(colIndex);
            emptyCell.setCellStyle(this.emptyCellStyle);
        }
    }

    protected void removeColumn(int colIndex) {
        this.sheet.setColumnHidden(colIndex, true);
    }

    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        this.cell = this.row.createCell(colIndex);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        short forecolor = this.blackIndex;
        if (gridCell.getForecolor() != null) {
            forecolor = JRXlsExporter.getNearestColor(gridCell.getForecolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null), gridCell);
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = JRXlsExporter.getNearestColor(line.getLinePen().getLineColor()).getIndex();
        int side = 0;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirection() == 1 ? 0 : 2) : (line.getDirection() == 1 ? 1 : 3);
        BoxStyle boxStyle = new BoxStyle(side, line.getLinePen());
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null), boxStyle);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = JRXlsExporter.getNearestColor(element.getLinePen().getLineColor()).getIndex();
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null), gridCell);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportText(JRPrintText textElement, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRStyledText styledText = this.getStyledText(textElement);
        if (styledText == null) {
            return;
        }
        short forecolor = JRXlsExporter.getNearestColor(textElement.getForecolor()).getIndex();
        JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JRXlsExporter.getTextAlignHolder(textElement);
        short horizontalAlignment = this.getHorizontalAlignment(textAlignHolder);
        short verticalAlignment = this.getVerticalAlignment(textAlignHolder);
        short rotation = this.getRotation(textAlignHolder);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        StyleInfo baseStyle = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, this.getLoadedFont(textElement, forecolor, null), gridCell);
        this.createTextCell(textElement, gridCell, colIndex, rowIndex, styledText, baseStyle, forecolor);
    }

    protected void createTextCell(final JRPrintText textElement, final JRExporterGridCell gridCell, final int colIndex, final int rowIndex, final JRStyledText styledText, final StyleInfo baseStyle, final short forecolor) throws JRException {
        String textStr;
        block13: {
            String formula = textElement.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.formula");
            textStr = styledText.getText();
            if (formula != null) {
                if ((formula = formula.trim()).startsWith("=")) {
                    formula = formula.substring(1);
                }
                try {
                    TextValue value = this.getTextValue(textElement, textStr);
                    if (value instanceof NumberTextValue && ((NumberTextValue)value).getPattern() != null) {
                        baseStyle.setDataFormat(this.dataFormat.getFormat(this.getConvertedPattern(((NumberTextValue)value).getPattern())));
                    } else if (value instanceof DateTextValue && ((DateTextValue)value).getPattern() != null) {
                        baseStyle.setDataFormat(this.dataFormat.getFormat(this.getConvertedPattern(((DateTextValue)value).getPattern())));
                    }
                    HSSFCellStyle cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    this.cell.setCellType(2);
                    this.cell.setCellFormula(formula);
                    this.endCreateCell(cellStyle);
                    return;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block13;
                    log.warn(e.getMessage());
                }
            }
        }
        if (this.isDetectCellType) {
            TextValue value = this.getTextValue(textElement, textStr);
            value.handle(new TextValueHandler(){

                public void handle(StringTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    JRXlsExporter.this.setRichTextStringCellValue(styledText, forecolor, textElement);
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(NumberTextValue textValue) {
                    if (textValue.getPattern() != null) {
                        baseStyle.setDataFormat(JRXlsExporter.this.dataFormat.getFormat(JRXlsExporter.this.getConvertedPattern(textValue.getPattern())));
                    }
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue().doubleValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(DateTextValue textValue) {
                    baseStyle.setDataFormat(JRXlsExporter.this.dataFormat.getFormat(JRXlsExporter.this.getConvertedPattern(textValue.getPattern())));
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(BooleanTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue().booleanValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }
            });
        } else if (this.isAutoDetectCellType) {
            HSSFCellStyle cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
            try {
                this.cell.setCellValue(Double.parseDouble(textStr));
            }
            catch (NumberFormatException e) {
                this.setRichTextStringCellValue(styledText, forecolor, textElement);
            }
            this.endCreateCell(cellStyle);
        } else {
            HSSFCellStyle cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
            this.setRichTextStringCellValue(styledText, forecolor, textElement);
            this.endCreateCell(cellStyle);
        }
    }

    protected HSSFCellStyle initCreateCell(JRExporterGridCell gridCell, int colIndex, int rowIndex, StyleInfo baseStyle) {
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(baseStyle);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        return cellStyle;
    }

    protected void endCreateCell(HSSFCellStyle cellStyle) {
        this.cell.setCellStyle(cellStyle);
    }

    protected final void setRichTextStringCellValue(JRStyledText styledText, short forecolor, JRFont defaultFont) {
        if (styledText != null) {
            this.cell.setCellValue(this.getRichTextString(styledText, forecolor, defaultFont));
        }
    }

    protected HSSFRichTextString getRichTextString(JRStyledText styledText, short forecolor, JRFont defaultFont) {
        String text = styledText.getText();
        HSSFRichTextString richTextStr = new HSSFRichTextString(text);
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            JRFont runFont = attributes.isEmpty() ? defaultFont : new JRBaseFont(attributes);
            short runForecolor = attributes.get(TextAttribute.FOREGROUND) != null ? JRXlsExporter.getNearestColor((Color)attributes.get(TextAttribute.FOREGROUND)).getIndex() : forecolor;
            HSSFFont font = this.getLoadedFont(runFont, runForecolor, attributes);
            richTextStr.applyFont(iterator.getIndex(), runLimit, font);
            iterator.setIndex(runLimit);
        }
        return richTextStr;
    }

    protected void createMergeRegion(JRExporterGridCell gridCell, int colIndex, int rowIndex, HSSFCellStyle cellStyle) {
        int rowSpan;
        int n = rowSpan = this.isCollapseRowSpan ? 1 : gridCell.getRowSpan();
        if (gridCell.getColSpan() > 1 || rowSpan > 1) {
            this.sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan - 1, colIndex, colIndex + gridCell.getColSpan() - 1));
            for (int i = 0; i < rowSpan; ++i) {
                HSSFRow spanRow = this.sheet.getRow(rowIndex + i);
                if (spanRow == null) {
                    spanRow = this.sheet.createRow(rowIndex + i);
                }
                for (int j = 0; j < gridCell.getColSpan(); ++j) {
                    HSSFCell spanCell = spanRow.getCell(colIndex + j);
                    if (spanCell == null) {
                        spanCell = spanRow.createCell(colIndex + j);
                    }
                    spanCell.setCellStyle(cellStyle);
                }
            }
        }
    }

    private short getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    private short getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    private short getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case 1: {
                return 90;
            }
            case 2: {
                return -90;
            }
        }
        return 0;
    }

    protected static HSSFColor getNearestColor(Color awtColor) {
        HSSFColor color = (HSSFColor)hssfColorsCache.get(awtColor);
        if (color == null) {
            Set keys;
            Hashtable triplets = HSSFColor.getTripletHash();
            if (triplets != null && (keys = triplets.keySet()) != null && keys.size() > 0) {
                Object key = null;
                HSSFColor crtColor = null;
                short[] rgb = null;
                int diff = 0;
                int minDiff = 999;
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    key = it.next();
                    crtColor = (HSSFColor)triplets.get(key);
                    rgb = crtColor.getTriplet();
                    diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            hssfColorsCache.put(awtColor, color);
        }
        return color;
    }

    protected HSSFFont getLoadedFont(JRFont font, short forecolor, Map attributes) {
        HSSFFont cellFont = null;
        String fontName = font.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
            fontName = (String)this.fontMap.get(fontName);
        }
        short superscriptType = 0;
        if (attributes != null && attributes.get(TextAttribute.SUPERSCRIPT) != null) {
            Object value = attributes.get(TextAttribute.SUPERSCRIPT);
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(value)) {
                superscriptType = 1;
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
                superscriptType = 2;
            }
        }
        for (int i = 0; i < this.loadedFonts.size(); ++i) {
            HSSFFont cf = (HSSFFont)this.loadedFonts.get(i);
            short fontSize = (short)font.getFontSize();
            if (this.isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            if (!cf.getFontName().equals(fontName) || cf.getColor() != forecolor || cf.getFontHeightInPoints() != fontSize || !(cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) || cf.getStrikeout() != font.isStrikeThrough() || !(cf.getBoldweight() == 700 ? font.isBold() : !font.isBold()) || cf.getItalic() != font.isItalic() || cf.getTypeOffset() != superscriptType) continue;
            cellFont = cf;
            break;
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(fontName);
            cellFont.setColor(forecolor);
            short fontSize = (short)font.getFontSize();
            if (this.isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            cellFont.setFontHeightInPoints(fontSize);
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBoldweight((short)700);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            cellFont.setTypeOffset(superscriptType);
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    protected HSSFCellStyle getLoadedCellStyle(StyleInfo style) {
        HSSFCellStyle cellStyle = (HSSFCellStyle)this.loadedCellStyles.get(style);
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(style.backcolor);
            cellStyle.setFillPattern(style.mode);
            cellStyle.setAlignment(style.horizontalAlignment);
            cellStyle.setVerticalAlignment(style.verticalAlignment);
            cellStyle.setRotation(style.rotation);
            cellStyle.setFont(style.font);
            cellStyle.setWrapText(true);
            if (style.hasDataFormat()) {
                cellStyle.setDataFormat(style.getDataFormat());
            }
            if (!this.isIgnoreCellBorder) {
                BoxStyle box = style.box;
                cellStyle.setBorderTop(box.borderStyle[0]);
                cellStyle.setTopBorderColor(box.borderColour[0]);
                cellStyle.setBorderLeft(box.borderStyle[1]);
                cellStyle.setLeftBorderColor(box.borderColour[1]);
                cellStyle.setBorderBottom(box.borderStyle[2]);
                cellStyle.setBottomBorderColor(box.borderColour[2]);
                cellStyle.setBorderRight(box.borderStyle[3]);
                cellStyle.setRightBorderColor(box.borderColour[3]);
            }
            this.loadedCellStyles.put(style, cellStyle);
        }
        return cellStyle;
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
        StyleInfo style = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, gridCell);
        return this.getLoadedCellStyle(style);
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box) {
        StyleInfo style = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box);
        return this.getLoadedCellStyle(style);
    }

    protected static short getBorderStyle(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyle()) {
                case 3: {
                    return 6;
                }
                case 2: {
                    return 7;
                }
                case 1: {
                    return 3;
                }
            }
            if (lineWidth >= 2.0f) {
                return 5;
            }
            if (lineWidth >= 1.0f) {
                return 2;
            }
            if (lineWidth >= 0.5f) {
                return 1;
            }
            return 4;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportImage(JRPrintImage element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols) throws JRException {
        try {
            int topPadding = Math.max(element.getLineBox().getTopPadding(), this.getImageBorderCorrection(element.getLineBox().getTopPen()));
            int leftPadding = Math.max(element.getLineBox().getLeftPadding(), this.getImageBorderCorrection(element.getLineBox().getLeftPen()));
            int bottomPadding = Math.max(element.getLineBox().getBottomPadding(), this.getImageBorderCorrection(element.getLineBox().getBottomPen()));
            int rightPadding = Math.max(element.getLineBox().getRightPadding(), this.getImageBorderCorrection(element.getLineBox().getRightPen()));
            int availableImageWidth = element.getWidth() - leftPadding - rightPadding;
            availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
            int availableImageHeight = element.getHeight() - topPadding - bottomPadding;
            availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
            JRRenderable renderer = element.getRenderer();
            if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
                if (renderer.getType() == 0 && (renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, element.getOnErrorType())) != null) {
                    renderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, element.getOnErrorType());
                }
            } else {
                renderer = null;
            }
            if (renderer != null) {
                int normalWidth = availableImageWidth;
                int normalHeight = availableImageHeight;
                Dimension2D dimension = renderer.getDimension();
                if (dimension != null) {
                    normalWidth = (int)dimension.getWidth();
                    normalHeight = (int)dimension.getHeight();
                }
                float xalignFactor = 0.0f;
                switch (element.getHorizontalAlignment()) {
                    case 3: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (element.getVerticalAlignment()) {
                    case 3: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                BufferedImage bi = new BufferedImage(element.getWidth(), element.getHeight(), 2);
                Graphics2D grx = bi.createGraphics();
                switch (element.getScaleImage()) {
                    case 1: {
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        Shape oldClipShape = grx.getClip();
                        grx.clip(new Rectangle(leftPadding, topPadding, availableImageWidth, availableImageHeight));
                        try {
                            renderer.render(grx, new Rectangle(xoffset + leftPadding, yoffset + topPadding, normalWidth, normalHeight));
                            break;
                        }
                        finally {
                            grx.setClip(oldClipShape);
                        }
                    }
                    case 2: {
                        renderer.render(grx, new Rectangle(leftPadding, topPadding, availableImageWidth, availableImageHeight));
                        break;
                    }
                    default: {
                        if (element.getHeight() <= 0) break;
                        double ratio = (double)normalWidth / (double)normalHeight;
                        if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                            normalWidth = availableImageWidth;
                            normalHeight = (int)((double)availableImageWidth / ratio);
                        } else {
                            normalWidth = (int)((double)availableImageHeight * ratio);
                            normalHeight = availableImageHeight;
                        }
                        int xoffset = leftPadding + (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        int yoffset = topPadding + (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        renderer.render(grx, new Rectangle(xoffset, yoffset, normalWidth, normalHeight));
                    }
                }
                short mode = this.backgroundMode;
                short backcolor = this.whiteIndex;
                if (gridCell.getCellBackcolor() != null) {
                    mode = 1;
                    backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
                }
                short forecolor = JRXlsExporter.getNearestColor(element.getLineBox().getPen().getLineColor()).getIndex();
                if (element.getMode() == 1) {
                    backcolor = JRXlsExporter.getNearestColor(element.getBackcolor()).getIndex();
                }
                HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null), gridCell);
                this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
                this.cell = this.row.createCell(colIndex);
                this.cell.setCellStyle(cellStyle);
                HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)colIndex, rowIndex, (short)(colIndex + gridCell.getColSpan()), rowIndex + (this.isCollapseRowSpan ? 1 : gridCell.getRowSpan()));
                anchor.setAnchorType(2);
                int imgIndex = this.workbook.addPicture(JRImageLoader.loadImageDataFromAWTImage(bi, (byte)3), 6);
                this.patriarch.createPicture(anchor, imgIndex);
            }
        }
        catch (Exception ex) {
            throw new JRException("The cell cannot be added", ex);
        }
        catch (Error err) {
            throw new JRException("The cell cannot be added", err);
        }
    }

    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int x, int y) {
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (frame.getMode() == 1) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(frame.getBackcolor()).getIndex();
        }
        short forecolor = JRXlsExporter.getNearestColor(frame.getForecolor()).getIndex();
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null), gridCell);
        this.createMergeRegion(gridCell, x, y, cellStyle);
        this.cell = this.row.createCell(x);
        this.cell.setCellStyle(cellStyle);
    }

    protected ExporterNature getNature() {
        return this.nature;
    }

    private String getConvertedPattern(String pattern) {
        if (this.formatPatternsMap != null && this.formatPatternsMap.containsKey(pattern)) {
            return (String)this.formatPatternsMap.get(pattern);
        }
        return pattern;
    }

    private final short getSuitablePaperSize(JasperPrint jasP) {
        if (jasP == null) {
            return -1;
        }
        long width = 0L;
        long height = 0L;
        int ps = -1;
        if (jasP.getPageWidth() != 0 && jasP.getPageHeight() != 0) {
            double dWidth = (double)jasP.getPageWidth() / 72.0;
            double dHeight = (double)jasP.getPageHeight() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 4; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 4) {
                    ps = 9;
                    break;
                }
                if (i != 5) break;
                ps = 11;
                break;
            }
            if (ps == -1 && (width == 110L && height == 220L || width == 220L && height == 110L)) {
                ps = 27;
            }
            if (ps == -1) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = 1;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = 5;
                } else if (width == 190L && height == 254L || width == 254L && height == 190L) {
                    ps = 7;
                }
            }
        }
        return (short)ps;
    }

    protected static class StyleInfo {
        protected final short mode;
        protected final short backcolor;
        protected final short horizontalAlignment;
        protected final short verticalAlignment;
        protected final short rotation;
        protected final HSSFFont font;
        protected final BoxStyle box;
        private short dataFormat = (short)-1;
        private int hashCode;

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, new BoxStyle(gridCell));
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = box;
            this.hashCode = this.computeHash();
        }

        protected int computeHash() {
            int hash = this.mode;
            hash = 31 * hash + this.backcolor;
            hash = 31 * hash + this.horizontalAlignment;
            hash = 31 * hash + this.verticalAlignment;
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + (this.font == null ? 0 : (int)this.font.getIndex());
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            hash = 31 * hash + this.dataFormat;
            return hash;
        }

        public void setDataFormat(short dataFormat) {
            this.dataFormat = dataFormat;
            this.hashCode = this.computeHash();
        }

        public boolean hasDataFormat() {
            return this.dataFormat != -1;
        }

        public short getDataFormat() {
            return this.dataFormat;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo s = (StyleInfo)o;
            return s.mode == this.mode && s.backcolor == this.backcolor && s.horizontalAlignment == this.horizontalAlignment && s.verticalAlignment == this.verticalAlignment && s.rotation == this.rotation && (s.font == null ? this.font == null : this.font != null && s.font.getIndex() == this.font.getIndex()) && (s.box == null ? this.box == null : this.box != null && s.box.equals(this.box)) && s.rotation == this.rotation;
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.dataFormat + ")";
        }
    }

    protected static class BoxStyle {
        protected static final int TOP = 0;
        protected static final int LEFT = 1;
        protected static final int BOTTOM = 2;
        protected static final int RIGHT = 3;
        protected short[] borderStyle = new short[4];
        protected short[] borderColour = new short[4];
        private int hash;

        public BoxStyle(int side, JRPen pen) {
            this.borderStyle[side] = JRXlsExporter.getBorderStyle(pen);
            this.borderColour[side] = JRXlsExporter.getNearestColor(pen.getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public BoxStyle(JRExporterGridCell gridCell) {
            JRPrintElement element;
            JRLineBox lineBox = gridCell.getBox();
            if (lineBox != null) {
                this.setBox(lineBox);
            }
            if ((element = gridCell.getElement()) instanceof JRCommonGraphicElement) {
                this.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
            }
            this.hash = this.computeHash();
        }

        public void setBox(JRLineBox box) {
            this.borderStyle[0] = JRXlsExporter.getBorderStyle(box.getTopPen());
            this.borderColour[0] = JRXlsExporter.getNearestColor(box.getTopPen().getLineColor()).getIndex();
            this.borderStyle[2] = JRXlsExporter.getBorderStyle(box.getBottomPen());
            this.borderColour[2] = JRXlsExporter.getNearestColor(box.getBottomPen().getLineColor()).getIndex();
            this.borderStyle[1] = JRXlsExporter.getBorderStyle(box.getLeftPen());
            this.borderColour[1] = JRXlsExporter.getNearestColor(box.getLeftPen().getLineColor()).getIndex();
            this.borderStyle[3] = JRXlsExporter.getBorderStyle(box.getRightPen());
            this.borderColour[3] = JRXlsExporter.getNearestColor(box.getRightPen().getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.borderStyle[0] == 0 && this.borderStyle[1] == 0 && this.borderStyle[2] == 0 && this.borderStyle[3] == 0) {
                short style = JRXlsExporter.getBorderStyle(pen);
                short colour = JRXlsExporter.getNearestColor(pen.getLineColor()).getIndex();
                this.borderStyle[0] = style;
                this.borderStyle[2] = style;
                this.borderStyle[1] = style;
                this.borderStyle[3] = style;
                this.borderColour[0] = colour;
                this.borderColour[2] = colour;
                this.borderColour[1] = colour;
                this.borderColour[3] = colour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.borderStyle[0];
            hashCode = 31 * hashCode + this.borderColour[0];
            hashCode = 31 * hashCode + this.borderStyle[2];
            hashCode = 31 * hashCode + this.borderColour[2];
            hashCode = 31 * hashCode + this.borderStyle[1];
            hashCode = 31 * hashCode + this.borderColour[1];
            hashCode = 31 * hashCode + this.borderStyle[3];
            hashCode = 31 * hashCode + this.borderColour[3];
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.borderStyle[0] == this.borderStyle[0] && b.borderColour[0] == this.borderColour[0] && b.borderStyle[2] == this.borderStyle[2] && b.borderColour[2] == this.borderColour[2] && b.borderStyle[1] == this.borderStyle[1] && b.borderColour[1] == this.borderColour[1] && b.borderStyle[3] == this.borderStyle[3] && b.borderColour[3] == this.borderColour[3];
        }

        public String toString() {
            return "(" + this.borderStyle[0] + "/" + this.borderColour[0] + "," + this.borderStyle[2] + "/" + this.borderColour[2] + "," + this.borderStyle[1] + "/" + this.borderColour[1] + "," + this.borderStyle[3] + "/" + this.borderColour[3] + ")";
        }
    }
}

