/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.SimpleFileResolver;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import net.sf.jasperreports.view.JRHyperlinkListener;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.save.JRPrintSaveContributor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRViewer
extends JPanel
implements JRHyperlinkListener {
    private static final Log log = LogFactory.getLog(JRViewer.class);
    private static final long serialVersionUID = 10200L;
    public static final String VIEWER_RENDER_BUFFER_MAX_SIZE = "net.sf.jasperreports.viewer.render.buffer.max.size";
    protected static final int TYPE_FILE_NAME = 1;
    protected static final int TYPE_INPUT_STREAM = 2;
    protected static final int TYPE_OBJECT = 3;
    public static final int REPORT_RESOLUTION = 72;
    protected float MIN_ZOOM = 0.5f;
    protected float MAX_ZOOM = 10.0f;
    protected int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250, 400, 800};
    protected int defaultZoomIndex = 2;
    protected int type = 1;
    protected boolean isXML = false;
    protected String reportFileName = null;
    protected SimpleFileResolver fileResolver = null;
    JasperPrint jasperPrint = null;
    private int pageIndex = 0;
    private boolean pageError;
    protected float zoom = 0.0f;
    private JRGraphics2DExporter exporter = null;
    private int screenResolution = 72;
    protected float realZoom = 0.0f;
    private DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    private ResourceBundle resourceBundle = null;
    private int downX = 0;
    private int downY = 0;
    private List hyperlinkListeners = new ArrayList();
    private Map linksMap = new HashMap();
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent evt) {
            JRViewer.this.hyperlinkClicked(evt);
        }
    };
    protected KeyListener keyNavigationListener = new KeyListener(){

        public void keyTyped(KeyEvent evt) {
        }

        public void keyPressed(KeyEvent evt) {
            JRViewer.this.keyNavigate(evt);
        }

        public void keyReleased(KeyEvent evt) {
        }
    };
    protected List saveContributors = new ArrayList();
    protected File lastFolder = null;
    protected JRSaveContributor lastSaveContributor = null;
    protected JToggleButton btnActualSize;
    protected JButton btnFirst;
    protected JToggleButton btnFitPage;
    protected JToggleButton btnFitWidth;
    protected JButton btnLast;
    protected JButton btnNext;
    protected JButton btnPrevious;
    protected JButton btnPrint;
    protected JButton btnReload;
    protected JButton btnSave;
    protected JButton btnZoomIn;
    protected JButton btnZoomOut;
    protected JComboBox cmbZoom;
    private JLabel jLabel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private PageRenderer lblPage;
    protected JLabel lblStatus;
    private JPanel pnlInScroll;
    private JPanel pnlLinks;
    private JPanel pnlMain;
    private JPanel pnlPage;
    protected JPanel pnlSep01;
    protected JPanel pnlSep02;
    protected JPanel pnlSep03;
    protected JPanel pnlStatus;
    private JScrollPane scrollPane;
    protected JPanel tlbToolBar;
    protected JTextField txtGoTo;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$ResourceBundle;

    public JRViewer(String fileName, boolean isXML) throws JRException {
        this(fileName, isXML, null);
    }

    public JRViewer(InputStream is, boolean isXML) throws JRException {
        this(is, isXML, null);
    }

    public JRViewer(JasperPrint jrPrint) {
        this(jrPrint, null);
    }

    public JRViewer(String fileName, boolean isXML, Locale locale) throws JRException {
        this(fileName, isXML, locale, null);
    }

    public JRViewer(InputStream is, boolean isXML, Locale locale) throws JRException {
        this(is, isXML, locale, null);
    }

    public JRViewer(JasperPrint jrPrint, Locale locale) {
        this(jrPrint, locale, null);
    }

    public JRViewer(String fileName, boolean isXML, Locale locale, ResourceBundle resBundle) throws JRException {
        this.initResources(locale, resBundle);
        this.setScreenDetails();
        this.setZooms();
        this.initComponents();
        this.loadReport(fileName, isXML);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        this.addHyperlinkListener(this);
    }

    public JRViewer(InputStream is, boolean isXML, Locale locale, ResourceBundle resBundle) throws JRException {
        this.initResources(locale, resBundle);
        this.setScreenDetails();
        this.setZooms();
        this.initComponents();
        this.loadReport(is, isXML);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        this.addHyperlinkListener(this);
    }

    public JRViewer(JasperPrint jrPrint, Locale locale, ResourceBundle resBundle) {
        this.initResources(locale, resBundle);
        this.setScreenDetails();
        this.setZooms();
        this.initComponents();
        this.loadReport(jrPrint);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        this.addHyperlinkListener(this);
    }

    private void setScreenDetails() {
        this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public void clear() {
        this.emptyContainer(this);
        this.jasperPrint = null;
    }

    protected void setZooms() {
    }

    public void addSaveContributor(JRSaveContributor contributor) {
        this.saveContributors.add(contributor);
    }

    public void removeSaveContributor(JRSaveContributor contributor) {
        this.saveContributors.remove(contributor);
    }

    public JRSaveContributor[] getSaveContributors() {
        return this.saveContributors.toArray(new JRSaveContributor[this.saveContributors.size()]);
    }

    public void setSaveContributors(JRSaveContributor[] saveContributors) {
        this.saveContributors = new ArrayList();
        if (saveContributors != null) {
            this.saveContributors.addAll(Arrays.asList(saveContributors));
        }
    }

    public void addHyperlinkListener(JRHyperlinkListener listener) {
        this.hyperlinkListeners.add(listener);
    }

    public void removeHyperlinkListener(JRHyperlinkListener listener) {
        this.hyperlinkListeners.remove(listener);
    }

    public JRHyperlinkListener[] getHyperlinkListeners() {
        return this.hyperlinkListeners.toArray(new JRHyperlinkListener[this.hyperlinkListeners.size()]);
    }

    protected void initResources(Locale locale, ResourceBundle resBundle) {
        if (locale != null) {
            this.setLocale(locale);
        } else {
            this.setLocale(Locale.getDefault());
        }
        this.resourceBundle = resBundle == null ? ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", this.getLocale()) : resBundle;
    }

    protected String getBundleString(String key) {
        return this.resourceBundle.getString(key);
    }

    protected void initSaveContributors() {
        String[] DEFAULT_CONTRIBUTORS = new String[]{"net.sf.jasperreports.view.save.JRPrintSaveContributor", "net.sf.jasperreports.view.save.JRPdfSaveContributor", "net.sf.jasperreports.view.save.JRRtfSaveContributor", "net.sf.jasperreports.view.save.JROdtSaveContributor", "net.sf.jasperreports.view.save.JRHtmlSaveContributor", "net.sf.jasperreports.view.save.JRSingleSheetXlsSaveContributor", "net.sf.jasperreports.view.save.JRMultipleSheetsXlsSaveContributor", "net.sf.jasperreports.view.save.JRCsvSaveContributor", "net.sf.jasperreports.view.save.JRXmlSaveContributor", "net.sf.jasperreports.view.save.JREmbeddedImagesXmlSaveContributor"};
        for (int i = 0; i < DEFAULT_CONTRIBUTORS.length; ++i) {
            try {
                Class saveContribClass = JRClassLoader.loadClassForName(DEFAULT_CONTRIBUTORS[i]);
                Constructor constructor = saveContribClass.getConstructor(class$java$util$Locale == null ? JRViewer.class$("java.util.Locale") : class$java$util$Locale, class$java$util$ResourceBundle == null ? JRViewer.class$("java.util.ResourceBundle") : class$java$util$ResourceBundle);
                JRSaveContributor saveContrib = (JRSaveContributor)constructor.newInstance(this.getLocale(), this.resourceBundle);
                this.saveContributors.add(saveContrib);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void gotoHyperlink(JRPrintHyperlink hyperlink) {
        switch (hyperlink.getHyperlinkType()) {
            case 2: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 3: {
                Container container;
                if (hyperlink.getHyperlinkAnchor() == null) break;
                Map anchorIndexes = this.jasperPrint.getAnchorIndexes();
                JRPrintAnchorIndex anchorIndex = (JRPrintAnchorIndex)anchorIndexes.get(hyperlink.getHyperlinkAnchor());
                if (anchorIndex.getPageIndex() != this.pageIndex) {
                    this.setPageIndex(anchorIndex.getPageIndex());
                    this.refreshPage();
                }
                if (!((container = this.pnlInScroll.getParent()) instanceof JViewport)) break;
                JViewport viewport = (JViewport)container;
                int newX = (int)((float)anchorIndex.getElementAbsoluteX() * this.realZoom);
                int newY = (int)((float)anchorIndex.getElementAbsoluteY() * this.realZoom);
                int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
                int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
                if (newX < 0) {
                    newX = 0;
                }
                if (newX > maxX) {
                    newX = maxX;
                }
                if (newY < 0) {
                    newY = 0;
                }
                if (newY > maxY) {
                    newY = maxY;
                }
                viewport.setViewPosition(new Point(newX, newY));
                break;
            }
            case 4: {
                int page = this.pageIndex + 1;
                if (hyperlink.getHyperlinkPage() != null) {
                    page = hyperlink.getHyperlinkPage();
                }
                if (page < 1 || page > this.jasperPrint.getPages().size() || page == this.pageIndex + 1) break;
                this.setPageIndex(page - 1);
                this.refreshPage();
                Container container = this.pnlInScroll.getParent();
                if (!(container instanceof JViewport)) break;
                JViewport viewport = (JViewport)container;
                viewport.setViewPosition(new Point(0, 0));
                break;
            }
            case 5: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Hyperlink anchor    : " + hyperlink.getHyperlinkAnchor());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 6: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Hyperlink page      : " + hyperlink.getHyperlinkPage());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 7: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink of type " + hyperlink.getLinkType());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
        }
    }

    protected boolean isOnlyHyperlinkListener() {
        int listenerCount;
        if (this.hyperlinkListeners == null) {
            listenerCount = 0;
        } else {
            listenerCount = this.hyperlinkListeners.size();
            if (this.hyperlinkListeners.contains(this)) {
                --listenerCount;
            }
        }
        return listenerCount == 0;
    }

    private void initComponents() {
        this.tlbToolBar = new JPanel();
        this.btnSave = new JButton();
        this.btnPrint = new JButton();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.btnFirst = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.btnLast = new JButton();
        this.txtGoTo = new JTextField();
        this.pnlSep02 = new JPanel();
        this.btnActualSize = new JToggleButton();
        this.btnFitPage = new JToggleButton();
        this.btnFitWidth = new JToggleButton();
        this.pnlSep03 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.zooms.length; ++i) {
            model.addElement("" + this.zooms[i] + "%");
        }
        this.cmbZoom.setModel(model);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.pnlLinks = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new PageRenderer(this);
        this.pnlStatus = new JPanel();
        this.lblStatus = new JLabel();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(450, 150));
        this.setPreferredSize(new Dimension(450, 150));
        this.tlbToolBar.setLayout(new FlowLayout(0, 0, 2));
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/save.GIF")));
        this.btnSave.setToolTipText(this.getBundleString("save"));
        this.btnSave.setMargin(new Insets(2, 2, 2, 2));
        this.btnSave.setMaximumSize(new Dimension(23, 23));
        this.btnSave.setMinimumSize(new Dimension(23, 23));
        this.btnSave.setPreferredSize(new Dimension(23, 23));
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnSaveActionPerformed(evt);
            }
        });
        this.btnSave.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnSave);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/print.GIF")));
        this.btnPrint.setToolTipText(this.getBundleString("print"));
        this.btnPrint.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrint.setMaximumSize(new Dimension(23, 23));
        this.btnPrint.setMinimumSize(new Dimension(23, 23));
        this.btnPrint.setPreferredSize(new Dimension(23, 23));
        this.btnPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnPrintActionPerformed(evt);
            }
        });
        this.btnPrint.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnPrint);
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/reload.GIF")));
        this.btnReload.setToolTipText(this.getBundleString("reload"));
        this.btnReload.setMargin(new Insets(2, 2, 2, 2));
        this.btnReload.setMaximumSize(new Dimension(23, 23));
        this.btnReload.setMinimumSize(new Dimension(23, 23));
        this.btnReload.setPreferredSize(new Dimension(23, 23));
        this.btnReload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnReloadActionPerformed(evt);
            }
        });
        this.btnReload.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.btnFirst.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/first.GIF")));
        this.btnFirst.setToolTipText(this.getBundleString("first.page"));
        this.btnFirst.setMargin(new Insets(2, 2, 2, 2));
        this.btnFirst.setMaximumSize(new Dimension(23, 23));
        this.btnFirst.setMinimumSize(new Dimension(23, 23));
        this.btnFirst.setPreferredSize(new Dimension(23, 23));
        this.btnFirst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnFirstActionPerformed(evt);
            }
        });
        this.btnFirst.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnFirst);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/previous.GIF")));
        this.btnPrevious.setToolTipText(this.getBundleString("previous.page"));
        this.btnPrevious.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrevious.setMaximumSize(new Dimension(23, 23));
        this.btnPrevious.setMinimumSize(new Dimension(23, 23));
        this.btnPrevious.setPreferredSize(new Dimension(23, 23));
        this.btnPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnPreviousActionPerformed(evt);
            }
        });
        this.btnPrevious.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnPrevious);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/next.GIF")));
        this.btnNext.setToolTipText(this.getBundleString("next.page"));
        this.btnNext.setMargin(new Insets(2, 2, 2, 2));
        this.btnNext.setMaximumSize(new Dimension(23, 23));
        this.btnNext.setMinimumSize(new Dimension(23, 23));
        this.btnNext.setPreferredSize(new Dimension(23, 23));
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnNextActionPerformed(evt);
            }
        });
        this.btnNext.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnNext);
        this.btnLast.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/last.GIF")));
        this.btnLast.setToolTipText(this.getBundleString("last.page"));
        this.btnLast.setMargin(new Insets(2, 2, 2, 2));
        this.btnLast.setMaximumSize(new Dimension(23, 23));
        this.btnLast.setMinimumSize(new Dimension(23, 23));
        this.btnLast.setPreferredSize(new Dimension(23, 23));
        this.btnLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnLastActionPerformed(evt);
            }
        });
        this.btnLast.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnLast);
        this.txtGoTo.setToolTipText(this.getBundleString("go.to.page"));
        this.txtGoTo.setMaximumSize(new Dimension(40, 23));
        this.txtGoTo.setMinimumSize(new Dimension(40, 23));
        this.txtGoTo.setPreferredSize(new Dimension(40, 23));
        this.txtGoTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.txtGoToActionPerformed(evt);
            }
        });
        this.txtGoTo.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.txtGoTo);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnActualSize.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/actualsize.GIF")));
        this.btnActualSize.setToolTipText(this.getBundleString("actual.size"));
        this.btnActualSize.setMargin(new Insets(2, 2, 2, 2));
        this.btnActualSize.setMaximumSize(new Dimension(23, 23));
        this.btnActualSize.setMinimumSize(new Dimension(23, 23));
        this.btnActualSize.setPreferredSize(new Dimension(23, 23));
        this.btnActualSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnActualSizeActionPerformed(evt);
            }
        });
        this.btnActualSize.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnActualSize);
        this.btnFitPage.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitpage.GIF")));
        this.btnFitPage.setToolTipText(this.getBundleString("fit.page"));
        this.btnFitPage.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitPage.setMaximumSize(new Dimension(23, 23));
        this.btnFitPage.setMinimumSize(new Dimension(23, 23));
        this.btnFitPage.setPreferredSize(new Dimension(23, 23));
        this.btnFitPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnFitPageActionPerformed(evt);
            }
        });
        this.btnFitPage.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnFitPage);
        this.btnFitWidth.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitwidth.GIF")));
        this.btnFitWidth.setToolTipText(this.getBundleString("fit.width"));
        this.btnFitWidth.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitWidth.setMaximumSize(new Dimension(23, 23));
        this.btnFitWidth.setMinimumSize(new Dimension(23, 23));
        this.btnFitWidth.setPreferredSize(new Dimension(23, 23));
        this.btnFitWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnFitWidthActionPerformed(evt);
            }
        });
        this.btnFitWidth.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnFitWidth);
        this.pnlSep03.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep03);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText(this.getBundleString("zoom.in"));
        this.btnZoomIn.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnZoomInActionPerformed(evt);
            }
        });
        this.btnZoomIn.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText(this.getBundleString("zoom.out"));
        this.btnZoomOut.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnZoomOutActionPerformed(evt);
            }
        });
        this.btnZoomOut.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setToolTipText(this.getBundleString("zoom.ratio"));
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.cmbZoomActionPerformed(evt);
            }
        });
        this.cmbZoom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JRViewer.this.cmbZoomItemStateChanged(evt);
            }
        });
        this.cmbZoom.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlMain.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                JRViewer.this.pnlMainComponentResized(evt);
            }
        });
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.pnlLinks.setLayout(null);
        this.pnlLinks.setMinimumSize(new Dimension(5, 5));
        this.pnlLinks.setPreferredSize(new Dimension(5, 5));
        this.pnlLinks.setOpaque(false);
        this.pnlLinks.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JRViewer.this.pnlLinksMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                JRViewer.this.pnlLinksMouseReleased(evt);
            }
        });
        this.pnlLinks.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                JRViewer.this.pnlLinksMouseDragged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.pnlLinks, gridBagConstraints);
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
        this.pnlStatus.setLayout(new FlowLayout(1, 0, 0));
        this.lblStatus.setFont(new Font("Dialog", 1, 10));
        this.lblStatus.setText("Page i of n");
        this.pnlStatus.add(this.lblStatus);
        this.add((Component)this.pnlStatus, "South");
        this.addKeyListener(this.keyNavigationListener);
    }

    void txtGoToActionPerformed(ActionEvent evt) {
        try {
            int pageNumber = Integer.parseInt(this.txtGoTo.getText());
            if (pageNumber != this.pageIndex + 1 && pageNumber > 0 && pageNumber <= this.jasperPrint.getPages().size()) {
                this.setPageIndex(pageNumber - 1);
                this.refreshPage();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void cmbZoomItemStateChanged(ItemEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
    }

    void pnlMainComponentResized(ComponentEvent evt) {
        if (this.btnFitPage.isSelected()) {
            this.fitPage();
            this.btnFitPage.setSelected(true);
        } else if (this.btnFitWidth.isSelected()) {
            this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth());
            this.btnFitWidth.setSelected(true);
        }
    }

    void btnActualSizeActionPerformed(ActionEvent evt) {
        if (this.btnActualSize.isSelected()) {
            this.btnFitPage.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.setZoomRatio(1.0f);
            this.btnActualSize.setSelected(true);
        }
    }

    void btnFitWidthActionPerformed(ActionEvent evt) {
        if (this.btnFitWidth.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitPage.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth());
            this.btnFitWidth.setSelected(true);
        }
    }

    void btnFitPageActionPerformed(ActionEvent evt) {
        if (this.btnFitPage.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.fitPage();
            this.btnFitPage.setSelected(true);
        }
    }

    void btnSaveActionPerformed(ActionEvent evt) {
        int retValue;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setLocale(this.getLocale());
        fileChooser.updateUI();
        for (int i = 0; i < this.saveContributors.size(); ++i) {
            fileChooser.addChoosableFileFilter((JRSaveContributor)this.saveContributors.get(i));
        }
        if (this.saveContributors.contains(this.lastSaveContributor)) {
            fileChooser.setFileFilter(this.lastSaveContributor);
        } else if (this.saveContributors.size() > 0) {
            fileChooser.setFileFilter((JRSaveContributor)this.saveContributors.get(0));
        }
        if (this.lastFolder != null) {
            fileChooser.setCurrentDirectory(this.lastFolder);
        }
        if ((retValue = fileChooser.showSaveDialog(this)) == 0) {
            FileFilter fileFilter = fileChooser.getFileFilter();
            File file = fileChooser.getSelectedFile();
            this.lastFolder = file.getParentFile();
            JRSaveContributor contributor = null;
            if (fileFilter instanceof JRSaveContributor) {
                contributor = (JRSaveContributor)fileFilter;
            } else {
                int i = 0;
                while (contributor == null && i < this.saveContributors.size()) {
                    if ((contributor = (JRSaveContributor)this.saveContributors.get(i++)).accept(file)) continue;
                    contributor = null;
                }
                if (contributor == null) {
                    contributor = new JRPrintSaveContributor(this.getLocale(), this.resourceBundle);
                }
            }
            this.lastSaveContributor = contributor;
            try {
                contributor.save(this.jasperPrint, file);
            }
            catch (JRException e) {
                if (log.isErrorEnabled()) {
                    log.error("Save error.", e);
                }
                JOptionPane.showMessageDialog(this, this.getBundleString("error.saving"));
            }
        }
    }

    void pnlLinksMouseDragged(MouseEvent evt) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport viewport = (JViewport)container;
            Point point = viewport.getViewPosition();
            int newX = point.x - (evt.getX() - this.downX);
            int newY = point.y - (evt.getY() - this.downY);
            int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
            int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            viewport.setViewPosition(new Point(newX, newY));
        }
    }

    void pnlLinksMouseReleased(MouseEvent evt) {
        this.pnlLinks.setCursor(new Cursor(0));
    }

    void pnlLinksMousePressed(MouseEvent evt) {
        this.pnlLinks.setCursor(new Cursor(13));
        this.downX = evt.getX();
        this.downY = evt.getY();
    }

    void btnPrintActionPerformed(ActionEvent evt) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JRViewer.this.btnPrint.setEnabled(false);
                    JRViewer.this.setCursor(Cursor.getPredefinedCursor(3));
                    JasperPrintManager.printReport(JRViewer.this.jasperPrint, true);
                }
                catch (Exception ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Print error.", ex);
                    }
                    JOptionPane.showMessageDialog(JRViewer.this, JRViewer.this.getBundleString("error.printing"));
                }
                finally {
                    JRViewer.this.setCursor(Cursor.getPredefinedCursor(0));
                    JRViewer.this.btnPrint.setEnabled(true);
                }
            }
        });
        thread.start();
    }

    void btnLastActionPerformed(ActionEvent evt) {
        this.setPageIndex(this.jasperPrint.getPages().size() - 1);
        this.refreshPage();
    }

    void btnNextActionPerformed(ActionEvent evt) {
        this.setPageIndex(this.pageIndex + 1);
        this.refreshPage();
    }

    void btnPreviousActionPerformed(ActionEvent evt) {
        this.setPageIndex(this.pageIndex - 1);
        this.refreshPage();
    }

    void btnFirstActionPerformed(ActionEvent evt) {
        this.setPageIndex(0);
        this.refreshPage();
    }

    void btnReloadActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
            }
            catch (JRException e) {
                if (log.isErrorEnabled()) {
                    log.error("Reload error.", e);
                }
                this.jasperPrint = null;
                this.setPageIndex(0);
                this.refreshPage();
                JOptionPane.showMessageDialog(this, this.getBundleString("error.loading"));
            }
            this.forceRefresh();
        }
    }

    protected void forceRefresh() {
        this.zoom = 0.0f;
        this.realZoom = 0.0f;
        this.setZoomRatio(1.0f);
    }

    void btnZoomInActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index < 0) {
            this.setZoomRatio((float)this.zooms[-index - 1] / 100.0f);
        } else if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.setZoomRatio((float)this.zooms[index + 1] / 100.0f);
        }
    }

    void btnZoomOutActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index > 0) {
            this.setZoomRatio((float)this.zooms[index - 1] / 100.0f);
        } else if (index < -1) {
            this.setZoomRatio((float)this.zooms[-index - 2] / 100.0f);
        }
    }

    void cmbZoomActionPerformed(ActionEvent evt) {
        float newZoom = this.getZoomRatio();
        if (newZoom < this.MIN_ZOOM) {
            newZoom = this.MIN_ZOOM;
        }
        if (newZoom > this.MAX_ZOOM) {
            newZoom = this.MAX_ZOOM;
        }
        this.setZoomRatio(newZoom);
    }

    void hyperlinkClicked(MouseEvent evt) {
        JPanel link = (JPanel)evt.getSource();
        JRPrintHyperlink element = (JRPrintHyperlink)this.linksMap.get(link);
        this.hyperlinkClicked(element);
    }

    protected void hyperlinkClicked(JRPrintHyperlink hyperlink) {
        try {
            JRHyperlinkListener listener = null;
            for (int i = 0; i < this.hyperlinkListeners.size(); ++i) {
                listener = (JRHyperlinkListener)this.hyperlinkListeners.get(i);
                listener.gotoHyperlink(hyperlink);
            }
        }
        catch (JRException e) {
            if (log.isErrorEnabled()) {
                log.error("Hyperlink click error.", e);
            }
            JOptionPane.showMessageDialog(this, this.getBundleString("error.hyperlink"));
        }
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    private void setPageIndex(int index) {
        if (this.jasperPrint != null && this.jasperPrint.getPages() != null && this.jasperPrint.getPages().size() > 0) {
            if (index >= 0 && index < this.jasperPrint.getPages().size()) {
                this.pageIndex = index;
                this.pageError = false;
                this.btnFirst.setEnabled(this.pageIndex > 0);
                this.btnPrevious.setEnabled(this.pageIndex > 0);
                this.btnNext.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
                this.btnLast.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
                this.txtGoTo.setEnabled(this.btnFirst.isEnabled() || this.btnLast.isEnabled());
                this.txtGoTo.setText("" + (this.pageIndex + 1));
                this.lblStatus.setText(MessageFormat.format(this.getBundleString("page"), new Integer(this.pageIndex + 1), new Integer(this.jasperPrint.getPages().size())));
            }
        } else {
            this.btnFirst.setEnabled(false);
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.txtGoTo.setEnabled(false);
            this.txtGoTo.setText("");
            this.lblStatus.setText("");
        }
    }

    protected void loadReport(String fileName, boolean isXmlReport) throws JRException {
        this.jasperPrint = isXmlReport ? JRPrintXmlLoader.load(fileName) : (JasperPrint)JRLoader.loadObject(fileName);
        this.type = 1;
        this.isXML = isXmlReport;
        this.reportFileName = fileName;
        this.fileResolver = new SimpleFileResolver(Arrays.asList(new File(fileName).getParentFile(), new File(".")));
        this.fileResolver.setResolveAbsolutePath(true);
        this.btnReload.setEnabled(true);
        this.setPageIndex(0);
    }

    protected void loadReport(InputStream is, boolean isXmlReport) throws JRException {
        this.jasperPrint = isXmlReport ? JRPrintXmlLoader.load(is) : (JasperPrint)JRLoader.loadObject(is);
        this.type = 2;
        this.isXML = isXmlReport;
        this.btnReload.setEnabled(false);
        this.setPageIndex(0);
    }

    protected void loadReport(JasperPrint jrPrint) {
        this.jasperPrint = jrPrint;
        this.type = 3;
        this.isXML = false;
        this.btnReload.setEnabled(false);
        this.setPageIndex(0);
    }

    protected void refreshPage() {
        long imageSize;
        if (this.jasperPrint == null || this.jasperPrint.getPages() == null || this.jasperPrint.getPages().size() == 0) {
            this.pnlPage.setVisible(false);
            this.btnSave.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnActualSize.setEnabled(false);
            this.btnFitPage.setEnabled(false);
            this.btnFitWidth.setEnabled(false);
            this.btnZoomIn.setEnabled(false);
            this.btnZoomOut.setEnabled(false);
            this.cmbZoom.setEnabled(false);
            if (this.jasperPrint != null) {
                JOptionPane.showMessageDialog(this, this.getBundleString("no.pages"));
            }
            return;
        }
        this.pnlPage.setVisible(true);
        this.btnSave.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnActualSize.setEnabled(true);
        this.btnFitPage.setEnabled(true);
        this.btnFitWidth.setEnabled(true);
        this.btnZoomIn.setEnabled(this.zoom < this.MAX_ZOOM);
        this.btnZoomOut.setEnabled(this.zoom > this.MIN_ZOOM);
        this.cmbZoom.setEnabled(true);
        Dimension dim = new Dimension((int)((float)this.jasperPrint.getPageWidth() * this.realZoom) + 8, (int)((float)this.jasperPrint.getPageHeight() * this.realZoom) + 8);
        this.pnlPage.setMaximumSize(dim);
        this.pnlPage.setMinimumSize(dim);
        this.pnlPage.setPreferredSize(dim);
        long maxImageSize = JRProperties.getLongProperty(VIEWER_RENDER_BUFFER_MAX_SIZE);
        boolean renderImage = maxImageSize <= 0L ? false : (imageSize = JRPrinterAWT.getImageSize(this.jasperPrint, this.realZoom)) <= maxImageSize;
        this.lblPage.setRenderImage(renderImage);
        if (renderImage) {
            this.setPageImage();
        }
        this.pnlLinks.removeAll();
        this.linksMap = new HashMap();
        this.createHyperlinks();
        if (!renderImage) {
            this.lblPage.setIcon(null);
            this.pnlMain.validate();
            this.pnlMain.repaint();
        }
    }

    protected void setPageImage() {
        Image image;
        if (this.pageError) {
            image = this.getPageErrorImage();
        } else {
            try {
                image = JasperPrintManager.printPageToImage(this.jasperPrint, this.pageIndex, this.realZoom);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("Print page to image error.", e);
                }
                this.pageError = true;
                image = this.getPageErrorImage();
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.displaying"));
            }
        }
        ImageIcon imageIcon = new ImageIcon(image);
        this.lblPage.setIcon(imageIcon);
    }

    protected Image getPageErrorImage() {
        BufferedImage image = new BufferedImage((int)((float)this.jasperPrint.getPageWidth() * this.realZoom) + 1, (int)((float)this.jasperPrint.getPageHeight() * this.realZoom) + 1, 1);
        Graphics2D grx = (Graphics2D)((Image)image).getGraphics();
        AffineTransform transform = new AffineTransform();
        transform.scale(this.realZoom, this.realZoom);
        grx.transform(transform);
        this.drawPageError(grx);
        return image;
    }

    protected void createHyperlinks() {
        List pages = this.jasperPrint.getPages();
        JRPrintPage page = (JRPrintPage)pages.get(this.pageIndex);
        this.createHyperlinks(page.getElements(), 0, 0);
    }

    protected void createHyperlinks(List elements, int offsetX, int offsetY) {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                boolean hasTooltip;
                JRRenderable renderer;
                JRPrintElement element = (JRPrintElement)it.next();
                JRImageMapRenderer imageMap = null;
                if (element instanceof JRPrintImage && (renderer = ((JRPrintImage)element).getRenderer()) instanceof JRImageMapRenderer && !(imageMap = (JRImageMapRenderer)renderer).hasImageAreaHyperlinks()) {
                    imageMap = null;
                }
                boolean hasImageMap = imageMap != null;
                JRPrintHyperlink hyperlink = null;
                if (element instanceof JRPrintHyperlink) {
                    hyperlink = (JRPrintHyperlink)((Object)element);
                }
                boolean hasHyperlink = !hasImageMap && hyperlink != null && hyperlink.getHyperlinkType() != 1;
                boolean bl = hasTooltip = hyperlink != null && hyperlink.getHyperlinkTooltip() != null;
                if (hasHyperlink || hasImageMap || hasTooltip) {
                    JPanel link;
                    if (hasImageMap) {
                        Rectangle renderingArea = new Rectangle(0, 0, element.getWidth(), element.getHeight());
                        link = new ImageMapPanel(renderingArea, imageMap);
                    } else {
                        link = new JPanel();
                        if (hasHyperlink) {
                            link.addMouseListener(this.mouseListener);
                        }
                    }
                    if (hasHyperlink) {
                        link.setCursor(new Cursor(12));
                    }
                    link.setLocation((int)((float)(element.getX() + offsetX) * this.realZoom), (int)((float)(element.getY() + offsetY) * this.realZoom));
                    link.setSize((int)((float)element.getWidth() * this.realZoom), (int)((float)element.getHeight() * this.realZoom));
                    link.setOpaque(false);
                    String toolTip = this.getHyperlinkTooltip(hyperlink);
                    if (toolTip == null && hasImageMap) {
                        toolTip = "";
                    }
                    link.setToolTipText(toolTip);
                    this.pnlLinks.add(link);
                    this.linksMap.put(link, element);
                }
                if (!(element instanceof JRPrintFrame)) continue;
                JRPrintFrame frame = (JRPrintFrame)element;
                int frameOffsetX = offsetX + frame.getX() + frame.getLineBox().getLeftPadding();
                int frameOffsetY = offsetY + frame.getY() + frame.getLineBox().getTopPadding();
                this.createHyperlinks(frame.getElements(), frameOffsetX, frameOffsetY);
            }
        }
    }

    protected String getHyperlinkTooltip(JRPrintHyperlink hyperlink) {
        String toolTip = hyperlink.getHyperlinkTooltip();
        if (toolTip == null) {
            toolTip = this.getFallbackTooltip(hyperlink);
        }
        return toolTip;
    }

    protected String getFallbackTooltip(JRPrintHyperlink hyperlink) {
        String toolTip = null;
        switch (hyperlink.getHyperlinkType()) {
            case 2: {
                toolTip = hyperlink.getHyperlinkReference();
                break;
            }
            case 3: {
                if (hyperlink.getHyperlinkAnchor() == null) break;
                toolTip = "#" + hyperlink.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (hyperlink.getHyperlinkPage() == null) break;
                toolTip = "#page " + hyperlink.getHyperlinkPage();
                break;
            }
            case 5: {
                toolTip = "";
                if (hyperlink.getHyperlinkReference() != null) {
                    toolTip = toolTip + hyperlink.getHyperlinkReference();
                }
                if (hyperlink.getHyperlinkAnchor() == null) break;
                toolTip = toolTip + "#" + hyperlink.getHyperlinkAnchor();
                break;
            }
            case 6: {
                toolTip = "";
                if (hyperlink.getHyperlinkReference() != null) {
                    toolTip = toolTip + hyperlink.getHyperlinkReference();
                }
                if (hyperlink.getHyperlinkPage() == null) break;
                toolTip = toolTip + "#page " + hyperlink.getHyperlinkPage();
                break;
            }
        }
        return toolTip;
    }

    private void emptyContainer(Container container) {
        Component[] components = container.getComponents();
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof Container)) continue;
                this.emptyContainer((Container)components[i]);
            }
        }
        components = null;
        container.removeAll();
        container = null;
    }

    private float getZoomRatio() {
        float newZoom = this.zoom;
        try {
            newZoom = this.zoomDecimalFormat.parse(String.valueOf(this.cmbZoom.getEditor().getItem())).floatValue() / 100.0f;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return newZoom;
    }

    public void setZoomRatio(float newZoom) {
        if (newZoom > 0.0f) {
            this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(newZoom * 100.0f) + "%");
            if (this.zoom != newZoom) {
                this.zoom = newZoom;
                this.realZoom = this.zoom * (float)this.screenResolution / 72.0f;
                this.refreshPage();
            }
        }
    }

    private void setRealZoomRatio(float newZoom) {
        if (newZoom > 0.0f && this.realZoom != newZoom) {
            this.zoom = newZoom * 72.0f / (float)this.screenResolution;
            this.realZoom = newZoom;
            this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(this.zoom * 100.0f) + "%");
            this.refreshPage();
        }
    }

    public void setFitWidthZoomRatio() {
        this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth());
    }

    public void setFitPageZoomRatio() {
        this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)this.jasperPrint.getPageHeight());
    }

    protected JRGraphics2DExporter getGraphics2DExporter() throws JRException {
        return new JRGraphics2DExporter();
    }

    protected void paintPage(Graphics2D grx) {
        if (this.pageError) {
            this.paintPageError(grx);
            return;
        }
        try {
            if (this.exporter == null) {
                this.exporter = this.getGraphics2DExporter();
            } else {
                this.exporter.reset();
            }
            this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
            this.exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, grx.create());
            this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(this.pageIndex));
            this.exporter.setParameter(JRGraphics2DExporterParameter.ZOOM_RATIO, new Float(this.realZoom));
            this.exporter.setParameter(JRExporterParameter.OFFSET_X, new Integer(1));
            this.exporter.setParameter(JRExporterParameter.OFFSET_Y, new Integer(1));
            if (this.type == 1) {
                this.exporter.setParameter(JRExporterParameter.FILE_RESOLVER, this.fileResolver);
            }
            this.exporter.exportReport();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Page paint error.", e);
            }
            this.pageError = true;
            this.paintPageError(grx);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(JRViewer.this, JRViewer.this.getBundleString("error.displaying"));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintPageError(Graphics2D grx) {
        AffineTransform origTransform = grx.getTransform();
        AffineTransform transform = new AffineTransform();
        transform.translate(1.0, 1.0);
        transform.scale(this.realZoom, this.realZoom);
        grx.transform(transform);
        try {
            this.drawPageError(grx);
        }
        finally {
            grx.setTransform(origTransform);
        }
    }

    protected void drawPageError(Graphics grx) {
        grx.setColor(Color.white);
        grx.fillRect(0, 0, this.jasperPrint.getPageWidth() + 1, this.jasperPrint.getPageHeight() + 1);
    }

    protected void keyNavigate(KeyEvent evt) {
        boolean refresh = true;
        switch (evt.getKeyCode()) {
            case 34: 
            case 40: {
                this.dnNavigate(evt);
                break;
            }
            case 33: 
            case 38: {
                this.upNavigate(evt);
                break;
            }
            case 36: {
                this.homeEndNavigate(0);
                break;
            }
            case 35: {
                this.homeEndNavigate(this.jasperPrint.getPages().size() - 1);
                break;
            }
            default: {
                refresh = false;
            }
        }
        if (refresh) {
            this.refreshPage();
        }
    }

    private void dnNavigate(KeyEvent evt) {
        int bottomPosition = this.scrollPane.getVerticalScrollBar().getValue();
        this.scrollPane.dispatchEvent(evt);
        if ((this.scrollPane.getViewport().getHeight() > this.pnlPage.getHeight() || this.scrollPane.getVerticalScrollBar().getValue() == bottomPosition) && this.pageIndex < this.jasperPrint.getPages().size() - 1) {
            this.setPageIndex(this.pageIndex + 1);
            if (this.scrollPane.isEnabled()) {
                this.scrollPane.getVerticalScrollBar().setValue(0);
            }
        }
    }

    private void upNavigate(KeyEvent evt) {
        if ((this.scrollPane.getViewport().getHeight() > this.pnlPage.getHeight() || this.scrollPane.getVerticalScrollBar().getValue() == 0) && this.pageIndex > 0) {
            this.setPageIndex(this.pageIndex - 1);
            if (this.scrollPane.isEnabled()) {
                this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
            }
        } else {
            this.scrollPane.dispatchEvent(evt);
        }
    }

    private void homeEndNavigate(int pageNumber) {
        this.setPageIndex(pageNumber);
        if (this.scrollPane.isEnabled()) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    private void fitPage() {
        float widthRatio;
        float heightRatio = ((float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)this.jasperPrint.getPageHeight();
        this.setRealZoomRatio(heightRatio < (widthRatio = ((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth()) ? heightRatio : widthRatio);
    }

    class PageRenderer
    extends JLabel {
        private static final long serialVersionUID = 10200L;
        private boolean renderImage;
        JRViewer viewer = null;

        public PageRenderer(JRViewer viewer) {
            this.viewer = viewer;
        }

        public void paintComponent(Graphics g) {
            if (this.isRenderImage()) {
                super.paintComponent(g);
            } else {
                this.viewer.paintPage((Graphics2D)g.create());
            }
        }

        public boolean isRenderImage() {
            return this.renderImage;
        }

        public void setRenderImage(boolean renderImage) {
            this.renderImage = renderImage;
        }
    }

    protected class ImageMapPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 10200L;
        protected final List imageAreaHyperlinks;

        public ImageMapPanel(Rectangle renderingArea, JRImageMapRenderer imageMap) {
            try {
                this.imageAreaHyperlinks = imageMap.getImageAreaHyperlinks(renderingArea);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public String getToolTipText(MouseEvent event) {
            String tooltip = null;
            JRPrintImageAreaHyperlink imageMapArea = this.getImageMapArea(event);
            if (imageMapArea != null) {
                tooltip = JRViewer.this.getHyperlinkTooltip(imageMapArea.getHyperlink());
            }
            if (tooltip == null) {
                tooltip = super.getToolTipText(event);
            }
            return tooltip;
        }

        public void mouseDragged(MouseEvent e) {
            JRViewer.this.pnlLinksMouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            JRPrintImageAreaHyperlink imageArea = this.getImageMapArea(e);
            if (imageArea != null && imageArea.getHyperlink().getHyperlinkType() != 1) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        }

        protected JRPrintImageAreaHyperlink getImageMapArea(MouseEvent e) {
            return this.getImageMapArea((int)((float)e.getX() / JRViewer.this.realZoom), (int)((float)e.getY() / JRViewer.this.realZoom));
        }

        protected JRPrintImageAreaHyperlink getImageMapArea(int x, int y) {
            JRPrintImageAreaHyperlink image = null;
            if (this.imageAreaHyperlinks != null) {
                ListIterator it = this.imageAreaHyperlinks.listIterator(this.imageAreaHyperlinks.size());
                while (image == null && it.hasPrevious()) {
                    JRPrintImageAreaHyperlink area = (JRPrintImageAreaHyperlink)it.previous();
                    if (!area.getArea().containsPoint(x, y)) continue;
                    image = area;
                }
            }
            return image;
        }

        public void mouseClicked(MouseEvent e) {
            JRPrintImageAreaHyperlink imageMapArea = this.getImageMapArea(e);
            if (imageMapArea != null) {
                JRViewer.this.hyperlinkClicked(imageMapArea.getHyperlink());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getPredefinedCursor(13));
            JRViewer.this.pnlLinksMousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
            JRViewer.this.pnlLinksMouseReleased(e);
        }
    }
}

