/*
 * Decompiled with CFR 0.152.
 */
package org.fribok.bookkeeping;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import se.swedsoft.bookkeeping.app.Path;
import se.swedsoft.bookkeeping.app.Version;
import se.swedsoft.bookkeeping.data.system.SSCompanyLock;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSDBConfig;
import se.swedsoft.bookkeeping.data.system.SSYearLock;
import se.swedsoft.bookkeeping.data.util.SSConfig;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.company.SSCompanyFrame;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;

public class Bookkeeping {
    public static boolean iRunning;

    private Bookkeeping() {
    }

    private static void startupDatabase() {
        block7: {
            try {
                Class.forName("org.hsqldb.jdbcDriver");
            }
            catch (ClassNotFoundException e) {
                System.out.println("ERROR: failed to load HSQLDB JDBC driver.");
                e.printStackTrace();
                return;
            }
            try {
                String iServerAddress = SSDBConfig.getServerAddress();
                if (iServerAddress.length() == 0) {
                    Connection iConnection = DriverManager.getConnection("jdbc:hsqldb:file:db" + File.separator + "JFSDB", "sa", "");
                    SSDB.getInstance().startupLocal(iConnection);
                } else {
                    Connection iConnection = DriverManager.getConnection("jdbc:hsqldb:hsql://" + iServerAddress + "/JFSDB", "sa", "");
                    SSDB.getInstance().startupRemote(iConnection, iServerAddress);
                }
            }
            catch (SQLException e) {
                SSQueryDialog iDialog = new SSQueryDialog(SSMainFrame.getInstance(), "noserverfoundstartup");
                if (iDialog.getResponce() != 0) break block7;
                if (SSDB.getInstance().getLocking()) {
                    SSCompanyLock.removeLock(SSDB.getInstance().getCurrentCompany());
                    SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
                }
                SSDBConfig.setServerAddress(null);
                SSDB.getInstance().setCurrentCompany(null);
                SSDB.getInstance().setCurrentYear(null);
                SSFrameManager.getInstance().close();
                SSDB.getInstance().loadLocalDatabase();
                SSCompanyFrame.showFrame(SSMainFrame.getInstance(), 500, 300);
            }
        }
    }

    public static void main(String[] args) {
        try {
            String os = System.getProperty("os.name");
            FontSet fontSet = null;
            fontSet = os.startsWith("Windows") ? FontSets.createDefaultFontSet(new Font("arial unicode MS", 0, 13)) : FontSets.createDefaultFontSet(new Font("arial unicode", 0, 13));
            FontPolicy fixedPolicy = FontPolicies.createFixedPolicy(fontSet);
            Plastic3DLookAndFeel.setFontPolicy(fixedPolicy);
            String lnfClassName = Plastic3DLookAndFeel.class.getName();
            if (os.startsWith("Mac OS") || os.startsWith("Windows")) {
                lnfClassName = UIManager.getSystemLookAndFeelClassName();
            } else {
                String xdgCurrentDesktop = System.getenv("XDG_CURRENT_DESKTOP");
                if (!("Unity".equalsIgnoreCase(xdgCurrentDesktop) || "XFCE".equalsIgnoreCase(xdgCurrentDesktop) || "GNOME".equalsIgnoreCase(xdgCurrentDesktop) || "X-Cinnamon".equalsIgnoreCase(xdgCurrentDesktop) || "LXDE".equalsIgnoreCase(xdgCurrentDesktop))) {
                    lnfClassName = Plastic3DLookAndFeel.class.getName();
                }
            }
            UIManager.setLookAndFeel(lnfClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        iRunning = true;
        System.out.println("Starting up...");
        System.out.println("Title     : Fribok");
        System.out.println("Version   : " + Version.APP_VERSION);
        System.out.println("Build     : " + Version.APP_BUILD);
        System.out.println("Directory : " + Path.get(Path.APP_BASE));
        System.out.println("");
        System.out.println("Operating system: " + System.getProperty("os.name"));
        System.out.println("Architecture    : " + System.getProperty("os.arch"));
        System.out.println("Java version    : " + System.getProperty("java.version"));
        System.out.println("");
        System.out.println("Paths:");
        for (Path name : Path.values()) {
            System.out.printf("   %-12s = %s\n", new Object[]{name, Path.get(name)});
        }
        String warning = null;
        for (Path name : Path.values()) {
            File dir;
            block14: {
                dir = Path.get(name);
                if (!dir.exists()) {
                    try {
                        if (dir.mkdirs()) {
                            System.out.println("Created " + dir);
                            break block14;
                        }
                        warning = "unable to create";
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                } else if (!dir.isDirectory()) {
                    warning = "exists but is not a directory";
                }
            }
            if (warning == null) continue;
            System.out.println(" !! WARNING: " + dir + ' ' + warning);
            warning = null;
        }
        SSMainFrame iMainFrame = SSMainFrame.getInstance();
        UIManager.put("InternalFrame.icon", SSIcon.getIcon("ICON_FRAME"));
        UIManager.put("InternalFrame.inactiveIcon", SSIcon.getIcon("ICON_FRAME"));
        Bookkeeping.startupDatabase();
        iMainFrame.setVisible(true);
        SSDB.getInstance().readOldDatabase();
        if (((Boolean)SSConfig.getInstance().get("companyframe.showatstart", true)).booleanValue()) {
            iMainFrame.showCompanyFrame();
        }
        SSDB.getInstance().init(true);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                SSFrameManager.getInstance().storeAllFrames();
                if (SSDBConfig.getClientkey() != null && SSDBConfig.getClientkey().length() != 0) {
                    SSDB.getInstance().removeClient();
                }
                try {
                    iRunning = false;
                    SSDB.getInstance().shutdown();
                    if (SSDB.getInstance().getLocking() && SSDB.getInstance().getSocket() != null) {
                        SSDB.getInstance().getWriter().println("disconnect");
                        SSDB.getInstance().getWriter().flush();
                        SSDB.getInstance().getWriter().close();
                        SSDB.getInstance().getReader().close();
                        SSDB.getInstance().getSocket().close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
    }
}

