/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import org.hsqldb.Trigger;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSDBConfig;

public class SSTriggerHandler
extends Thread
implements Trigger {
    Socket iSocket;

    public SSTriggerHandler() {
        if (SSDB.getInstance().getLocking()) {
            try {
                this.iSocket = new Socket(SSDBConfig.getServerAddress(), 2223);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        try {
            PrintWriter iOut = new PrintWriter((Writer)new OutputStreamWriter(this.iSocket.getOutputStream()), true);
            BufferedReader iIn = new BufferedReader(new InputStreamReader(this.iSocket.getInputStream()));
            while (SSDB.getInstance().getLocking()) {
                Integer iId;
                String iTriggerName = iIn.readLine();
                String iTableName = iIn.readLine();
                String iNumber = iIn.readLine();
                String iCompanyId = iIn.readLine();
                iOut.println("done");
                if (SSDB.getInstance().getCurrentCompany() == null || iCompanyId == null || !(iId = Integer.valueOf(Integer.parseInt(iCompanyId))).equals(SSDB.getInstance().getCurrentCompany().getId()) && (!iTableName.equals("TBL_VOUCHER") || SSDB.getInstance().getCurrentYear() == null || !iId.equals(SSDB.getInstance().getCurrentYear().getId()))) continue;
                SSDB.getInstance().triggerAction(iTriggerName, iTableName, iNumber);
            }
            iOut.close();
            iIn.close();
            this.iSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fire(int type, String trigName, String tabName, Object[] oldRow, Object[] newRow) {
        if (type == 11) {
            oldRow = null;
        }
        String iNumber = null;
        Integer iCompanyId = null;
        if (trigName.contains("PROJECT") || trigName.contains("RESULTUNIT") || trigName.contains("VOUCHERTEMPLATE") || trigName.contains("OWNREPORT")) {
            if (oldRow != null) {
                iNumber = oldRow[0].toString();
                iCompanyId = (Integer)oldRow[2];
            }
            if (newRow != null) {
                iNumber = newRow[0].toString();
                iCompanyId = (Integer)newRow[2];
            }
        } else {
            if (oldRow != null) {
                iNumber = oldRow[1].toString();
                iCompanyId = (Integer)oldRow[3];
            }
            if (newRow != null) {
                iNumber = newRow[1].toString();
                iCompanyId = (Integer)newRow[3];
            }
        }
        if (iCompanyId != null && SSDB.getInstance().getCurrentCompany() != null && (iCompanyId.equals(SSDB.getInstance().getCurrentCompany().getId()) || tabName != null && tabName.equals("TBL_VOUCHER") && SSDB.getInstance().getCurrentYear() != null && iCompanyId.equals(SSDB.getInstance().getCurrentYear().getId()))) {
            SSDB.getInstance().triggerAction(trigName, tabName, iNumber);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.SSTriggerHandler");
        sb.append("{iSocket=").append(this.iSocket);
        sb.append('}');
        return sb.toString();
    }
}

