/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.app;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import org.freedesktop.xdg.BaseDirs;

public enum Path {
    APP_BASE,
    APP_DATA,
    USER_CONF,
    USER_DATA;

    private static final String APP_SUBDIR = "fribok";
    private static final Map<Path, File> path;

    public static File get(Path name) {
        return path.get((Object)name);
    }

    static {
        path = new EnumMap<Path, File>(Path.class);
        File base = new File(new File("").getAbsolutePath());
        path.put(APP_BASE, base);
        path.put(APP_DATA, new File(base, "data"));
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            path.put(USER_DATA, base);
            path.put(USER_CONF, base);
        } else if (os.startsWith("Mac OS")) {
            path.put(USER_DATA, base);
            path.put(USER_CONF, base);
        } else {
            BaseDirs iBaseDirs = new BaseDirs();
            String userData = iBaseDirs.getUserPath(BaseDirs.Resource.DATA);
            String userConf = iBaseDirs.getUserPath(BaseDirs.Resource.CONFIG);
            path.put(USER_DATA, new File(userData, APP_SUBDIR));
            path.put(USER_CONF, new File(userConf, APP_SUBDIR));
        }
    }
}

