/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.calc.util.SSCalculatorException;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;

public class SSBalanceCalculator {
    private SSNewAccountingYear iYearData;
    private Map<SSAccount, BigDecimal> iInBalance;
    private Map<SSAccount, BigDecimal> iInSaldo;
    private Map<SSAccount, BigDecimal> iChange;
    private Map<SSAccount, BigDecimal> iChangePeriod;
    private Map<SSAccount, BigDecimal> iOutSaldo;

    public SSBalanceCalculator(SSNewAccountingYear pYearData) {
        this.iYearData = pYearData;
        this.iInBalance = new HashMap<SSAccount, BigDecimal>();
        this.iInSaldo = new HashMap<SSAccount, BigDecimal>();
        this.iChange = new HashMap<SSAccount, BigDecimal>();
        this.iChangePeriod = new HashMap<SSAccount, BigDecimal>();
        this.iOutSaldo = new HashMap<SSAccount, BigDecimal>();
    }

    public void calculate() throws SSCalculatorException {
        this.calculate(this.iYearData.getFrom(), this.iYearData.getTo());
    }

    public void calculate(Date pFrom, Date pTo) throws SSCalculatorException {
        List<SSVoucher> iVouchers = this.iYearData.getVouchers();
        this.iInBalance = this.iYearData.getInBalance();
        for (Map.Entry<SSAccount, BigDecimal> entry : this.iInBalance.entrySet()) {
            this.iInSaldo.put(entry.getKey(), entry.getValue());
        }
        for (SSVoucher sSVoucher : iVouchers) {
            boolean inSaldo = pFrom.compareTo(sSVoucher.getDate()) > 0;
            boolean inPeriod = SSVoucherMath.inPeriod(sSVoucher, pFrom, pTo);
            for (SSVoucherRow iRow : sSVoucher.getRows()) {
                SSAccount iRowAccount = iRow.getAccount();
                if (!iRow.isValid() || iRow.isCrossed()) continue;
                BigDecimal iRowSum = SSVoucherMath.getDebetMinusCredit(iRow);
                if (inPeriod) {
                    SSBalanceCalculator.addValueToMap(this.iChange, iRowAccount, iRowSum);
                    SSBalanceCalculator.addValueToMap(this.iChangePeriod, iRowAccount, iRowSum);
                }
                if (!inSaldo) continue;
                SSBalanceCalculator.addValueToMap(this.iInSaldo, iRowAccount, iRowSum);
            }
        }
        for (Map.Entry entry : this.iChangePeriod.entrySet()) {
            SSBalanceCalculator.addValueToMap(this.iOutSaldo, (SSAccount)entry.getKey(), (BigDecimal)entry.getValue());
        }
        for (Map.Entry entry : this.iInSaldo.entrySet()) {
            SSBalanceCalculator.addValueToMap(this.iOutSaldo, (SSAccount)entry.getKey(), (BigDecimal)entry.getValue());
        }
    }

    public List<SSAccount> getAccounts() {
        LinkedList<SSAccount> iList = new LinkedList<SSAccount>();
        for (SSAccount iAccount : this.iOutSaldo.keySet()) {
            iList.add(iAccount);
        }
        return iList;
    }

    public Map<SSAccount, BigDecimal> getInBalance() {
        return this.iInBalance;
    }

    public Map<SSAccount, BigDecimal> getInSaldo() {
        return this.iInSaldo;
    }

    public Map<SSAccount, BigDecimal> getChange() {
        return this.iChange;
    }

    public Map<SSAccount, BigDecimal> getPeriodChange() {
        return this.iChangePeriod;
    }

    public Map<SSAccount, BigDecimal> getOutSaldo() {
        return this.iOutSaldo;
    }

    private static void addValueToMap(Map<SSAccount, BigDecimal> iMap, SSAccount iAccount, BigDecimal iValue) {
        BigDecimal s = iMap.get(iAccount);
        if (s == null) {
            iMap.put(iAccount, iValue);
        } else {
            iMap.put(iAccount, s.add(iValue));
        }
    }

    public static Map<SSAccount, BigDecimal> getInBalance(SSNewAccountingYear pYearData) {
        return pYearData.getInBalance();
    }

    public static Map<SSAccount, BigDecimal> getOutBalance(SSNewAccountingYear pYearData) {
        List<SSVoucher> iVouchers = pYearData.getVouchers();
        HashMap<SSAccount, BigDecimal> iOutBalance = new HashMap<SSAccount, BigDecimal>();
        Map<SSAccount, BigDecimal> iInBalance = pYearData.getInBalance();
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iInBalance.entrySet()) {
            if (!SSAccountMath.isBalanceAccount(ssAccountBigDecimalEntry.getKey(), pYearData)) continue;
            iOutBalance.put(ssAccountBigDecimalEntry.getKey(), ssAccountBigDecimalEntry.getValue());
        }
        for (SSVoucher iVoucher : iVouchers) {
            for (SSVoucherRow iRow : iVoucher.getRows()) {
                SSAccount iRowAccount = iRow.getAccount();
                if (!iRow.isValid() || iRow.isCrossed() || !SSAccountMath.isBalanceAccount(iRowAccount, pYearData)) continue;
                BigDecimal iRowSum = SSVoucherMath.getDebetMinusCredit(iRow);
                SSBalanceCalculator.addValueToMap(iOutBalance, iRowAccount, iRowSum);
            }
        }
        return iOutBalance;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.calc.SSBalanceCalculator");
        sb.append("{iChange=").append(this.iChange);
        sb.append(", iChangePeriod=").append(this.iChangePeriod);
        sb.append(", iInBalance=").append(this.iInBalance);
        sb.append(", iInSaldo=").append(this.iInSaldo);
        sb.append(", iOutSaldo=").append(this.iOutSaldo);
        sb.append(", iYearData=").append(this.iYearData);
        sb.append('}');
        return sb.toString();
    }
}

