/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.calc.util.SSCalculatorException;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSMainBookCalculator {
    private SSNewAccountingYear iYearData;
    private SSAccount iAccountFrom;
    private SSAccount iAccountTo;
    private Date iDateFrom;
    private Date iDateTo;
    private SSNewProject iProject;
    private SSNewResultUnit iResultUnit;
    private List<SSMainBookRow> iRows;
    private Map<SSAccount, BigDecimal> iInBalance;
    private Map<SSAccount, BigDecimal> iInSaldo;

    public SSMainBookCalculator(SSAccount pAccountFrom, SSAccount pAccountTo, Date pDateFrom, Date pDateTo, SSNewProject iProject, SSNewResultUnit iResultUnit) {
        this(SSDB.getInstance().getCurrentYear(), pAccountFrom, pAccountTo, pDateFrom, pDateTo, iProject, iResultUnit);
    }

    public SSMainBookCalculator(SSNewAccountingYear pYearData, SSAccount pAccountFrom, SSAccount pAccountTo, Date pDateFrom, Date pDateTo, SSNewProject iProject, SSNewResultUnit iResultUnit) {
        this.iYearData = pYearData;
        this.iAccountFrom = pAccountFrom;
        this.iAccountTo = pAccountTo;
        this.iDateFrom = pDateFrom;
        this.iDateTo = pDateTo;
        this.iProject = iProject;
        this.iResultUnit = iResultUnit;
        this.iRows = new LinkedList<SSMainBookRow>();
        this.iInBalance = new HashMap<SSAccount, BigDecimal>();
        this.iInSaldo = new HashMap<SSAccount, BigDecimal>();
    }

    public void calculate() throws SSCalculatorException {
        List<SSVoucher> iVouchers = this.iYearData.getVouchers();
        this.iInBalance = this.iYearData.getInBalance();
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : this.iInBalance.entrySet()) {
            this.iInSaldo.put(ssAccountBigDecimalEntry.getKey(), ssAccountBigDecimalEntry.getValue());
        }
        for (SSVoucher iVoucher : iVouchers) {
            boolean inSaldo = this.iDateFrom.compareTo(iVoucher.getDate()) > 0;
            boolean inPeriod = SSVoucherMath.inPeriod(iVoucher, this.iDateFrom, this.iDateTo);
            for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
                SSAccount iAccount = iVoucherRow.getAccount();
                SSNewProject iRowProject = iVoucherRow.getProject();
                SSNewResultUnit iRowResultUnit = iVoucherRow.getResultUnit();
                if (!iVoucherRow.isValid() || this.iProject != null && !this.iProject.equals(iRowProject) || this.iResultUnit != null && !this.iResultUnit.equals(iRowResultUnit)) continue;
                BigDecimal iRowSaldo = SSVoucherMath.getDebetMinusCredit(iVoucherRow);
                if (inSaldo && !iVoucherRow.isCrossed()) {
                    this.addValueToMap(this.iInSaldo, iAccount, iRowSaldo);
                }
                if (!SSAccountMath.inPeriod(iAccount, this.iAccountFrom, this.iAccountTo) || !inPeriod) continue;
                SSMainBookRow iMainBookRow = new SSMainBookRow();
                iMainBookRow.iHasdata = true;
                iMainBookRow.iAccount = iAccount;
                iMainBookRow.iNumber = iVoucher.getNumber();
                iMainBookRow.iDescription = iVoucher.getDescription();
                iMainBookRow.iDate = iVoucher.getDate();
                iMainBookRow.iAdded = iVoucherRow.isAdded();
                iMainBookRow.iCrossed = iVoucherRow.isCrossed();
                iMainBookRow.iDebet = iVoucherRow.getDebet();
                iMainBookRow.iCredit = iVoucherRow.getCredit();
                iMainBookRow.iSum = iRowSaldo;
                this.iRows.add(iMainBookRow);
            }
        }
        for (SSAccount iAccount : this.iInSaldo.keySet()) {
            if ((!this.iInSaldo.containsKey(iAccount) || this.iInSaldo.get(iAccount).signum() == 0) && (!this.iInBalance.containsKey(iAccount) || this.iInBalance.get(iAccount).signum() == 0) || !SSAccountMath.inPeriod(iAccount, this.iAccountFrom, this.iAccountTo)) continue;
            SSMainBookRow iMainBookRow = new SSMainBookRow();
            iMainBookRow.iHasdata = false;
            iMainBookRow.iAccount = iAccount;
            iMainBookRow.iAdded = false;
            iMainBookRow.iCrossed = false;
            iMainBookRow.iDebet = new BigDecimal(0);
            iMainBookRow.iCredit = new BigDecimal(0);
            iMainBookRow.iSum = new BigDecimal(0);
            this.iRows.add(iMainBookRow);
        }
    }

    private void addValueToMap(Map<SSAccount, BigDecimal> iMap, SSAccount iAccount, BigDecimal iValue) {
        BigDecimal s = iMap.get(iAccount);
        if (s == null) {
            iMap.put(iAccount, iValue);
        } else {
            iMap.put(iAccount, s.add(iValue));
        }
    }

    public List<SSMainBookRow> getRows() {
        return this.iRows;
    }

    public Map<SSAccount, BigDecimal> getInBalance() {
        return this.iInBalance;
    }

    public Map<SSAccount, BigDecimal> getInSaldo() {
        return this.iInSaldo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.calc.SSMainBookCalculator");
        sb.append("{iAccountFrom=").append(this.iAccountFrom);
        sb.append(", iAccountTo=").append(this.iAccountTo);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iInBalance=").append(this.iInBalance);
        sb.append(", iInSaldo=").append(this.iInSaldo);
        sb.append(", iProject=").append(this.iProject);
        sb.append(", iResultUnit=").append(this.iResultUnit);
        sb.append(", iRows=").append(this.iRows);
        sb.append(", iYearData=").append(this.iYearData);
        sb.append('}');
        return sb.toString();
    }

    public static class SSMainBookRow {
        private boolean iHasdata;
        private SSAccount iAccount;
        private Integer iNumber;
        private String iDescription;
        private Date iDate;
        private boolean iCrossed;
        private boolean iAdded;
        private BigDecimal iDebet;
        private BigDecimal iCredit;
        private BigDecimal iSum;

        public boolean getHasdata() {
            return this.iHasdata;
        }

        public SSAccount getAccount() {
            return this.iAccount;
        }

        public Integer getNumber() {
            return this.iNumber;
        }

        public String getDescription() {
            return this.iDescription;
        }

        public Date getDate() {
            return this.iDate;
        }

        public BigDecimal getDebet() {
            return this.iDebet;
        }

        public BigDecimal getCredit() {
            return this.iCredit;
        }

        public BigDecimal getSum() {
            return this.iSum;
        }

        public boolean isAdded() {
            return this.iAdded;
        }

        public void setAdded(boolean iAdded) {
            this.iAdded = iAdded;
        }

        public boolean isCrossed() {
            return this.iCrossed;
        }

        public void setCrossed(boolean iCrossed) {
            this.iCrossed = iCrossed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.calc.SSMainBookCalculator.SSMainBookRow");
            sb.append("{iAccount=").append(this.iAccount);
            sb.append(", iAdded=").append(this.iAdded);
            sb.append(", iCredit=").append(this.iCredit);
            sb.append(", iCrossed=").append(this.iCrossed);
            sb.append(", iDate=").append(this.iDate);
            sb.append(", iDebet=").append(this.iDebet);
            sb.append(", iDescription='").append(this.iDescription).append('\'');
            sb.append(", iHasdata=").append(this.iHasdata);
            sb.append(", iNumber=").append(this.iNumber);
            sb.append(", iSum=").append(this.iSum);
            sb.append('}');
            return sb.toString();
        }
    }
}

