/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.calc.util.SSCalculatorException;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSOwnReport;
import se.swedsoft.bookkeeping.data.SSOwnReportRow;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportAccountRow;

public class SSOwnReportCalculator {
    private SSOwnReport iOwnReport;
    private Date iFrom;
    private Date iTo;
    private SSNewProject iProject;
    private SSNewResultUnit iResultUnit;
    private Map<SSAccount, BigDecimal> iChangePeriod;
    private Map<SSAccount, BigDecimal> iChangeBudget;

    public SSOwnReportCalculator(Date pFrom, Date pTo, SSOwnReport pOwnReport, SSNewProject pProject, SSNewResultUnit pResultUnit) {
        this.iFrom = pFrom;
        this.iTo = pTo;
        this.iOwnReport = pOwnReport;
        this.iProject = pProject;
        this.iResultUnit = pResultUnit;
        this.iChangePeriod = new HashMap<SSAccount, BigDecimal>();
        this.iChangeBudget = new HashMap<SSAccount, BigDecimal>();
    }

    public void calculate() throws SSCalculatorException {
        List<SSNewAccountingYear> iAllYearData = SSDB.getInstance().getYears();
        LinkedList<SSVoucher> iVouchers = new LinkedList<SSVoucher>();
        for (SSNewAccountingYear iCurrent : iAllYearData) {
            iVouchers.addAll(iCurrent.getVouchers());
        }
        for (SSVoucher iVoucher : iVouchers) {
            boolean inPeriod = SSVoucherMath.inPeriod(iVoucher, this.iFrom, this.iTo);
            for (SSVoucherRow iRow : iVoucher.getRows()) {
                SSAccount iRowAccount = iRow.getAccount();
                SSNewProject iRowProject = iRow.getProject();
                SSNewResultUnit iRowResultUnit = iRow.getResultUnit();
                if (!iRow.isValid() || iRow.isCrossed()) continue;
                BigDecimal iRowSum = SSVoucherMath.getCreditMinusDebet(iRow);
                if (!inPeriod) continue;
                if (this.iProject != null) {
                    if (this.inProject(iRowProject, this.iProject)) {
                        SSOwnReportCalculator.addValueToMap(this.iChangePeriod, iRowAccount, iRowSum);
                        continue;
                    }
                    SSOwnReportCalculator.addValueToMap(this.iChangePeriod, iRowAccount, new BigDecimal(0));
                    continue;
                }
                if (this.iResultUnit != null) {
                    if (this.inResultUnit(iRowResultUnit, this.iResultUnit)) {
                        SSOwnReportCalculator.addValueToMap(this.iChangePeriod, iRowAccount, iRowSum);
                        continue;
                    }
                    SSOwnReportCalculator.addValueToMap(this.iChangePeriod, iRowAccount, new BigDecimal(0));
                    continue;
                }
                SSOwnReportCalculator.addValueToMap(this.iChangePeriod, iRowAccount, iRowSum);
            }
        }
        for (SSOwnReportRow iOwnReportRow : this.iOwnReport.getHeadings()) {
            for (SSOwnReportAccountRow iAccountRow : iOwnReportRow.getAccountRows()) {
                BigDecimal iSum = iAccountRow.getSumForMonths(this.iFrom, this.iTo);
                if (iSum == null) continue;
                SSOwnReportCalculator.addValueToMap(this.iChangeBudget, iAccountRow.getAccount(), iSum);
            }
        }
    }

    private boolean inProject(SSNewProject pRowProject, SSNewProject pProject) {
        return pRowProject != null && !pRowProject.isConcluded(this.iTo) && pRowProject.equals(pProject);
    }

    private boolean inResultUnit(SSNewResultUnit pRowResultUnit, SSNewResultUnit pResultUnit) {
        return pRowResultUnit != null && pRowResultUnit.equals(pResultUnit);
    }

    public Map<SSAccount, BigDecimal> getChangePeriod() {
        return this.iChangePeriod;
    }

    public Map<SSAccount, BigDecimal> getChangeBudget() {
        return this.iChangeBudget;
    }

    public Map<SSAccount, BigDecimal> getDeviation(Map<SSAccount, BigDecimal> a, Map<SSAccount, BigDecimal> b) {
        HashMap<SSAccount, BigDecimal> iResult = new HashMap<SSAccount, BigDecimal>();
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry1 : b.entrySet()) {
            iResult.put(ssAccountBigDecimalEntry1.getKey(), ssAccountBigDecimalEntry1.getValue());
        }
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : a.entrySet()) {
            SSOwnReportCalculator.subtractValueToMap(iResult, ssAccountBigDecimalEntry.getKey(), ssAccountBigDecimalEntry.getValue());
        }
        return iResult;
    }

    private static void addValueToMap(Map<SSAccount, BigDecimal> iMap, SSAccount iAccount, BigDecimal iValue) {
        BigDecimal s = iMap.get(iAccount);
        if (s == null) {
            iMap.put(iAccount, iValue);
        } else {
            iMap.put(iAccount, s.add(iValue));
        }
    }

    private static void subtractValueToMap(Map<SSAccount, BigDecimal> iMap, SSAccount iAccount, BigDecimal iValue) {
        BigDecimal s = iMap.get(iAccount);
        if (s == null) {
            iMap.put(iAccount, iValue.negate());
        } else {
            iMap.put(iAccount, s.subtract(iValue));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.calc.SSOwnReportCalculator");
        sb.append("{iChangeBudget=").append(this.iChangeBudget);
        sb.append(", iChangePeriod=").append(this.iChangePeriod);
        sb.append(", iFrom=").append(this.iFrom);
        sb.append(", iOwnReport=").append(this.iOwnReport);
        sb.append(", iProject=").append(this.iProject);
        sb.append(", iResultUnit=").append(this.iResultUnit);
        sb.append(", iTo=").append(this.iTo);
        sb.append('}');
        return sb.toString();
    }

    public static class SSResultBudgetRow {
        private Integer iGroup;
        private SSAccount iAccount;

        public Integer getGroup() {
            return this.iGroup;
        }

        public SSAccount getAccount() {
            return this.iAccount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.calc.SSOwnReportCalculator.SSResultBudgetRow");
            sb.append("{iAccount=").append(this.iAccount);
            sb.append(", iGroup=").append(this.iGroup);
            sb.append('}');
            return sb.toString();
        }
    }
}

