/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.calc.util.SSCalculatorException;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSBudget;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSResultCalculator {
    private SSNewAccountingYear iYearData;
    private Date iFrom;
    private Date iTo;
    private SSNewProject iProject;
    private SSNewResultUnit iResultUnit;
    private Map<SSAccount, BigDecimal> iChange;
    private Map<SSAccount, BigDecimal> iChangePeriod;
    private Map<SSAccount, BigDecimal> iChangePrevYear;
    private Map<SSAccount, BigDecimal> iChangeBudget;
    private Map<SSAccount, BigDecimal> iProjectChange;
    private Map<SSAccount, BigDecimal> iProjectChangePeriod;
    private Map<SSAccount, BigDecimal> iResultunitChange;
    private Map<SSAccount, BigDecimal> iResultunitChangePeriod;

    public SSResultCalculator(SSNewAccountingYear pYearData, Date pFrom, Date pTo, SSNewProject pProject, SSNewResultUnit pResultUnit) {
        this.iYearData = pYearData;
        this.iFrom = pFrom;
        this.iTo = pTo;
        this.iProject = pProject;
        this.iResultUnit = pResultUnit;
        this.iChange = new HashMap<SSAccount, BigDecimal>();
        this.iChangePeriod = new HashMap<SSAccount, BigDecimal>();
        this.iChangePrevYear = new HashMap<SSAccount, BigDecimal>();
        this.iChangeBudget = new HashMap<SSAccount, BigDecimal>();
        this.iProjectChange = new HashMap<SSAccount, BigDecimal>();
        this.iProjectChangePeriod = new HashMap<SSAccount, BigDecimal>();
        this.iResultunitChange = new HashMap<SSAccount, BigDecimal>();
        this.iResultunitChangePeriod = new HashMap<SSAccount, BigDecimal>();
    }

    public void calculate() throws SSCalculatorException {
        List<SSNewAccountingYear> iAllYearData = SSDB.getInstance().getYears();
        LinkedList<SSVoucher> iVouchers = new LinkedList<SSVoucher>();
        for (SSNewAccountingYear iCurrent : iAllYearData) {
            iVouchers.addAll(iCurrent.getVouchers());
        }
        for (SSVoucher iVoucher : iVouchers) {
            boolean inPeriod = SSVoucherMath.inPeriod(iVoucher, this.iFrom, this.iTo);
            boolean inYear = SSVoucherMath.inPeriod(iVoucher, this.iYearData.getFrom(), this.iYearData.getTo());
            boolean inPrevYear = SSVoucherMath.inPeriodPrevYear(iVoucher, this.iFrom, this.iTo);
            for (SSVoucherRow iRow : iVoucher.getRows()) {
                SSAccount iRowAccount = iRow.getAccount();
                SSNewProject iRowProject = iRow.getProject();
                SSNewResultUnit iRowResultUnit = iRow.getResultUnit();
                if (!iRow.isValid() || iRow.isCrossed()) continue;
                BigDecimal iRowSum = SSVoucherMath.getCreditMinusDebet(iRow);
                if (inYear) {
                    SSResultCalculator.addValueToMap(this.iChange, iRowAccount, iRowSum);
                }
                if (inPeriod) {
                    SSResultCalculator.addValueToMap(this.iChangePeriod, iRowAccount, iRowSum);
                }
                if (inPrevYear) {
                    SSResultCalculator.addValueToMap(this.iChangePrevYear, iRowAccount, iRowSum);
                }
                if (this.inProject(iRowProject, this.iProject)) {
                    SSResultCalculator.addValueToMap(this.iProjectChange, iRowAccount, iRowSum);
                    if (inPeriod) {
                        SSResultCalculator.addValueToMap(this.iProjectChangePeriod, iRowAccount, iRowSum);
                    }
                }
                if (!this.inResultUnit(iRowResultUnit, this.iResultUnit)) continue;
                SSResultCalculator.addValueToMap(this.iResultunitChange, iRowAccount, iRowSum);
                if (!inPeriod) continue;
                SSResultCalculator.addValueToMap(this.iResultunitChangePeriod, iRowAccount, iRowSum);
            }
        }
        SSBudget iBudget = this.iYearData.getBudget();
        for (SSAccount iAccount : iBudget.getAccounts()) {
            BigDecimal iSum = iBudget.getSumForAccount(iAccount, this.iFrom, this.iTo);
            if (iSum == null || iSum.signum() == 0) continue;
            SSResultCalculator.addValueToMap(this.iChangeBudget, iAccount, iSum);
        }
    }

    private boolean inProject(SSNewProject pRowProject, SSNewProject pProject) {
        return pRowProject != null && !pRowProject.isConcluded(this.iTo) && (pProject == null || pRowProject.equals(pProject));
    }

    private boolean inResultUnit(SSNewResultUnit pRowResultUnit, SSNewResultUnit pResultUnit) {
        return pRowResultUnit != null && (pResultUnit == null || pRowResultUnit.equals(pResultUnit));
    }

    public Map<SSAccount, BigDecimal> getChange() {
        return this.iChange;
    }

    public Map<SSAccount, BigDecimal> getChangePeriod() {
        return this.iChangePeriod;
    }

    public Map<SSAccount, BigDecimal> getChangeBudget() {
        return this.iChangeBudget;
    }

    public Map<SSAccount, BigDecimal> getChangeLastYear() {
        return this.iChangePrevYear;
    }

    public Map<SSAccount, BigDecimal> getProjectChange() {
        return this.iProjectChange;
    }

    public Map<SSAccount, BigDecimal> getProjectChangePeriod() {
        return this.iProjectChangePeriod;
    }

    public Map<SSAccount, BigDecimal> getResultunitChange() {
        return this.iResultunitChange;
    }

    public Map<SSAccount, BigDecimal> getResultunitChangePeriod() {
        return this.iResultunitChangePeriod;
    }

    public Map<SSAccount, BigDecimal> getDeviation(Map<SSAccount, BigDecimal> a, Map<SSAccount, BigDecimal> b) {
        HashMap<SSAccount, BigDecimal> iResult = new HashMap<SSAccount, BigDecimal>();
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry1 : b.entrySet()) {
            iResult.put(ssAccountBigDecimalEntry1.getKey(), ssAccountBigDecimalEntry1.getValue());
        }
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : a.entrySet()) {
            SSResultCalculator.subtractValueToMap(iResult, ssAccountBigDecimalEntry.getKey(), ssAccountBigDecimalEntry.getValue());
        }
        return iResult;
    }

    private static void addValueToMap(Map<SSAccount, BigDecimal> iMap, SSAccount iAccount, BigDecimal iValue) {
        BigDecimal s = iMap.get(iAccount);
        if (s == null) {
            iMap.put(iAccount, iValue);
        } else {
            iMap.put(iAccount, s.add(iValue));
        }
    }

    private static void subtractValueToMap(Map<SSAccount, BigDecimal> iMap, SSAccount iAccount, BigDecimal iValue) {
        BigDecimal s = iMap.get(iAccount);
        if (s == null) {
            iMap.put(iAccount, iValue.negate());
        } else {
            iMap.put(iAccount, s.subtract(iValue));
        }
    }

    public static Map<SSAccount, BigDecimal> getResult(SSNewAccountingYear pYearData) {
        List<SSVoucher> iVouchers = pYearData.getVouchers();
        HashMap<SSAccount, BigDecimal> iResult = new HashMap<SSAccount, BigDecimal>();
        for (SSVoucher iVoucher : iVouchers) {
            for (SSVoucherRow iRow : iVoucher.getRows()) {
                SSAccount iRowAccount = iRow.getAccount();
                if (!iRow.isValid() || iRow.isCrossed() || !SSAccountMath.isResultAccount(iRowAccount, pYearData)) continue;
                BigDecimal iRowSum = SSVoucherMath.getDebetMinusCredit(iRow);
                SSResultCalculator.addValueToMap(iResult, iRowAccount, iRowSum);
            }
        }
        return iResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.calc.SSResultCalculator");
        sb.append("{iChange=").append(this.iChange);
        sb.append(", iChangeBudget=").append(this.iChangeBudget);
        sb.append(", iChangePeriod=").append(this.iChangePeriod);
        sb.append(", iChangePrevYear=").append(this.iChangePrevYear);
        sb.append(", iFrom=").append(this.iFrom);
        sb.append(", iProject=").append(this.iProject);
        sb.append(", iProjectChange=").append(this.iProjectChange);
        sb.append(", iProjectChangePeriod=").append(this.iProjectChangePeriod);
        sb.append(", iResultUnit=").append(this.iResultUnit);
        sb.append(", iResultunitChange=").append(this.iResultunitChange);
        sb.append(", iResultunitChangePeriod=").append(this.iResultunitChangePeriod);
        sb.append(", iTo=").append(this.iTo);
        sb.append(", iYearData=").append(this.iYearData);
        sb.append('}');
        return sb.toString();
    }

    public static class SSResultBudgetRow {
        private Integer iGroup;
        private SSAccount iAccount;

        public Integer getGroup() {
            return this.iGroup;
        }

        public SSAccount getAccount() {
            return this.iAccount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.calc.SSResultCalculator.SSResultBudgetRow");
            sb.append("{iAccount=").append(this.iAccount);
            sb.append(", iGroup=").append(this.iGroup);
            sb.append('}');
            return sb.toString();
        }
    }
}

