/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.calc.util.SSCalculatorException;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSSalesTaxCalculator {
    private SSNewAccountingYear iAccountingYear;
    private Date iDateFrom;
    private Date iDateTo;
    private List<SSVATReportGroup> iReportGroups;
    private List<SSVATControlGroup> iControlGroups;

    public SSSalesTaxCalculator(SSNewAccountingYear pAccountingYear, Date pDateFrom, Date pDateTo) {
        this.iAccountingYear = pAccountingYear;
        this.iDateFrom = pDateFrom;
        this.iDateTo = pDateTo;
    }

    public void calculate() throws SSCalculatorException {
        BigDecimal iSum;
        this.iReportGroups = this.createReportGroups();
        this.iControlGroups = this.createControlGroups();
        List<SSVoucher> iVouchers = SSVoucherMath.getVouchers(this.iAccountingYear.getVouchers(), this.iDateFrom, this.iDateTo);
        Map<SSAccount, BigDecimal> creditMinusDebetSum = SSVoucherMath.getCreditMinusDebetSum(iVouchers);
        Map<SSAccount, BigDecimal> debetMinusCreditSum = SSVoucherMath.getDebetMinusCreditSum(iVouchers);
        for (SSVATReportGroup sSVATReportGroup : this.iReportGroups) {
            iSum = null;
            switch (sSVATReportGroup.getGroup2()) {
                case 11: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "MP1", "MP2", "MP3").add(SSAccountMath.getSumByVATCodeForAccounts(debetMinusCreditSum, "TFEU"));
                    break;
                }
                case 12: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "MF");
                    break;
                }
                case 13: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "MPFF");
                    break;
                }
                case 14: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "MBVT");
                    break;
                }
                case 15: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "MBBU");
                    break;
                }
                case 21: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "E");
                    break;
                }
                case 22: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "OTTU");
                    break;
                }
                case 23: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "VTEU");
                    break;
                }
                case 24: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "\u00d6VEU");
                    break;
                }
                case 25: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(debetMinusCreditSum, "VFEU");
                    break;
                }
                case 26: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(debetMinusCreditSum, "3VEU");
                    break;
                }
                case 30: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "UVL");
                    break;
                }
                case 31: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(debetMinusCreditSum, "IVL");
                    break;
                }
                case 32: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "U1", "UVL");
                    break;
                }
                case 33: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "U2");
                    break;
                }
                case 34: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "U3");
                    break;
                }
                case 35: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "UEU");
                    break;
                }
                case 36: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "UTFU");
                    break;
                }
                case 37: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(debetMinusCreditSum, "I", "IVL");
                    break;
                }
                case 50: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "IBU", "IBU1", "IBU2", "IBU3");
                    break;
                }
                case 60: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "UI1");
                    break;
                }
                case 61: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "UI2");
                    break;
                }
                case 62: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "UI3");
                }
            }
            sSVATReportGroup.setSum(iSum);
        }
        for (SSVATControlGroup sSVATControlGroup : this.iControlGroups) {
            iSum = null;
            switch (sSVATControlGroup.getGroup1()) {
                case 1: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "MP1", "MPFF");
                    break;
                }
                case 2: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "MP2");
                    break;
                }
                case 3: {
                    iSum = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "MP3");
                }
            }
            BigDecimal iReported = null;
            switch (sSVATControlGroup.getGroup1()) {
                case 1: {
                    iReported = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "U1", "UVL");
                    break;
                }
                case 2: {
                    iReported = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "U2");
                    break;
                }
                case 3: {
                    iReported = SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "U3");
                }
            }
            sSVATControlGroup.setSum(iSum);
            sSVATControlGroup.setReported(iReported);
        }
    }

    public List<SSVATReportGroup> getReportGroups() {
        return this.iReportGroups;
    }

    public List<SSVATControlGroup> getControlGroups() {
        return this.iControlGroups;
    }

    private List<SSVATReportGroup> createReportGroups() {
        LinkedList<SSVATReportGroup> iReportGroups = new LinkedList<SSVATReportGroup>();
        iReportGroups.add(new SSVATReportGroup(1, 11));
        iReportGroups.add(new SSVATReportGroup(1, 12));
        iReportGroups.add(new SSVATReportGroup(1, 13));
        iReportGroups.add(new SSVATReportGroup(1, 14));
        iReportGroups.add(new SSVATReportGroup(1, 15));
        iReportGroups.add(new SSVATReportGroup(2, 21));
        iReportGroups.add(new SSVATReportGroup(2, 22));
        iReportGroups.add(new SSVATReportGroup(2, 23));
        iReportGroups.add(new SSVATReportGroup(2, 24));
        iReportGroups.add(new SSVATReportGroup(2, 25));
        iReportGroups.add(new SSVATReportGroup(2, 26));
        iReportGroups.add(new SSVATReportGroup(3, 30));
        iReportGroups.add(new SSVATReportGroup(3, 31));
        iReportGroups.add(new SSVATReportGroup(4, 32));
        iReportGroups.add(new SSVATReportGroup(4, 33));
        iReportGroups.add(new SSVATReportGroup(4, 34));
        iReportGroups.add(new SSVATReportGroup(4, 35));
        iReportGroups.add(new SSVATReportGroup(4, 36));
        iReportGroups.add(new SSVATReportGroup(4, 37));
        return iReportGroups;
    }

    private List<SSVATControlGroup> createControlGroups() {
        LinkedList<SSVATControlGroup> iControlGroups = new LinkedList<SSVATControlGroup>();
        iControlGroups.add(new SSVATControlGroup(1));
        iControlGroups.add(new SSVATControlGroup(2));
        iControlGroups.add(new SSVATControlGroup(3));
        return iControlGroups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.calc.SSSalesTaxCalculator");
        sb.append("{iAccountingYear=").append(this.iAccountingYear);
        sb.append(", iControlGroups=").append(this.iControlGroups);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iReportGroups=").append(this.iReportGroups);
        sb.append('}');
        return sb.toString();
    }

    public static class SSVATControlGroup {
        private BigDecimal iSum;
        private BigDecimal iReported;
        private int iGroup1;

        public SSVATControlGroup(int pGroup1) {
            this.iGroup1 = pGroup1;
            this.iSum = null;
        }

        public int getGroup1() {
            return this.iGroup1;
        }

        public void setGroup1(int iGroup1) {
            this.iGroup1 = iGroup1;
        }

        public BigDecimal getSum() {
            return this.iSum;
        }

        public void setSum(BigDecimal iSum) {
            this.iSum = iSum;
        }

        public BigDecimal getReported() {
            return this.iReported;
        }

        public void setReported(BigDecimal iReported) {
            this.iReported = iReported;
        }

        public String getDescription() {
            return SSBundle.getBundle().getString("vatcontrolreport.group.1." + this.iGroup1);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.calc.SSSalesTaxCalculator.SSVATControlGroup");
            sb.append("{iGroup1=").append(this.iGroup1);
            sb.append(", iReported=").append(this.iReported);
            sb.append(", iSum=").append(this.iSum);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class SSVATReportGroup {
        private int iGroup1;
        private int iGroup2;
        private BigDecimal iSum;

        public SSVATReportGroup(int pGroup1, int pGroup2) {
            this.iGroup1 = pGroup1;
            this.iGroup2 = pGroup2;
            this.iSum = null;
        }

        public int getGroup1() {
            return this.iGroup1;
        }

        public void setGroup1(int iGroup1) {
            this.iGroup1 = iGroup1;
        }

        public int getGroup2() {
            return this.iGroup2;
        }

        public void setGroup2(int iGroup2) {
            this.iGroup2 = iGroup2;
        }

        public BigDecimal getSum() {
            return this.iSum;
        }

        public void setSum(BigDecimal iSum) {
            this.iSum = iSum;
        }

        public String getGroup1Description() {
            return SSBundle.getBundle().getString("vatreport.group.1." + this.iGroup1);
        }

        public String getGroup2Description() {
            return SSBundle.getBundle().getString("vatreport.group.2." + this.iGroup2);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.calc.SSSalesTaxCalculator.SSVATReportGroup");
            sb.append("{iGroup1=").append(this.iGroup1);
            sb.append(", iGroup2=").append(this.iGroup2);
            sb.append(", iSum=").append(this.iSum);
            sb.append('}');
            return sb.toString();
        }
    }
}

