/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.data;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSAccountGroup
implements Serializable {
    private static ResourceBundle cBundle = SSBundle.getBundle();
    private Integer iId = -1;
    private String iBundle;
    private Integer iFromAccount;
    private Integer iToAccount;
    private List<SSAccountGroup> iGroups = null;

    public Integer getId() {
        return this.iId;
    }

    public void setId(Integer iId) {
        this.iId = iId;
    }

    public void setFromAccount(Integer iFromAccount) {
        this.iFromAccount = iFromAccount;
    }

    public Integer getFromAccount() {
        if (this.iFromAccount == null && this.iGroups != null) {
            this.iFromAccount = Integer.MAX_VALUE;
            for (SSAccountGroup iAccountGroup : this.iGroups) {
                if (iAccountGroup.getFromAccount() >= this.iFromAccount) continue;
                this.iFromAccount = iAccountGroup.getFromAccount();
            }
        }
        return this.iFromAccount;
    }

    public Integer getToAccount() {
        if (this.iToAccount == null && this.iGroups != null) {
            this.iToAccount = Integer.MIN_VALUE;
            for (SSAccountGroup iAccountGroup : this.iGroups) {
                if (iAccountGroup.getToAccount() <= this.iToAccount) continue;
                this.iToAccount = iAccountGroup.getToAccount();
            }
        }
        return this.iToAccount;
    }

    public void setToAccount(Integer iToAccount) {
        this.iToAccount = iToAccount;
    }

    public String getBundle() {
        return this.iBundle;
    }

    public void setBundle(String iBundle) {
        this.iBundle = iBundle;
    }

    public List<SSAccountGroup> getGroups() {
        return this.iGroups;
    }

    public void addAccountGroup(SSAccountGroup pAccountGroup) {
        if (this.iGroups == null) {
            this.iGroups = new LinkedList<SSAccountGroup>();
        }
        this.iGroups.add(pAccountGroup);
    }

    public String getTitle() {
        return cBundle.getString(this.iBundle);
    }

    public String getSumTitle() {
        return cBundle.getString(this.iBundle + ".sum");
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String Seperator) {
        StringBuilder sb = new StringBuilder();
        sb.append(Seperator);
        sb.append(this.iId);
        sb.append(": ");
        sb.append(this.getTitle());
        sb.append(", ");
        sb.append(this.iFromAccount);
        sb.append(" - ");
        sb.append(this.iToAccount);
        if (this.iGroups != null) {
            sb.append("{\n");
            for (SSAccountGroup iGroup : this.iGroups) {
                sb.append(iGroup.toString(Seperator + "  "));
            }
            sb.append("  }\n");
        }
        sb.append('\n');
        return sb.toString();
    }

    public List<SSAccount> getGroupAccounts(List<SSAccount> iAccounts) {
        LinkedList<SSAccount> iGroupAccounts = new LinkedList<SSAccount>();
        for (SSAccount iAccount : iAccounts) {
            if (iAccount.getNumber() < this.getFromAccount() || iAccount.getNumber() > this.getToAccount()) continue;
            iGroupAccounts.add(iAccount);
        }
        return iGroupAccounts;
    }
}

