/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import se.swedsoft.bookkeeping.calc.data.SSAccountGroup;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;

public class SSAccountSchema
implements Serializable {
    private static String cParserClass = "org.apache.xerces.parsers.SAXParser";
    private List<SSAccountGroup> iResultGroups = new LinkedList<SSAccountGroup>();
    private List<SSAccountGroup> iBalanceGroups = new LinkedList<SSAccountGroup>();
    private static Map<String, SSAccountSchema> iSchemaCache = new HashMap<String, SSAccountSchema>();

    private SSAccountSchema() {
    }

    public List<SSAccountGroup> getResultGroups() {
        return this.iResultGroups;
    }

    public List<SSAccountGroup> getBalanceGroups() {
        return this.iBalanceGroups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResultGroups: {\n");
        for (SSAccountGroup iLevelOne : this.iResultGroups) {
            sb.append(iLevelOne);
        }
        sb.append("}\n");
        sb.append("BalanceGroups: {\n");
        for (SSAccountGroup iLevelOne : this.iBalanceGroups) {
            sb.append(iLevelOne);
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static SSAccountSchema getAccountSchema(String iSchema) {
        SSAccountSchema iAccountSchema;
        if (iSchemaCache.containsKey(iSchema)) {
            iAccountSchema = iSchemaCache.get(iSchema);
        } else {
            InputStream is = SSAccountSchema.class.getResourceAsStream("/account/" + iSchema);
            iAccountSchema = SSAccountSchema.createAccountSchema(is);
            iSchemaCache.put(iSchema, iAccountSchema);
        }
        return iAccountSchema;
    }

    public static SSAccountSchema getAccountSchema(SSNewAccountingYear pYearData) {
        String iSchema = pYearData.getAccountPlan().getType().getSchema();
        return SSAccountSchema.getAccountSchema(iSchema);
    }

    private static SSAccountSchema createAccountSchema(InputStream is) {
        XMLReader iReader;
        SSAccountSchema iSchema = new SSAccountSchema();
        try {
            iReader = XMLReaderFactory.createXMLReader(cParserClass);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return iSchema;
        }
        iReader.setContentHandler(new AccountGroupLoader(iSchema));
        try {
            iReader.parse(new InputSource(is));
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return iSchema;
    }

    private static class AccountGroupLoader
    extends DefaultHandler {
        private SSAccountSchema iSchema;
        private List<SSAccountGroup> iLevelOne;
        private Stack<SSAccountGroup> iLevelTwo;

        public AccountGroupLoader(SSAccountSchema pSchema) {
            this.iSchema = pSchema;
            this.iLevelOne = null;
            this.iLevelTwo = new Stack();
        }

        private SSAccountGroup createGroup(Attributes iAttributes) {
            String iId = iAttributes.getValue("id");
            String iBundle = iAttributes.getValue("bundle");
            String iFromAccount = iAttributes.getValue("fromAccount");
            String iToAccount = iAttributes.getValue("toAccount");
            SSAccountGroup iAccountGroup = new SSAccountGroup();
            iAccountGroup.setBundle(iBundle);
            iAccountGroup.setId(Integer.decode(iId));
            if (iFromAccount != null) {
                iAccountGroup.setFromAccount(Integer.decode(iFromAccount));
            }
            if (iToAccount != null) {
                iAccountGroup.setToAccount(Integer.decode(iToAccount));
            }
            this.add(iAccountGroup);
            return iAccountGroup;
        }

        private void add(SSAccountGroup pGroup) {
            if (this.iLevelTwo.isEmpty()) {
                this.iLevelOne.add(pGroup);
            } else {
                this.iLevelTwo.peek().addAccountGroup(pGroup);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes iAttributes) throws SAXException {
            if (localName.equalsIgnoreCase("result")) {
                this.iLevelOne = this.iSchema.iResultGroups;
            }
            if (localName.equalsIgnoreCase("balance")) {
                this.iLevelOne = this.iSchema.iBalanceGroups;
            }
            if (localName.equalsIgnoreCase("group")) {
                this.iLevelTwo.push(this.createGroup(iAttributes));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equalsIgnoreCase("result")) {
                this.iLevelOne = null;
            }
            if (localName.equalsIgnoreCase("balance")) {
                this.iLevelOne = null;
            }
            if (localName.equalsIgnoreCase("group")) {
                this.iLevelTwo.pop();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.calc.data.SSAccountSchema.AccountGroupLoader");
            sb.append("{iLevelOne=").append(this.iLevelOne);
            sb.append(", iLevelTwo=").append(this.iLevelTwo);
            sb.append(", iSchema=").append(this.iSchema);
            sb.append('}');
            return sb.toString();
        }
    }
}

