/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.data.SSAccountGroup;
import se.swedsoft.bookkeeping.calc.data.SSAccountSchema;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSAccountMath {
    private SSAccountMath() {
    }

    public static boolean inPeriod(SSAccount iAccount, SSAccount iFrom, SSAccount iTo) {
        Integer iNumber = iAccount.getNumber();
        Integer iFromNumber = iFrom.getNumber();
        Integer iToNumber = iTo.getNumber();
        if (iNumber == null || iFromNumber == null || iToNumber == null) {
            return false;
        }
        return iFromNumber <= iNumber && iNumber <= iToNumber;
    }

    public static boolean isResultAccount(SSAccount iAccount, SSNewAccountingYear pYearData) {
        SSAccountSchema iAccountSchema = SSAccountSchema.getAccountSchema(pYearData);
        for (SSAccountGroup iAccountGroup : iAccountSchema.getResultGroups()) {
            if (iAccountGroup.getFromAccount() > iAccount.getNumber() || iAccountGroup.getToAccount() < iAccount.getNumber()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBalanceAccount(SSAccount iAccount, SSNewAccountingYear pYearData) {
        SSAccountSchema iAccountSchema = SSAccountSchema.getAccountSchema(pYearData);
        for (SSAccountGroup iAccountGroup : iAccountSchema.getBalanceGroups()) {
            if (iAccountGroup.getFromAccount() > iAccount.getNumber() || iAccountGroup.getToAccount() < iAccount.getNumber()) continue;
            return true;
        }
        return false;
    }

    public static SSAccount getAccount(Integer pAccountNr) {
        SSAccountPlan iAccountPlan = SSDB.getInstance().getCurrentAccountPlan();
        if (iAccountPlan == null) {
            return null;
        }
        return iAccountPlan.getAccount(pAccountNr);
    }

    public static List<SSAccount> getBalanceAccounts(SSNewAccountingYear pAccountingYear, List<SSAccount> pAccounts) {
        LinkedList<SSAccount> iFiltered = new LinkedList<SSAccount>();
        for (SSAccount iAccount : pAccounts) {
            if (!SSAccountMath.isBalanceAccount(iAccount, pAccountingYear)) continue;
            iFiltered.add(iAccount);
        }
        return iFiltered;
    }

    public static List<SSAccount> getResultAccounts(SSNewAccountingYear pAccountingYear, List<SSAccount> pAccounts) {
        LinkedList<SSAccount> iFiltered = new LinkedList<SSAccount>();
        for (SSAccount iAccount : pAccounts) {
            if (!SSAccountMath.isResultAccount(iAccount, pAccountingYear)) continue;
            iFiltered.add(iAccount);
        }
        return iFiltered;
    }

    public static int getResultGroup(SSAccount iAccount, SSNewAccountingYear pYearData) {
        SSAccountSchema iAccountSchema = SSAccountSchema.getAccountSchema(pYearData);
        for (SSAccountGroup iAccountGroup : iAccountSchema.getBalanceGroups()) {
            if (iAccountGroup.getFromAccount() > iAccount.getNumber() || iAccountGroup.getToAccount() < iAccount.getNumber()) continue;
            return iAccountGroup.getId();
        }
        return -1;
    }

    public static List<SSAccount> getBalanceAccounts(SSNewAccountingYear pAccountingYear) {
        return SSAccountMath.getBalanceAccounts(pAccountingYear, pAccountingYear.getAccounts());
    }

    public static List<SSAccount> getResultAccounts(SSNewAccountingYear pAccountingYear) {
        return SSAccountMath.getResultAccounts(pAccountingYear, pAccountingYear.getAccounts());
    }

    public static List<SSAccount> getAccounts(List<SSAccount> pAccounts, SSAccount pFrom, SSAccount pTo) {
        LinkedList<SSAccount> iFiltered = new LinkedList<SSAccount>();
        for (SSAccount iAccount : pAccounts) {
            if (!SSAccountMath.inPeriod(iAccount, pFrom, pTo)) continue;
            iFiltered.add(iAccount);
        }
        return iFiltered;
    }

    public static SSAccount getFirstAccount(List<SSAccount> pAccounts) {
        SSAccount iFirst = null;
        for (SSAccount iAccount : pAccounts) {
            if (iFirst != null && iAccount.getNumber() >= iFirst.getNumber()) continue;
            iFirst = iAccount;
        }
        return iFirst;
    }

    public static SSAccount getLastAccount(List<SSAccount> pAccounts) {
        SSAccount iLast = null;
        for (SSAccount iAccount : pAccounts) {
            if (iLast != null && iAccount.getNumber() <= iLast.getNumber()) continue;
            iLast = iAccount;
        }
        return iLast;
    }

    public static List<SSAccount> getAccountsByVATCode(List<SSAccount> pAccounts, String ... pVatCodes) {
        LinkedList<SSAccount> filtered = new LinkedList<SSAccount>();
        block0: for (SSAccount iAccount : pAccounts) {
            for (String iVatCode : pVatCodes) {
                if (!iVatCode.equals(iAccount.getVATCode())) continue;
                filtered.add(iAccount);
                continue block0;
            }
        }
        return filtered;
    }

    public static BigDecimal getSumByVATCodeForAccounts(Map<SSAccount, BigDecimal> pSums, String ... pVatCodes) {
        BigDecimal sum = new BigDecimal(0);
        block0: for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : pSums.entrySet()) {
            for (String iVatCode : pVatCodes) {
                if (!iVatCode.equals(ssAccountBigDecimalEntry.getKey().getVATCode())) continue;
                sum = sum.add(ssAccountBigDecimalEntry.getValue());
                continue block0;
            }
        }
        return sum;
    }

    public static int getNumAccountsByVatCode(List<SSAccount> pAccounts, String ... pVatCodes) {
        return SSAccountMath.getAccountsByVATCode(pAccounts, pVatCodes).size();
    }

    public static SSAccount getAccountWithVATCode(List<SSAccount> pAccounts, String pVatCode, SSAccount pDefaultAccount) {
        List<SSAccount> theAccounts = SSAccountMath.getAccountsByVATCode(pAccounts, pVatCode);
        if (theAccounts.size() > 1) {
            return null;
        }
        if (theAccounts.isEmpty()) {
            return pDefaultAccount;
        }
        return theAccounts.get(0);
    }

    public static List<SSAccount> getAccountsBySRUCode(List<SSAccount> pAccounts, String ... pSruCodes) {
        LinkedList<SSAccount> filtered = new LinkedList<SSAccount>();
        block0: for (SSAccount iAccount : pAccounts) {
            if (iAccount.getSRUCode() == null) continue;
            for (String iSruCode : pSruCodes) {
                if (!iSruCode.equals(iAccount.getSRUCode())) continue;
                filtered.add(iAccount);
                continue block0;
            }
        }
        return filtered;
    }

    public static int getNumAccountsBySRUCode(List<SSAccount> pAccounts, String ... pSruCodes) {
        return SSAccountMath.getAccountsBySRUCode(pAccounts, pSruCodes).size();
    }

    public static List<SSAccount> getAccountsWithoutSRUCode(List<SSAccount> pAccounts) {
        LinkedList<SSAccount> filtered = new LinkedList<SSAccount>();
        for (SSAccount iAccount : pAccounts) {
            if (iAccount.getSRUCode() != null && iAccount.getSRUCode().length() != 0) continue;
            filtered.add(iAccount);
            break;
        }
        return filtered;
    }

    public static int getNumAccountsWithoutSRUCode(List<SSAccount> pAccounts) {
        return SSAccountMath.getAccountsWithoutSRUCode(pAccounts).size();
    }

    public static BigDecimal getSumBySRUCodeForAccounts(Map<SSAccount, BigDecimal> pSums, String ... pSruCodes) {
        BigDecimal sum = new BigDecimal(0);
        block0: for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : pSums.entrySet()) {
            for (String iSruCode : pSruCodes) {
                if (!iSruCode.equals(ssAccountBigDecimalEntry.getKey().getSRUCode())) continue;
                sum = sum.add(ssAccountBigDecimalEntry.getValue());
                continue block0;
            }
        }
        return sum;
    }
}

