/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInpaymentRow;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSInpaymentMath {
    private SSInpaymentMath() {
    }

    public static boolean inPeriod(SSInpayment iInpayment, Date pFrom, Date pTo) {
        Date iDate = iInpayment.getDate();
        Date iFrom = SSDateMath.floor(pFrom);
        Date iTo = SSDateMath.ceil(pTo);
        return iFrom.getTime() <= iDate.getTime() && iDate.getTime() <= iTo.getTime();
    }

    public static BigDecimal convertToLocal(SSInpaymentRow iRow, BigDecimal iValue) {
        BigDecimal iCurrencyRate = iRow.getCurrencyRate();
        if (iCurrencyRate != null) {
            iValue = iValue.multiply(iCurrencyRate);
        }
        return iValue;
    }

    public static BigDecimal getSumForInvoice(SSInpayment iInpayment, SSInvoice iInvoice) {
        BigDecimal iSum = new BigDecimal(0);
        for (SSInpaymentRow iRow : iInpayment.getRows()) {
            BigDecimal iRowValue = iRow.getValue();
            if (iRowValue == null || !iRow.isPaying(iInvoice)) continue;
            iSum = iSum.add(iRowValue);
        }
        return iSum;
    }

    public static BigDecimal getSumForInvoice(SSInvoice iInvoice) {
        List<SSInpayment> iInpayments = SSDB.getInstance().getInpayments();
        BigDecimal iSum = new BigDecimal(0);
        for (SSInpayment iInpayment : iInpayments) {
            BigDecimal iRowSum = SSInpaymentMath.getSumForInvoice(iInpayment, iInvoice);
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static HashMap<Integer, BigDecimal> getSumsForInvoices() {
        HashMap<Integer, BigDecimal> iSums = new HashMap<Integer, BigDecimal>();
        List<SSInpayment> iInpayments = SSDB.getInstance().getInpayments();
        for (SSInpayment iInpayment : iInpayments) {
            for (SSInpaymentRow iRow : iInpayment.getRows()) {
                if (iRow.getValue() == null) continue;
                if (iSums.containsKey(iRow.getInvoiceNr())) {
                    iSums.put(iRow.getInvoiceNr(), iSums.get(iRow.getInvoiceNr()).add(iRow.getValue()));
                    continue;
                }
                iSums.put(iRow.getInvoiceNr(), iRow.getValue());
            }
        }
        return iSums;
    }

    public static HashMap<Integer, BigDecimal> getSumsForInvoices(Date iDate) {
        HashMap<Integer, BigDecimal> iSums = new HashMap<Integer, BigDecimal>();
        List<SSInpayment> iInpayments = SSDB.getInstance().getInpayments();
        for (SSInpayment iInpayment : iInpayments) {
            if (!iInpayment.getDate().before(iDate)) continue;
            for (SSInpaymentRow iRow : iInpayment.getRows()) {
                if (iRow.getValue() == null) continue;
                if (iSums.containsKey(iRow.getInvoiceNr())) {
                    iSums.put(iRow.getInvoiceNr(), iSums.get(iRow.getInvoiceNr()).add(iRow.getValue()));
                    continue;
                }
                iSums.put(iRow.getInvoiceNr(), iRow.getValue());
            }
        }
        return iSums;
    }

    public static BigDecimal getSumForInvoice(SSInvoice iInvoice, Date iDate) {
        List<SSInpayment> iInpayments = SSDB.getInstance().getInpayments();
        iDate = SSDateMath.ceil(iDate);
        BigDecimal iSum = new BigDecimal(0);
        for (SSInpayment iInpayment : iInpayments) {
            Date iCurrent = SSDateMath.floor(iInpayment.getDate());
            BigDecimal iRowSum = SSInpaymentMath.getSumForInvoice(iInpayment, iInvoice);
            if (!iCurrent.before(iDate)) continue;
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static Date getLastInpaymentForInvoice(SSInvoice iInvoice) {
        List<SSInpayment> iInpayments = SSDB.getInstance().getInpayments();
        Date iDate = null;
        for (SSInpayment iInpayment : iInpayments) {
            Date iRowDate = iInpayment.getDate();
            if (!iInpayment.isPaying(iInvoice) || iDate != null && !iRowDate.after(iDate)) continue;
            iDate = iRowDate;
        }
        return iDate;
    }

    public static BigDecimal getSum(SSInpayment iInpayment) {
        BigDecimal iSum = new BigDecimal(0);
        for (SSInpaymentRow iRow : iInpayment.getRows()) {
            BigDecimal iValue = iRow.getValue();
            if (iValue == null) continue;
            iValue = SSInpaymentMath.convertToLocal(iRow, iValue);
            iSum = iSum.add(iValue);
        }
        return iSum;
    }

    public static BigDecimal getSaldo(SSInpaymentRow iInpaymentRow) {
        SSInvoice iInvoice = iInpaymentRow.getInvoice(SSDB.getInstance().getInvoices());
        if (iInvoice == null) {
            return null;
        }
        return SSInvoiceMath.getSaldo(iInvoice.getNumber());
    }

    public static BigDecimal getCurrencyRateDifference(SSInpaymentRow iInpaymentRow) {
        BigDecimal iPaymentRate = iInpaymentRow.getCurrencyRate();
        BigDecimal iCurrencyRate = iInpaymentRow.getInvoiceCurrencyRate();
        BigDecimal iValue = iInpaymentRow.getValue();
        if (iPaymentRate == null || iCurrencyRate == null || iValue == null) {
            return null;
        }
        return iValue.multiply(iPaymentRate.subtract(iCurrencyRate));
    }

    public static BigDecimal getCurrencyRateDifference(SSInpayment iInpayment) {
        BigDecimal iSum = new BigDecimal(0);
        for (SSInpaymentRow iRow : iInpayment.getRows()) {
            BigDecimal iRowSum = SSInpaymentMath.getCurrencyRateDifference(iRow);
            if (iRowSum == null) continue;
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static boolean hasCustomer(SSInpayment iInpayment, SSCustomer iCustomer) {
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInpaymentRow iRow : iInpayment.getRows()) {
            SSInvoice iInvoice = iRow.getInvoice(iInvoices);
            if (iInvoice == null || !iInvoice.hasCustomer(iCustomer)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInvoice(SSInpayment iInpayment, SSInvoice iInvoice) {
        for (SSInpaymentRow iRow : iInpayment.getRows()) {
            if (!iRow.isPaying(iInvoice)) continue;
            return true;
        }
        return false;
    }
}

