/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSTenderMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSOrderMath
extends SSTenderMath {
    public static HashMap<Integer, String> iInvoiceForOrders;

    public static List<SSOrder> getOrdersByCustomerNr(List<SSOrder> iOrders, String iCustomerNr) {
        LinkedList<SSOrder> iFiltered = new LinkedList<SSOrder>();
        for (SSOrder iOrder : iOrders) {
            if (!iCustomerNr.equals(iOrder.getCustomerNr())) continue;
            iFiltered.add(iOrder);
        }
        return iFiltered;
    }

    public static List<SSOrder> getOrdersWithoutInvoice(List<SSOrder> iOrders) {
        LinkedList<SSOrder> iFiltered = new LinkedList<SSOrder>();
        for (SSOrder iOrder : iOrders) {
            if (iOrder.hasInvoice()) continue;
            iFiltered.add(iOrder);
        }
        return iFiltered;
    }

    public static void removeReference(SSInvoice iInvoice) {
        SSOrderMath.removeInvoice(SSDB.getInstance().getOrders(), iInvoice);
    }

    public static void removeInvoice(List<SSOrder> iOrders, SSInvoice iInvoice) {
        for (SSOrder iOrder : iOrders) {
            if (!iOrder.hasInvoice(iInvoice)) continue;
            iOrder.setInvoice(null);
            SSDB.getInstance().updateOrder(iOrder);
        }
    }

    public static Map<SSProduct, Integer> getProductCount(SSOrder iOrder) {
        List<SSProduct> iProducts = SSDB.getInstance().getProducts();
        HashMap<SSProduct, Integer> iProductCount = new HashMap<SSProduct, Integer>();
        for (SSSaleRow iRow : iOrder.getRows()) {
            SSProduct iProduct = iRow.getProduct(iProducts);
            if (iProduct == null) continue;
            Integer iCount = iRow.getQuantity();
            Integer iTotal = (Integer)iProductCount.get(iProduct);
            if (iTotal == null) {
                iProductCount.put(iProduct, iCount);
                continue;
            }
            iProductCount.put(iProduct, iCount + iTotal);
        }
        return iProductCount;
    }

    public static Map<SSProduct, Integer> getProductCount(List<SSOrder> iOrders) {
        HashMap<SSProduct, Integer> iProductCount = new HashMap<SSProduct, Integer>();
        for (SSOrder iOrder : iOrders) {
            Map<SSProduct, Integer> iCounts = SSOrderMath.getProductCount(iOrder);
            for (Map.Entry<SSProduct, Integer> iEntry : iCounts.entrySet()) {
                SSProduct iProduct = iEntry.getKey();
                Integer iValue = iEntry.getValue();
                Integer iTotal = iProductCount.containsKey(iProduct) ? (Integer)iProductCount.get(iProduct) : 0;
                iProductCount.put(iProduct, iTotal + iValue);
            }
        }
        return iProductCount;
    }

    public static Map<String, Integer> getStockInfluencing(List<SSOrder> iOrders) {
        HashMap<String, Integer> iOrderCount = new HashMap<String, Integer>();
        LinkedList<String> iParcelProducts = new LinkedList<String>();
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>(SSDB.getInstance().getProducts());
        for (SSProduct iProduct : iProducts) {
            if (!iProduct.isParcel() || iProduct.getNumber() == null) continue;
            iParcelProducts.add(iProduct.getNumber());
        }
        for (SSOrder iOrder : iOrders) {
            for (SSSaleRow iRow : iOrder.getRows()) {
                Integer iReserved;
                if (iRow.getQuantity() == null) continue;
                if (iParcelProducts.contains(iRow.getProductNr())) {
                    SSProduct iProduct = iRow.getProduct();
                    if (iProduct == null) continue;
                    for (SSProductRow iProductRow : iProduct.getParcelRows()) {
                        iReserved = iOrderCount.get(iProductRow.getProductNr()) == null ? iProductRow.getQuantity() * iRow.getQuantity() : (Integer)iOrderCount.get(iProductRow.getProductNr()) + iProductRow.getQuantity() * iRow.getQuantity();
                        iOrderCount.put(iProductRow.getProductNr(), iReserved);
                    }
                    continue;
                }
                iReserved = iOrderCount.get(iRow.getProductNr()) == null ? iRow.getQuantity() : (Integer)iOrderCount.get(iRow.getProductNr()) + iRow.getQuantity();
                iOrderCount.put(iRow.getProductNr(), iReserved);
            }
        }
        return iOrderCount;
    }

    public static void setInvoiceForOrders() {
    }
}

