/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.base.SSSale;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.customer.SSCustomerFrame;
import se.swedsoft.bookkeeping.gui.product.SSProductFrame;

public class SSSaleMath {
    public static boolean inPeriod(SSSale iSale, Date pFrom, Date pTo) {
        Date iDate = iSale.getDate();
        Date iFrom = SSDateMath.floor(pFrom);
        Date iTo = SSDateMath.ceil(pTo);
        return iFrom.getTime() <= iDate.getTime() && iDate.getTime() <= iTo.getTime();
    }

    public static boolean inPeriod(SSSale iSale, Date pTo) {
        Date iDate = iSale.getDate();
        Date iTo = SSDateMath.ceil(pTo);
        return iDate.getTime() <= iTo.getTime();
    }

    public static BigDecimal[] round(BigDecimal iValue) {
        BigDecimal iRounded = iValue.setScale(0, RoundingMode.HALF_UP);
        BigDecimal iRounding = iValue.subtract(iRounded);
        return new BigDecimal[]{iRounded, iRounding};
    }

    public static BigDecimal getNetSum(SSSale iSale) {
        BigDecimal iNetSum = new BigDecimal(0);
        for (SSSaleRow iRow : iSale.getRows()) {
            BigDecimal iRowSum = iRow.getSum();
            if (iRowSum == null) continue;
            iNetSum = iNetSum.add(iRowSum);
        }
        return iNetSum;
    }

    public static Map<SSTaxCode, BigDecimal> getTaxSum(SSSale iSale) {
        BigDecimal iTaxRate1 = iSale.getNormalizedTaxRate1();
        BigDecimal iTaxRate2 = iSale.getNormalizedTaxRate2();
        BigDecimal iTaxRate3 = iSale.getNormalizedTaxRate3();
        HashMap<SSTaxCode, BigDecimal> iTaxSum = new HashMap<SSTaxCode, BigDecimal>();
        iTaxSum.put(SSTaxCode.TAXRATE_0, new BigDecimal(0));
        iTaxSum.put(SSTaxCode.TAXRATE_1, new BigDecimal(0));
        iTaxSum.put(SSTaxCode.TAXRATE_2, new BigDecimal(0));
        iTaxSum.put(SSTaxCode.TAXRATE_3, new BigDecimal(0));
        if (iSale.getTaxFree()) {
            return iTaxSum;
        }
        for (SSSaleRow iRow : iSale.getRows()) {
            BigDecimal iRowSum = iRow.getSum();
            SSTaxCode iRowTax = iRow.getTaxCode();
            if (iRowSum == null) continue;
            BigDecimal iSum = (BigDecimal)iTaxSum.get(iRowTax);
            if (iRowTax == SSTaxCode.TAXRATE_1) {
                iSum = iSum.add(iRowSum.multiply(iTaxRate1));
            }
            if (iRowTax == SSTaxCode.TAXRATE_2) {
                iSum = iSum.add(iRowSum.multiply(iTaxRate2));
            }
            if (iRowTax == SSTaxCode.TAXRATE_3) {
                iSum = iSum.add(iRowSum.multiply(iTaxRate3));
            }
            iTaxSum.put(iRowTax, iSum);
        }
        return iTaxSum;
    }

    public static BigDecimal getTotalTaxSum(SSSale iSale) {
        Map<SSTaxCode, BigDecimal> iTaxSum = SSSaleMath.getTaxSum(iSale);
        BigDecimal iTax1 = iTaxSum.get(SSTaxCode.TAXRATE_1);
        BigDecimal iTax2 = iTaxSum.get(SSTaxCode.TAXRATE_2);
        BigDecimal iTax3 = iTaxSum.get(SSTaxCode.TAXRATE_3);
        return iTax1.add(iTax2).add(iTax3);
    }

    public static BigDecimal getTotalSum(SSSale iSale) {
        Map<SSTaxCode, BigDecimal> iTaxSum = SSSaleMath.getTaxSum(iSale);
        BigDecimal iNetSum = SSSaleMath.getNetSum(iSale);
        BigDecimal iTaxSum1 = iTaxSum.get(SSTaxCode.TAXRATE_1);
        BigDecimal iTaxSum2 = iTaxSum.get(SSTaxCode.TAXRATE_2);
        BigDecimal iTaxSum3 = iTaxSum.get(SSTaxCode.TAXRATE_3);
        BigDecimal iSum = iSale.getTaxFree() ? iNetSum : iNetSum.add(iTaxSum1).add(iTaxSum2).add(iTaxSum3);
        if (!SSDB.getInstance().getCurrentCompany().isRoundingOff()) {
            return iSum.setScale(0, RoundingMode.HALF_UP);
        }
        return iSum;
    }

    public static BigDecimal getRounding(SSSale iSale) {
        Map<SSTaxCode, BigDecimal> iTaxSum = SSSaleMath.getTaxSum(iSale);
        BigDecimal iNetSum = SSSaleMath.getNetSum(iSale);
        BigDecimal iTaxSum1 = iTaxSum.get(SSTaxCode.TAXRATE_1);
        BigDecimal iTaxSum2 = iTaxSum.get(SSTaxCode.TAXRATE_2);
        BigDecimal iTaxSum3 = iTaxSum.get(SSTaxCode.TAXRATE_3);
        BigDecimal iSum = iSale.getTaxFree() ? iNetSum : iNetSum.add(iTaxSum1).add(iTaxSum2).add(iTaxSum3);
        if (!SSDB.getInstance().getCurrentCompany().isRoundingOff()) {
            return iSum.setScale(0, RoundingMode.HALF_UP).subtract(iSum);
        }
        return new BigDecimal(0);
    }

    public static SSCustomer getNewCustomer(SSSale iSale) {
        if (iSale.getCustomer(SSDB.getInstance().getCustomers()) == null) {
            SSCustomer iCustomer = new SSCustomer();
            iCustomer.setNumber(iSale.getCustomerNr());
            iCustomer.setName(iSale.getCustomerName());
            iCustomer.setYourContactPerson(iSale.getYourContactPerson());
            iCustomer.setOurContactPerson(iSale.getOurContactPerson());
            iCustomer.setPaymentTerm(iSale.getPaymentTerm());
            iCustomer.setDeliveryTerm(iSale.getDeliveryTerm());
            iCustomer.setDeliveryWay(iSale.getDeliveryWay());
            iCustomer.setInvoiceCurrency(iSale.getCurrency());
            iCustomer.setTaxFree(iSale.getTaxFree());
            iCustomer.setEuSaleCommodity(iSale.getEuSaleCommodity());
            iCustomer.setEuSaleYhirdPartCommodity(iSale.getEuSaleThirdPartCommodity());
            iCustomer.setInvoiceAddress(new SSAddress(iSale.getInvoiceAddress()));
            iCustomer.setDeliveryAddress(new SSAddress(iSale.getDeliveryAddress()));
            return iCustomer;
        }
        return null;
    }

    public static List<SSProduct> getNewProducts(SSSale iSale) {
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>();
        for (SSSaleRow iTenderRow : iSale.getRows()) {
            String iProductNr;
            SSProduct iProduct = iTenderRow.getProduct(SSDB.getInstance().getProducts());
            String string = iProductNr = iTenderRow.getProductNr() == null ? "" : iTenderRow.getProductNr().trim();
            if (iProduct != null || iProductNr.length() <= 0 || SSProductMath.getProduct(iProducts, iProductNr) != null) continue;
            iProduct = new SSProduct();
            iProduct.setNumber(iProductNr);
            iProduct.setDescription(iTenderRow.getDescription());
            iProduct.setSellingPrice(iTenderRow.getUnitprice());
            iProduct.setUnit(iTenderRow.getUnit());
            iProduct.setTaxCode(iTenderRow.getTaxCode());
            iProducts.add(iProduct);
        }
        return iProducts;
    }

    public static Integer getProductCount(SSSale iSale, SSProduct iProduct) {
        Integer iCount = 0;
        for (SSSaleRow iRow : iSale.getRows()) {
            SSProduct iRowProduct = iRow.getProduct();
            if (iRowProduct == null || iRow.getQuantity() == null) continue;
            if (iRowProduct.equals(iProduct)) {
                iCount = iCount + iRow.getQuantity();
            }
            if (!iRowProduct.isParcel()) continue;
            Integer iQuantity = SSProductMath.getProductCount(iRowProduct, iProduct);
            iCount = iCount + iRow.getQuantity() * iQuantity;
        }
        return iCount;
    }

    public static void addCustomerAndProducts(SSSale iSale) {
        SSCustomer iCustomer = SSSaleMath.getNewCustomer(iSale);
        if (iCustomer != null) {
            SSDB.getInstance().addCustomer(iCustomer);
        }
        List<SSProduct> iProducts = SSSaleMath.getNewProducts(iSale);
        for (SSProduct iProduct : iProducts) {
            SSDB.getInstance().addProduct(iProduct);
        }
        if (SSCustomerFrame.getInstance() != null) {
            SSCustomerFrame.getInstance().getModel().fireTableDataChanged();
        }
        if (SSProductFrame.getInstance() != null) {
            SSProductFrame.getInstance().getModel().fireTableDataChanged();
        }
    }

    public static boolean containsProduct(SSSale iSale, String iProductNr) {
        for (SSSaleRow iRow : iSale.getRows()) {
            String iRowProductNr = iRow.getProductNr();
            if (iRowProductNr == null || !iRowProductNr.equals(iProductNr)) continue;
            return true;
        }
        return false;
    }

    public static List<SSSaleRow> getRowsForProduct(SSSale iSale, SSProduct iProduct) {
        LinkedList<SSSaleRow> iRows = new LinkedList<SSSaleRow>();
        for (SSSaleRow iRow : iSale.getRows()) {
            if (!iRow.hasProduct(iProduct)) continue;
            iRows.add(iRow);
        }
        return iRows;
    }

    public static SSSaleRow getMatchingRow(SSSale iSale, SSSaleRow iRow) {
        String iProductNr = iRow.getProductNr();
        if (iProductNr == null) {
            return null;
        }
        for (SSSaleRow iCurrent : iSale.getRows()) {
            if (!iProductNr.equals(iCurrent.getProductNr())) continue;
            return iCurrent;
        }
        return null;
    }

    public static boolean hasDiscount(SSSale iSale) {
        for (SSSaleRow iRow : iSale.getRows()) {
            if (iRow.getDiscount() == null) continue;
            return true;
        }
        return false;
    }
}

