/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSSupplierCreditInvoiceMath {
    private SSSupplierCreditInvoiceMath() {
    }

    public static boolean inPeriod(SSSupplierCreditInvoice iSupplierInvoice, Date pFrom, Date pTo) {
        Date iDate = iSupplierInvoice.getDate();
        Date iFrom = SSDateMath.floor(pFrom);
        Date iTo = SSDateMath.ceil(pTo);
        return iFrom.getTime() <= iDate.getTime() && iDate.getTime() <= iTo.getTime();
    }

    public static BigDecimal getSumForInvoice(SSSupplierInvoice iInvoice) {
        List<SSSupplierCreditInvoice> iCreditInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        BigDecimal iSum = new BigDecimal(0);
        for (SSSupplierCreditInvoice iCreditInvoice : iCreditInvoices) {
            BigDecimal iRowSum = SSSupplierInvoiceMath.getTotalSum(iCreditInvoice);
            if (iRowSum == null || !iCreditInvoice.isCrediting(iInvoice)) continue;
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static BigDecimal getSumForInvoice(SSSupplierInvoice iInvoice, Date iDate) {
        List<SSSupplierCreditInvoice> iCreditInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        iDate = SSDateMath.ceil(iDate);
        BigDecimal iSum = new BigDecimal(0);
        for (SSSupplierCreditInvoice iCreditInvoice : iCreditInvoices) {
            Date iCurrent = SSDateMath.floor(iCreditInvoice.getDate());
            BigDecimal iRowSum = SSSupplierInvoiceMath.getTotalSum(iCreditInvoice);
            if (iRowSum == null || !iCreditInvoice.isCrediting(iInvoice) || !iCurrent.before(iDate)) continue;
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static HashMap<Integer, BigDecimal> getSumsForSupplierInvoices() {
        HashMap<Integer, BigDecimal> iSums = new HashMap<Integer, BigDecimal>();
        List<SSSupplierCreditInvoice> iSupplierCreditInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        for (SSSupplierCreditInvoice iSupplierCreditInvoice : iSupplierCreditInvoices) {
            BigDecimal iRowSum = SSSupplierInvoiceMath.getTotalSum(iSupplierCreditInvoice);
            if (iRowSum == null || iSupplierCreditInvoice.getCreditingNr() == null) continue;
            if (iSums.containsKey(iSupplierCreditInvoice.getCreditingNr())) {
                iSums.put(iSupplierCreditInvoice.getCreditingNr(), iSums.get(iSupplierCreditInvoice.getCreditingNr()).add(iRowSum));
                continue;
            }
            iSums.put(iSupplierCreditInvoice.getCreditingNr(), iRowSum);
        }
        return iSums;
    }

    public static HashMap<Integer, BigDecimal> getSumsForSupplierInvoices(Date iDate) {
        HashMap<Integer, BigDecimal> iSums = new HashMap<Integer, BigDecimal>();
        List<SSSupplierCreditInvoice> iSupplierCreditInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        for (SSSupplierCreditInvoice iSupplierCreditInvoice : iSupplierCreditInvoices) {
            BigDecimal iRowSum;
            if (!iSupplierCreditInvoice.getDate().before(iDate) || (iRowSum = SSSupplierInvoiceMath.getTotalSum(iSupplierCreditInvoice)) == null || iSupplierCreditInvoice.getCreditingNr() == null) continue;
            if (iSums.containsKey(iSupplierCreditInvoice.getCreditingNr())) {
                iSums.put(iSupplierCreditInvoice.getCreditingNr(), iSums.get(iSupplierCreditInvoice.getCreditingNr()).add(iRowSum));
                continue;
            }
            iSums.put(iSupplierCreditInvoice.getCreditingNr(), iRowSum);
        }
        return iSums;
    }

    public static Map<String, Integer> getStockInfluencing(List<SSSupplierCreditInvoice> iSupplierCreditInvoices) {
        HashMap<String, Integer> iSupplierCreditInvoiceCount = new HashMap<String, Integer>();
        LinkedList<String> iParcelProducts = new LinkedList<String>();
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>(SSDB.getInstance().getProducts());
        for (SSProduct iProduct : iProducts) {
            if (!iProduct.isParcel() || iProduct.getNumber() == null) continue;
            iParcelProducts.add(iProduct.getNumber());
        }
        for (SSSupplierCreditInvoice iSupplierCreditInvoice : iSupplierCreditInvoices) {
            for (SSSupplierInvoiceRow iRow : iSupplierCreditInvoice.getRows()) {
                Integer iReserved;
                if (iRow.getQuantity() == null) continue;
                if (iParcelProducts.contains(iRow.getProductNr())) {
                    SSProduct iProduct = iRow.getProduct();
                    if (iProduct == null) continue;
                    for (SSProductRow iProductRow : iProduct.getParcelRows()) {
                        iReserved = iSupplierCreditInvoiceCount.get(iProductRow.getProductNr()) == null ? iProductRow.getQuantity() * iRow.getQuantity() : (Integer)iSupplierCreditInvoiceCount.get(iProductRow.getProductNr()) + iProductRow.getQuantity() * iRow.getQuantity();
                        iSupplierCreditInvoiceCount.put(iProductRow.getProductNr(), iReserved);
                    }
                    continue;
                }
                iReserved = iSupplierCreditInvoiceCount.get(iRow.getProductNr()) == null ? iRow.getQuantity() : (Integer)iSupplierCreditInvoiceCount.get(iRow.getProductNr()) + iRow.getQuantity();
                iSupplierCreditInvoiceCount.put(iRow.getProductNr(), iReserved);
            }
        }
        return iSupplierCreditInvoiceCount;
    }
}

