/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSOutpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierCreditInvoiceMath;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSPurchaseOrderRow;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSSupplierInvoiceMath {
    public static HashMap<Integer, BigDecimal> iSaldoMap;

    private SSSupplierInvoiceMath() {
    }

    public static boolean inPeriod(SSSupplierInvoice iSupplierInvoice, Date pFrom, Date pTo) {
        Date iDate = iSupplierInvoice.getDate();
        Date iFrom = SSDateMath.floor(pFrom);
        Date iTo = SSDateMath.ceil(pTo);
        return iFrom.getTime() <= iDate.getTime() && iDate.getTime() <= iTo.getTime();
    }

    public static boolean inPeriod(SSSupplierInvoice iSupplierInvoice, Date pTo) {
        Date iDate = iSupplierInvoice.getDate();
        Date iTo = SSDateMath.ceil(pTo);
        return iDate.getTime() <= iTo.getTime();
    }

    public static BigDecimal convertToLocal(SSSupplierInvoice iSupplierInvoice, BigDecimal iValue) {
        BigDecimal iCurrencyRate = iSupplierInvoice.getCurrencyRate();
        if (iCurrencyRate != null) {
            iValue = iValue.multiply(iCurrencyRate);
        }
        return iValue;
    }

    public static BigDecimal convertToLocal(Integer iSupplierInvoiceNr, BigDecimal iValue) {
        SSSupplierInvoice iSupplierInvoice = new SSSupplierInvoice();
        iSupplierInvoice.setNumber(iSupplierInvoiceNr);
        iSupplierInvoice = SSDB.getInstance().getSupplierInvoice(iSupplierInvoice);
        BigDecimal iCurrencyRate = iSupplierInvoice.getCurrencyRate();
        if (iCurrencyRate != null) {
            iValue = iValue.multiply(iCurrencyRate);
        }
        return iValue;
    }

    public static boolean expired(SSSupplierInvoice iInvoice) {
        Date iNow = new Date();
        Date iPaymentDay = iInvoice.getDueDate();
        iNow = SSDateMath.ceil(iNow);
        iPaymentDay = SSDateMath.floor(iPaymentDay);
        return iNow.after(iPaymentDay);
    }

    public static BigDecimal getNetSum(SSSupplierInvoice iSupplierInvoice) {
        BigDecimal iTotalSum = new BigDecimal(0);
        for (SSSupplierInvoiceRow iRow : iSupplierInvoice.getRows()) {
            BigDecimal iRowSum = iRow.getSum();
            if (iRowSum == null) continue;
            iTotalSum = iTotalSum.add(iRowSum);
        }
        return iTotalSum;
    }

    public static BigDecimal getTotalSum(SSSupplierInvoice iSupplierInvoice) {
        BigDecimal iNetSum = SSSupplierInvoiceMath.getNetSum(iSupplierInvoice);
        BigDecimal iTaxSum = iSupplierInvoice.getTaxSum();
        BigDecimal iRoundingSum = iSupplierInvoice.getRoundingSum();
        return iTaxSum == null ? (iRoundingSum == null ? iNetSum : iNetSum.add(iRoundingSum)) : (iRoundingSum == null ? iNetSum.add(iTaxSum) : iNetSum.add(iTaxSum).add(iRoundingSum));
    }

    public static BigDecimal getSaldo(SSSupplierInvoice iSupplierInvoice) {
        BigDecimal iTotalSum = SSSupplierInvoiceMath.getTotalSum(iSupplierInvoice);
        BigDecimal iCredited = SSSupplierCreditInvoiceMath.getSumForInvoice(iSupplierInvoice);
        BigDecimal iPayed = SSOutpaymentMath.getSumForInvoice(iSupplierInvoice);
        return iTotalSum.subtract(iCredited).subtract(iPayed);
    }

    public static BigDecimal getSaldo(Integer iSupplierInvoiceNumber) {
        if (iSaldoMap.containsKey(iSupplierInvoiceNumber)) {
            return iSaldoMap.get(iSupplierInvoiceNumber);
        }
        return new BigDecimal(0);
    }

    public static BigDecimal getSaldo(SSSupplierInvoice iInvoice, Date iDate) {
        BigDecimal iTotalSum = SSSupplierInvoiceMath.getTotalSum(iInvoice);
        BigDecimal iCreditingSum = SSSupplierCreditInvoiceMath.getSumForInvoice(iInvoice, iDate);
        BigDecimal iInpaymentSum = SSOutpaymentMath.getSumForInvoice(iInvoice, iDate);
        iTotalSum = iTotalSum.subtract(iCreditingSum);
        iTotalSum = iTotalSum.subtract(iInpaymentSum);
        return iTotalSum;
    }

    public static void calculateSaldos() {
        if (iSaldoMap == null) {
            iSaldoMap = new HashMap();
        }
        HashMap<Integer, BigDecimal> iOutpaymentSum = SSOutpaymentMath.getSumsForSupplierInvoices();
        HashMap<Integer, BigDecimal> iSupplierCreditInvoiceSum = SSSupplierCreditInvoiceMath.getSumsForSupplierInvoices();
        List<SSSupplierInvoice> iSupplierInvoices = SSDB.getInstance().getSupplierInvoices();
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            BigDecimal iTotalSum = SSSupplierInvoiceMath.getTotalSum(iSupplierInvoice);
            if (iOutpaymentSum.containsKey(iSupplierInvoice.getNumber())) {
                iTotalSum = iTotalSum.subtract(iOutpaymentSum.get(iSupplierInvoice.getNumber()));
            }
            if (iSupplierCreditInvoiceSum.containsKey(iSupplierInvoice.getNumber())) {
                iTotalSum = iTotalSum.subtract(iSupplierCreditInvoiceSum.get(iSupplierInvoice.getNumber()));
            }
            iSaldoMap.put(iSupplierInvoice.getNumber(), iTotalSum);
        }
    }

    public static Map<Integer, BigDecimal> getSaldos(Date iDate) {
        HashMap<Integer, BigDecimal> iSaldos = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> iOutpaymentSum = SSOutpaymentMath.getSumsForSupplierInvoices(iDate);
        HashMap<Integer, BigDecimal> iSupplierCreditInvoiceSum = SSSupplierCreditInvoiceMath.getSumsForSupplierInvoices(iDate);
        List<SSSupplierInvoice> iSupplierInvoices = SSDB.getInstance().getSupplierInvoices();
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            BigDecimal iTotalSum = SSSupplierInvoiceMath.getTotalSum(iSupplierInvoice);
            if (iOutpaymentSum.containsKey(iSupplierInvoice.getNumber())) {
                iTotalSum = iTotalSum.subtract(iOutpaymentSum.get(iSupplierInvoice.getNumber()));
            }
            if (iSupplierCreditInvoiceSum.containsKey(iSupplierInvoice.getNumber())) {
                iTotalSum = iTotalSum.subtract(iSupplierCreditInvoiceSum.get(iSupplierInvoice.getNumber()));
            }
            iSaldos.put(iSupplierInvoice.getNumber(), iTotalSum);
        }
        return iSaldos;
    }

    public static Map<SSSupplierInvoice, BigDecimal> getSaldo(List<SSSupplierInvoice> iInvoices, Date iDate) {
        HashMap<SSSupplierInvoice, BigDecimal> iSaldos = new HashMap<SSSupplierInvoice, BigDecimal>();
        iDate = SSDateMath.ceil(iDate);
        HashMap<Integer, BigDecimal> iOutpaymentSum = SSOutpaymentMath.getSumsForSupplierInvoices(iDate);
        HashMap<Integer, BigDecimal> iSupplierCreditInvoiceSum = SSSupplierCreditInvoiceMath.getSumsForSupplierInvoices(iDate);
        for (SSSupplierInvoice iInvoice : iInvoices) {
            Date iCurrent = iInvoice.getDate();
            if (!iCurrent.before(iDate)) continue;
            BigDecimal iSum = SSSupplierInvoiceMath.getTotalSum(iInvoice);
            if (iOutpaymentSum.containsKey(iInvoice.getNumber())) {
                iSum = iSum.subtract(iOutpaymentSum.get(iInvoice.getNumber()));
            }
            if (iSupplierCreditInvoiceSum.containsKey(iInvoice.getNumber())) {
                iSum = iSum.subtract(iSupplierCreditInvoiceSum.get(iInvoice.getNumber()));
            }
            iSaldos.put(iInvoice, iSum.setScale(2, RoundingMode.HALF_UP));
        }
        return iSaldos;
    }

    public static BigDecimal getSaldoSum(List<SSSupplierInvoice> iInvoices, Date iDate) {
        Map<SSSupplierInvoice, BigDecimal> iSaldos = SSSupplierInvoiceMath.getSaldo(iInvoices, iDate);
        BigDecimal iSum = new BigDecimal(0);
        for (SSSupplierInvoice iInvoice : iInvoices) {
            iSum = iSum.add(iSaldos.get(iInvoice));
        }
        return iSum;
    }

    public static List<SSSupplierInvoice> getInvoicesForSupplier(SSSupplier iSupplier) {
        return SSSupplierInvoiceMath.getInvoicesForSupplier(SSDB.getInstance().getSupplierInvoices(), iSupplier);
    }

    public static List<SSSupplierInvoice> getInvoicesForSupplier(List<SSSupplierInvoice> iInvoices, SSSupplier iSupplier) {
        LinkedList<SSSupplierInvoice> iFiltered = new LinkedList<SSSupplierInvoice>();
        for (SSSupplierInvoice iInvoice : iInvoices) {
            if (!iInvoice.hasSupplier(iSupplier)) continue;
            iFiltered.add(iInvoice);
        }
        return iFiltered;
    }

    public static List<SSSupplierInvoice> getInvoicesForSupplier(SSSupplier iSupplier, Date iDate) {
        return SSSupplierInvoiceMath.getInvoicesForSupplier(SSDB.getInstance().getSupplierInvoices(), iSupplier, iDate);
    }

    public static List<SSSupplierInvoice> getInvoicesForSupplier(List<SSSupplierInvoice> iInvoices, SSSupplier iSupplier, Date iDate) {
        LinkedList<SSSupplierInvoice> iFiltered = new LinkedList<SSSupplierInvoice>();
        for (SSSupplierInvoice iInvoice : iInvoices) {
            if (!iInvoice.hasSupplier(iSupplier) || !SSSupplierInvoiceMath.inPeriod(iInvoice, iDate)) continue;
            iFiltered.add(iInvoice);
        }
        return iFiltered;
    }

    public static Integer getProductCount(SSSupplierInvoice iSupplierInvoice, SSProduct iProduct) {
        Integer iCount = 0;
        for (SSSupplierInvoiceRow iRow : iSupplierInvoice.getRows()) {
            SSProduct iRowProduct = iRow.getProduct();
            if (iRowProduct == null || iRow.getQuantity() == null) continue;
            if (iRowProduct.equals(iProduct)) {
                iCount = iCount + iRow.getQuantity();
            }
            if (!iRowProduct.isParcel()) continue;
            Integer iQuantity = SSProductMath.getProductCount(iRowProduct, iProduct);
            iCount = iCount + iRow.getQuantity() * iQuantity;
        }
        return iCount;
    }

    public static SSSupplierInvoice getSupplierInvoice(List<SSSupplierInvoice> iSupplierInvoices, int iNumber) {
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            if (iSupplierInvoice.getNumber() != iNumber) continue;
            return iSupplierInvoice;
        }
        return null;
    }

    public static SSSupplierInvoice getSupplierInvoiceByNumber(List<SSSupplierInvoice> iSupplierInvoices, Integer iNumber) {
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            if (!iSupplierInvoice.getNumber().equals(iNumber)) continue;
            return iSupplierInvoice;
        }
        return null;
    }

    public static SSSupplierInvoice getSupplierInvoiceByReference(List<SSSupplierInvoice> iSupplierInvoices, String iNumber) {
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            String iReferencenumber = iSupplierInvoice.getReferencenumber();
            if (iReferencenumber.length() <= 0 || !iReferencenumber.equals(iNumber)) continue;
            return iSupplierInvoice;
        }
        return null;
    }

    public static SSSupplierInvoiceRow getMatchingRow(SSSupplierInvoice iSupplierInvoice, SSPurchaseOrderRow iRow) {
        String iProductNr = iRow.getProductNr();
        if (iProductNr == null) {
            return null;
        }
        for (SSSupplierInvoiceRow iCurrent : iSupplierInvoice.getRows()) {
            if (!iProductNr.equals(iCurrent.getProductNr())) continue;
            return iCurrent;
        }
        return null;
    }

    public static List<SSSupplierInvoice> getNonPayedOrCreditedInvoices() {
        return SSSupplierInvoiceMath.getNonPayedOrCreditedInvoices(SSDB.getInstance().getSupplierInvoices());
    }

    public static List<SSSupplierInvoice> getNonPayedOrCreditedInvoices(List<SSSupplierInvoice> iInvoices) {
        LinkedList<SSSupplierInvoice> iFiltered = new LinkedList<SSSupplierInvoice>();
        for (SSSupplierInvoice iInvoice : iInvoices) {
            BigDecimal iSaldo = SSSupplierInvoiceMath.getSaldo(iInvoice.getNumber());
            if (iSaldo.signum() == 0) continue;
            iFiltered.add(iInvoice);
        }
        return iFiltered;
    }

    public static Map<String, Integer> getStockInfluencing(List<SSSupplierInvoice> iSupplierInvoices) {
        HashMap<String, Integer> iSupplierInvoiceCount = new HashMap<String, Integer>();
        LinkedList<String> iParcelProducts = new LinkedList<String>();
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>(SSDB.getInstance().getProducts());
        for (SSProduct iProduct : iProducts) {
            if (!iProduct.isParcel() || iProduct.getNumber() == null) continue;
            iParcelProducts.add(iProduct.getNumber());
        }
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            for (SSSupplierInvoiceRow iRow : iSupplierInvoice.getRows()) {
                Integer iReserved;
                if (iRow.getQuantity() == null) continue;
                if (iParcelProducts.contains(iRow.getProductNr())) {
                    SSProduct iProduct = iRow.getProduct();
                    if (iProduct == null) continue;
                    for (SSProductRow iProductRow : iProduct.getParcelRows()) {
                        iReserved = iSupplierInvoiceCount.get(iProductRow.getProductNr()) == null ? iProductRow.getQuantity() * iRow.getQuantity() : (Integer)iSupplierInvoiceCount.get(iProductRow.getProductNr()) + iProductRow.getQuantity() * iRow.getQuantity();
                        iSupplierInvoiceCount.put(iProductRow.getProductNr(), iReserved);
                    }
                    continue;
                }
                iReserved = iSupplierInvoiceCount.get(iRow.getProductNr()) == null ? iRow.getQuantity() : (Integer)iSupplierInvoiceCount.get(iRow.getProductNr()) + iRow.getQuantity();
                iSupplierInvoiceCount.put(iRow.getProductNr(), iReserved);
            }
        }
        return iSupplierInvoiceCount;
    }
}

