/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSSupplierMath {
    public static HashMap<String, List<SSSupplierInvoice>> iInvoicesForSuppliers;

    private SSSupplierMath() {
    }

    public static BigDecimal getSupplierDebt(SSSupplier iSupplier) {
        List<SSSupplierInvoice> iInvoices = SSSupplierInvoiceMath.getInvoicesForSupplier(iSupplier);
        BigDecimal iSum = new BigDecimal(0);
        for (SSSupplierInvoice iInvoice : iInvoices) {
            BigDecimal iSaldo = SSSupplierInvoiceMath.getSaldo(iInvoice.getNumber());
            iSaldo = SSSupplierInvoiceMath.convertToLocal(iInvoice, iSaldo);
            iSum = iSum.add(iSaldo);
        }
        return iSum;
    }

    public static void getInvoicesForSuppliers() {
        if (iInvoicesForSuppliers == null) {
            iInvoicesForSuppliers = new HashMap();
        }
        List<SSSupplier> iSuppliers = SSDB.getInstance().getSuppliers();
        for (SSSupplier iSupplier : iSuppliers) {
            List<SSSupplierInvoice> iSupplierInvoices = SSSupplierInvoiceMath.getInvoicesForSupplier(iSupplier);
            LinkedList<SSSupplierInvoice> iInvoices = new LinkedList<SSSupplierInvoice>();
            for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
                iInvoices.add(iSupplierInvoice);
            }
            iInvoicesForSuppliers.put(iSupplier.getNumber(), iInvoices);
        }
    }

    public static Integer getOutpaymentNumber() {
        Integer iOutpaymentNumber = 0;
        List<SSSupplier> iSuppliers = SSDB.getInstance().getSuppliers();
        for (SSSupplier iSupplier : iSuppliers) {
            if (iSupplier.getOutpaymentNumber() == null || iSupplier.getOutpaymentNumber() <= iOutpaymentNumber) continue;
            iOutpaymentNumber = iSupplier.getOutpaymentNumber();
        }
        Integer n = iOutpaymentNumber;
        Integer n2 = iOutpaymentNumber = Integer.valueOf(iOutpaymentNumber + 1);
        return iOutpaymentNumber;
    }
}

