/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSVoucherMath {
    private static Calendar cCalendar = Calendar.getInstance();

    private SSVoucherMath() {
    }

    public static boolean inPeriod(SSVoucher iVoucher, Date pFrom, Date pTo) {
        Date iDate = iVoucher.getDate();
        Date iFrom = SSDateMath.floor(pFrom);
        Date iTo = SSDateMath.ceil(pTo);
        return iFrom.getTime() <= iDate.getTime() && iDate.getTime() <= iTo.getTime();
    }

    public static boolean inPeriod(SSVoucher iVoucher, Date pTo) {
        Date iDate = iVoucher.getDate();
        Date iTo = SSDateMath.ceil(pTo);
        return iDate.getTime() <= iTo.getTime();
    }

    public static boolean inPeriod(SSVoucher iVoucher, SSMonth iMonth) {
        return iMonth.getFrom().compareTo(iVoucher.getDate()) <= 0 && iMonth.getTo().compareTo(iVoucher.getDate()) >= 0;
    }

    public static boolean inPeriod(SSVoucher iVoucher, SSVoucher pFrom, SSVoucher pTo) {
        return pFrom.getNumber() <= iVoucher.getNumber() && pTo.getNumber() >= iVoucher.getNumber();
    }

    public static boolean inPeriodPrevYear(SSVoucher iVoucher, Date pFrom, Date pTo) {
        cCalendar.setTime(pFrom);
        cCalendar.add(1, -1);
        Date iPrevYearFrom = cCalendar.getTime();
        cCalendar.setTime(pTo);
        cCalendar.add(1, -1);
        Date iPrevYearTo = cCalendar.getTime();
        return SSVoucherMath.inPeriod(iVoucher, iPrevYearFrom, iPrevYearTo);
    }

    public static BigDecimal getCreditSum(SSVoucher iVoucher) {
        BigDecimal sum = new BigDecimal(0);
        for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
            if (!iVoucherRow.isValid() || iVoucherRow.getCredit() == null || iVoucherRow.isCrossed()) continue;
            sum = sum.add(iVoucherRow.getCredit());
        }
        return sum;
    }

    public static BigDecimal getDebetSum(SSVoucher iVoucher) {
        BigDecimal sum = new BigDecimal(0);
        for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
            if (!iVoucherRow.isValid() || iVoucherRow.getDebet() == null || iVoucherRow.isCrossed()) continue;
            sum = sum.add(iVoucherRow.getDebet());
        }
        return sum;
    }

    public static BigDecimal getCreditMinusDebetSum(SSVoucher pVoucher) {
        return SSVoucherMath.getCreditSum(pVoucher).subtract(SSVoucherMath.getDebetSum(pVoucher));
    }

    public static BigDecimal getDebetMinusCreditSum(SSVoucher pVoucher) {
        return SSVoucherMath.getDebetSum(pVoucher).subtract(SSVoucherMath.getCreditSum(pVoucher));
    }

    public static Map<SSAccount, BigDecimal> getCreditMinusDebetSum(List<SSVoucher> pVouchers) {
        HashMap<SSAccount, BigDecimal> iSums = new HashMap<SSAccount, BigDecimal>();
        for (SSVoucher iVoucher : pVouchers) {
            for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
                SSAccount iAccount = iVoucherRow.getAccount();
                if (!iVoucherRow.isValid() || iVoucherRow.isCrossed()) continue;
                BigDecimal s = (BigDecimal)iSums.get(iAccount);
                if (s == null) {
                    iSums.put(iAccount, SSVoucherMath.getCreditMinusDebet(iVoucherRow));
                    continue;
                }
                iSums.put(iAccount, s.add(SSVoucherMath.getCreditMinusDebet(iVoucherRow)));
            }
        }
        return iSums;
    }

    public static Map<SSAccount, BigDecimal> getDebetMinusCreditSum(List<SSVoucher> pVouchers) {
        HashMap<SSAccount, BigDecimal> iSums = new HashMap<SSAccount, BigDecimal>();
        for (SSVoucher iVoucher : pVouchers) {
            for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
                SSAccount iAccount = iVoucherRow.getAccount();
                if (!iVoucherRow.isValid() || iVoucherRow.isCrossed()) continue;
                BigDecimal s = (BigDecimal)iSums.get(iAccount);
                if (s == null) {
                    iSums.put(iAccount, SSVoucherMath.getDebetMinusCredit(iVoucherRow));
                    continue;
                }
                iSums.put(iAccount, s.add(SSVoucherMath.getDebetMinusCredit(iVoucherRow)));
            }
        }
        return iSums;
    }

    public static Map<SSAccount, BigDecimal> getCreditMinusDebetSumPlusIB(SSNewAccountingYear pAccountingYear, List<SSVoucher> pVouchers) {
        Map<SSAccount, BigDecimal> iSums = SSVoucherMath.getCreditMinusDebetSum(pVouchers);
        Map<SSAccount, BigDecimal> iInBalance = pAccountingYear.getInBalance();
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iInBalance.entrySet()) {
            BigDecimal s = iSums.get(ssAccountBigDecimalEntry.getKey());
            if (s == null) {
                iSums.put(ssAccountBigDecimalEntry.getKey(), ssAccountBigDecimalEntry.getValue());
                continue;
            }
            iSums.put(ssAccountBigDecimalEntry.getKey(), s.add(ssAccountBigDecimalEntry.getValue()));
        }
        return iSums;
    }

    public static Map<SSAccount, BigDecimal> getDebetMinusCreditSumPlusIB(SSNewAccountingYear pAccountingYear, List<SSVoucher> pVouchers) {
        Map<SSAccount, BigDecimal> iSums = SSVoucherMath.getDebetMinusCreditSum(pVouchers);
        Map<SSAccount, BigDecimal> iInBalance = pAccountingYear.getInBalance();
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iInBalance.entrySet()) {
            BigDecimal s = iSums.get(ssAccountBigDecimalEntry.getKey());
            if (s == null) {
                iSums.put(ssAccountBigDecimalEntry.getKey(), ssAccountBigDecimalEntry.getValue());
                continue;
            }
            iSums.put(ssAccountBigDecimalEntry.getKey(), s.add(ssAccountBigDecimalEntry.getValue()));
        }
        return iSums;
    }

    public static BigDecimal getDebetSumForAccount(SSVoucher iVoucher, SSAccount iAccount) {
        BigDecimal sum = new BigDecimal(0);
        for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
            if (!iVoucherRow.isValid() || iVoucherRow.getDebet() == null || iVoucherRow.isCrossed() || !iVoucherRow.getAccount().equals(iAccount)) continue;
            sum = sum.add(iVoucherRow.getDebet());
        }
        return sum;
    }

    public static BigDecimal getCreditSumForAccount(SSVoucher iVoucher, SSAccount iAccount) {
        BigDecimal sum = new BigDecimal(0);
        for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
            if (!iVoucherRow.isValid() || iVoucherRow.getCredit() == null || iVoucherRow.isCrossed() || !iVoucherRow.getAccount().equals(iAccount)) continue;
            sum = sum.add(iVoucherRow.getCredit());
        }
        return sum;
    }

    public static int getMaxNumber() {
        return SSDB.getInstance().getLastVoucherNumber();
    }

    public static boolean hasVoucher(Integer iNumber) {
        SSVoucher iVoucher = new SSVoucher(iNumber);
        return SSDB.getInstance().getVoucher(iVoucher) != null;
    }

    public static boolean hasVoucher(List<SSVoucher> iVouchers, Integer iNumber) {
        for (SSVoucher iVoucher : iVouchers) {
            if (iVoucher.getNumber() != iNumber.intValue()) continue;
            return true;
        }
        return false;
    }

    public static SSVoucher getFirst(List<SSVoucher> iVouchers) {
        if (iVouchers.isEmpty()) {
            return null;
        }
        SSVoucher iCurrent = iVouchers.get(0);
        for (SSVoucher iVoucher : iVouchers) {
            if (iVoucher.getNumber() >= iCurrent.getNumber()) continue;
            iCurrent = iVoucher;
        }
        return iCurrent;
    }

    public static SSVoucher getLast(List<SSVoucher> iVouchers) {
        if (iVouchers.isEmpty()) {
            return null;
        }
        SSVoucher iCurrent = iVouchers.get(0);
        for (SSVoucher iVoucher : iVouchers) {
            if (iVoucher.getNumber() <= iCurrent.getNumber()) continue;
            iCurrent = iVoucher;
        }
        return iCurrent;
    }

    public static List<SSVoucher> getVouchers(List<SSVoucher> pVouchers, Date pFrom, Date pTo) {
        LinkedList<SSVoucher> iFiltered = new LinkedList<SSVoucher>();
        for (SSVoucher iVoucher : pVouchers) {
            if (!SSVoucherMath.inPeriod(iVoucher, pFrom, pTo)) continue;
            iFiltered.add(iVoucher);
        }
        return iFiltered;
    }

    public static BigDecimal getCreditMinusDebet(SSVoucherRow iVoucherRow) {
        BigDecimal debet = iVoucherRow.getDebet();
        BigDecimal credit = iVoucherRow.getCredit();
        if (debet == null) {
            debet = new BigDecimal(0);
        }
        if (credit == null) {
            credit = new BigDecimal(0);
        }
        return credit.subtract(debet);
    }

    public static BigDecimal getDebetMinusCredit(SSVoucherRow iVoucherRow) {
        BigDecimal debet = iVoucherRow.getDebet();
        BigDecimal credit = iVoucherRow.getCredit();
        if (debet == null) {
            debet = new BigDecimal(0);
        }
        if (credit == null) {
            credit = new BigDecimal(0);
        }
        return debet.subtract(credit);
    }

    public static void setDebetMinusCredit(SSVoucherRow iVoucherRow, BigDecimal iValue) {
        if (iValue == null) {
            return;
        }
        if (iValue.signum() > 0) {
            iVoucherRow.setDebet(iValue);
        } else {
            iVoucherRow.setCredit(iValue.negate());
        }
    }

    public static void setCreditMinusDebet(SSVoucherRow iVoucherRow, BigDecimal iValue) {
        if (iValue == null) {
            return;
        }
        if (iValue.signum() > 0) {
            iVoucherRow.setCredit(iValue);
        } else {
            iVoucherRow.setDebet(iValue.negate());
        }
    }

    public static boolean hasAccount(SSVoucher pVoucher, SSAccount pAccount) {
        for (SSVoucherRow iVoucherRow : pVoucher.getRows()) {
            SSAccount iAccount = iVoucherRow.getAccount();
            if (iAccount == null || !iAccount.equals(pAccount)) continue;
            return true;
        }
        return false;
    }

    public static void multiplyRowsBy(SSVoucher iVoucher, BigDecimal iOperand) {
        for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
            BigDecimal iDebet = iVoucherRow.getDebet();
            BigDecimal iCredit = iVoucherRow.getCredit();
            if (iDebet != null) {
                iDebet = iDebet.multiply(iOperand);
            }
            if (iCredit != null) {
                iCredit = iCredit.multiply(iOperand);
            }
            iVoucherRow.setDebet(iDebet);
            iVoucherRow.setCredit(iCredit);
        }
    }

    public static SSVoucherRow findRow(SSVoucher iVoucher, SSAccount iAccount, SSNewProject iProject, SSNewResultUnit iResultunit) {
        for (SSVoucherRow iRow : iVoucher.getRows()) {
            SSAccount iRowAccount = iRow.getAccount();
            SSNewProject iRowProject = iRow.getProject();
            SSNewResultUnit iRowResultUnit = iRow.getResultUnit();
            if (iAccount != iRowAccount && (iAccount == null || !iAccount.equals(iRowAccount)) || iProject != iRowProject && (iProject == null || !iProject.equals(iRowProject)) || iResultunit != iRowResultUnit && (iResultunit == null || !iResultunit.equals(iRowResultUnit))) continue;
            return iRow;
        }
        return null;
    }

    public static SSVoucher compress(SSVoucher iVoucher) {
        SSVoucher iNew = new SSVoucher();
        iNew.setNumber(iVoucher.getNumber());
        iNew.setDescription(iVoucher.getDescription());
        iNew.setDate(iVoucher.getDate());
        iNew.setCorrects(iVoucher.getCorrects());
        iNew.setCorrectedBy(iVoucher.getCorrectedBy());
        for (SSVoucherRow iRow : iVoucher.getRows()) {
            SSVoucherRow iCurrent = SSVoucherMath.findRow(iNew, iRow.getAccount(), iRow.getProject(), iRow.getResultUnit());
            if (iCurrent == null) {
                iNew.addVoucherRow(new SSVoucherRow(iRow));
                continue;
            }
            BigDecimal iCredit = iRow.getCredit();
            BigDecimal iDebet = iRow.getDebet();
            BigDecimal iValue = iCurrent.getValue();
            if (iDebet != null) {
                iCurrent.setValue(iValue.add(iDebet));
            }
            if (iCredit == null) continue;
            iCurrent.setValue(iValue.subtract(iCredit));
        }
        return iNew;
    }

    public static Date getNextVoucherDate() {
        Date iDate;
        LinkedList<SSVoucher> iVouchers = new LinkedList<SSVoucher>(SSDB.getInstance().getVouchers());
        Collections.sort(iVouchers, new Comparator<SSVoucher>(){

            @Override
            public int compare(SSVoucher iVoucher1, SSVoucher iVoucher2) {
                Date iDate1 = iVoucher1.getDate();
                Date iDate2 = iVoucher2.getDate();
                if (iDate1 == null || iDate2 == null) {
                    return 0;
                }
                return iDate2.compareTo(iDate1);
            }
        });
        if (!iVouchers.isEmpty() && (iDate = ((SSVoucher)iVouchers.get(0)).getDate()) != null) {
            return iDate;
        }
        SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();
        if (iAccountingYear != null && iAccountingYear.getFrom() != null) {
            return iAccountingYear.getFrom();
        }
        return new Date();
    }

    public static void copyRows(SSVoucher iFrom, SSVoucher iTo, boolean iReverse) {
        List<SSVoucherRow> iRows = iFrom.getRows();
        LinkedList<SSVoucherRow> iNew = new LinkedList<SSVoucherRow>();
        for (SSVoucherRow iRow : iRows) {
            if (iRow.isCrossed()) continue;
            SSVoucherRow iNewRow = new SSVoucherRow(iRow, iReverse);
            iNewRow.setAdded(false);
            iNewRow.setEditedSignature(null);
            iNewRow.setEditedDate(null);
            iNew.add(iNewRow);
        }
        iTo.setVoucherRows(iNew);
    }
}

