/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlanType;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSAccountPlan
implements Serializable,
Cloneable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private Integer iId;
    private String iName;
    private String iBaseName;
    private String iAssessementYear;
    private SSAccountPlanType iType;
    private List<SSAccount> iAccounts;
    private transient List<SSAccount> iActiveAccounts;
    private transient Map<Integer, SSAccount> iAccountMap;

    public SSAccountPlan() {
        this.iAccounts = new LinkedList<SSAccount>();
        this.iType = SSAccountPlanType.get("BAS95");
    }

    public SSAccountPlan(SSAccountPlan iAccountPlan) {
        this.copyFrom(iAccountPlan);
    }

    public SSAccountPlan(SSAccountPlan iAccountPlan, boolean iBasedOn) {
        this.copyFrom(iAccountPlan);
        if (iBasedOn) {
            this.iBaseName = iAccountPlan.iName;
        }
    }

    public SSAccountPlan(String pName) {
        this();
        this.iName = pName;
    }

    public void copyFrom(SSAccountPlan pAccountPlan) {
        this.iName = pAccountPlan.iName;
        this.iType = pAccountPlan.iType;
        this.iBaseName = pAccountPlan.iBaseName;
        this.iAssessementYear = pAccountPlan.iAssessementYear;
        this.iAccounts = new LinkedList<SSAccount>();
        for (SSAccount iAccount : pAccountPlan.getAccounts()) {
            this.iAccounts.add(new SSAccount(iAccount));
        }
        this.iActiveAccounts = null;
        this.iAccountMap = null;
    }

    public Integer getId() {
        return this.iId;
    }

    public void setId(Integer iId) {
        this.iId = iId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String iName) {
        this.iName = iName;
    }

    public String getBaseName() {
        return this.iBaseName;
    }

    public void setBaseName(String iBaseName) {
        this.iBaseName = iBaseName;
    }

    public void setBasePlan(SSAccountPlan iAccountPlan) {
        this.iBaseName = iAccountPlan == null ? null : iAccountPlan.iName;
    }

    public SSAccountPlanType getType() {
        if (this.iType == null) {
            this.iType = SSAccountPlanType.get("BAS95");
        }
        return this.iType;
    }

    public void setType(SSAccountPlanType iType) {
        this.iType = iType;
    }

    public void setType(String iType) {
        this.iType = SSAccountPlanType.get(iType);
    }

    public String getAssessementYear() {
        return this.iAssessementYear;
    }

    public void setAssessementYear(String iAssessementYear) {
        this.iAssessementYear = iAssessementYear;
    }

    public List<SSAccount> getAccounts() {
        if (this.iAccounts == null) {
            this.iAccounts = new LinkedList<SSAccount>();
        }
        return this.iAccounts;
    }

    public void setAccounts(List<SSAccount> iAccounts) {
        this.iAccounts = iAccounts;
        Collections.sort(iAccounts, new Comparator<SSAccount>(){

            @Override
            public int compare(SSAccount o1, SSAccount o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        this.iActiveAccounts = null;
        this.iAccountMap = null;
    }

    public void addAccount(SSAccount pAccount) {
        this.iAccounts.add(pAccount);
        if (pAccount.isActive() && this.iActiveAccounts != null) {
            this.iActiveAccounts.add(pAccount);
        }
        this.iAccountMap = null;
    }

    public boolean removeAccount(SSAccount pAccount) {
        if (pAccount.isActive() && this.iActiveAccounts != null) {
            this.iActiveAccounts.remove(pAccount);
        }
        return this.iAccounts.remove(pAccount);
    }

    public SSAccount getAccount(Integer pNumber) {
        return this.getAccountMap().get(pNumber);
    }

    public void clear() {
        this.iAccounts = new LinkedList<SSAccount>();
        this.iActiveAccounts = null;
        this.iAccountMap = null;
    }

    public void importSRUCodesFrom(SSAccountPlan pAccountPlan) {
        Map<Integer, SSAccount> iMap = this.getAccountMap();
        this.iAssessementYear = pAccountPlan.iAssessementYear;
        for (SSAccount iFromAccount : pAccountPlan.getAccounts()) {
            SSAccount iAccount = iMap.get(iFromAccount.getNumber());
            if (iAccount == null) continue;
            iAccount.setSRUCode(iFromAccount.getSRUCode());
        }
    }

    public void importVATCodesFrom(SSAccountPlan pAccountPlan) {
        Map<Integer, SSAccount> iMap = this.getAccountMap();
        this.iAssessementYear = pAccountPlan.iAssessementYear;
        for (SSAccount iFromAccount : pAccountPlan.getAccounts()) {
            SSAccount iAccount = iMap.get(iFromAccount.getNumber());
            if (iAccount == null) continue;
            iAccount.setVATCode(iFromAccount.getVATCode());
        }
    }

    public void importReportCodesFrom(SSAccountPlan pAccountPlan) {
        Map<Integer, SSAccount> iMap = this.getAccountMap();
        this.iAssessementYear = pAccountPlan.iAssessementYear;
        for (SSAccount iFromAccount : pAccountPlan.getAccounts()) {
            SSAccount iAccount = iMap.get(iFromAccount.getNumber());
            if (iAccount == null) continue;
            iAccount.setReportCode(iFromAccount.getReportCode());
        }
    }

    public List<SSAccount> getActiveAccounts() {
        if (this.iActiveAccounts == null) {
            this.iActiveAccounts = new ArrayList<SSAccount>(this.iAccounts.size());
            for (SSAccount iCurrent : this.iAccounts) {
                if (!iCurrent.isActive()) continue;
                this.iActiveAccounts.add(iCurrent);
            }
        }
        return this.iActiveAccounts;
    }

    public Map<Integer, SSAccount> getAccountMap() {
        if (this.iAccountMap == null) {
            this.iAccountMap = new HashMap<Integer, SSAccount>();
            for (SSAccount iCurrent : this.iAccounts) {
                this.iAccountMap.put(iCurrent.getNumber(), iCurrent);
            }
        }
        return this.iAccountMap;
    }

    @Override
    public String toRenderString() {
        return this.iName;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.iName);
        b.append(" - ");
        b.append(this.getAccounts().size());
        b.append(", base: ");
        b.append(this.iBaseName);
        return b.toString();
    }
}

