/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSAccountPlanType
implements SSTableSearchable,
Serializable {
    static final long serialVersionUID = 1L;
    private static final Map<String, SSAccountPlanType> iAccountPlanTypes = new HashMap<String, SSAccountPlanType>();
    private String name;
    private String schema;

    public static List<SSAccountPlanType> getAccountPlanTypes() {
        return new LinkedList<SSAccountPlanType>(iAccountPlanTypes.values());
    }

    public static SSAccountPlanType get(String name) {
        return iAccountPlanTypes.get(name);
    }

    private SSAccountPlanType(String name, String schema) {
        this.name = name;
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSchema() {
        if (this.schema == null) {
            this.schema = "BAS95.xml";
        }
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String toRenderString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    static {
        iAccountPlanTypes.put("BAS95", new SSAccountPlanType("BAS95", "BAS95.xml"));
        iAccountPlanTypes.put("BAS96", new SSAccountPlanType("BAS96", "BAS96.xml"));
        iAccountPlanTypes.put("EUBAS97", new SSAccountPlanType("EUBAS97", "EUBAS97.xml"));
    }
}

