/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;

public class SSBudget
implements Serializable {
    static final long serialVersionUID = 1L;
    private static Calendar cCalendar = Calendar.getInstance();
    private transient SSNewAccountingYear iAccountingYear;
    private Date iFrom;
    private Date iTo;
    private Map<SSMonth, Map<SSAccount, BigDecimal>> iBudget;

    public SSBudget() {
        this.iFrom = new Date();
        this.iTo = new Date();
        this.iAccountingYear = null;
        this.iBudget = new HashMap<SSMonth, Map<SSAccount, BigDecimal>>();
    }

    public SSBudget(SSBudget pSource) {
        this.iFrom = pSource.iFrom;
        this.iTo = pSource.iTo;
        this.iAccountingYear = pSource.iAccountingYear;
        this.iBudget = new HashMap<SSMonth, Map<SSAccount, BigDecimal>>();
        Map<SSMonth, Map<SSAccount, BigDecimal>> iSource = pSource.getBudget();
        for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry : iSource.entrySet()) {
            HashMap<SSAccount, BigDecimal> iMonthlyBudget = new HashMap<SSAccount, BigDecimal>();
            iMonthlyBudget.putAll(ssMonthMapEntry.getValue());
            this.iBudget.put(ssMonthMapEntry.getKey(), iMonthlyBudget);
        }
    }

    public void clear() {
        this.iBudget = this.createBudgetForYear();
    }

    public Date getFrom() {
        return this.iFrom;
    }

    public Date getTo() {
        return this.iTo;
    }

    public SSNewAccountingYear getAccountingYear() {
        return this.iAccountingYear;
    }

    public List<SSAccount> getAccounts() {
        if (this.iAccountingYear != null) {
            return SSAccountMath.getResultAccounts(this.iAccountingYear);
        }
        return Collections.emptyList();
    }

    public List<SSMonth> getMonths() {
        if (this.iBudget == null) {
            this.iBudget = this.createBudgetForYear();
        }
        LinkedList<SSMonth> iMonths = new LinkedList<SSMonth>();
        for (SSMonth iMonth : this.iBudget.keySet()) {
            iMonths.add(iMonth);
        }
        Collections.sort(iMonths, new Comparator<SSMonth>(){

            @Override
            public int compare(SSMonth o1, SSMonth o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        return iMonths;
    }

    public SSMonth getMonth(SSMonth pMonth) {
        for (SSMonth iMonth : this.iBudget.keySet()) {
            if (!iMonth.equals(pMonth)) continue;
            return iMonth;
        }
        return null;
    }

    public void setYear(SSNewAccountingYear pAccountingYear) {
        this.iAccountingYear = pAccountingYear;
        if (this.iAccountingYear.getFrom().compareTo(this.iFrom) != 0 || this.iAccountingYear.getTo().compareTo(this.iTo) != 0) {
            this.iFrom = this.iAccountingYear.getFrom();
            this.iTo = this.iAccountingYear.getTo();
            this.iBudget = this.createBudgetForYear();
        }
    }

    public Map<SSMonth, Map<SSAccount, BigDecimal>> getBudget() {
        if (this.iBudget == null) {
            this.iBudget = this.createBudgetForYear();
        }
        return this.iBudget;
    }

    public Map<SSAccount, BigDecimal> getBudget(SSMonth pMonth) {
        if (this.iBudget == null) {
            this.iBudget = this.createBudgetForYear();
        }
        return this.iBudget.get(pMonth);
    }

    public void setSumForAccount(SSAccount pAccount, BigDecimal pValue) {
        List<SSMonth> iMonths = this.getMonths();
        if (pValue == null || pValue.signum() == 0) {
            for (SSMonth iMonth : iMonths) {
                this.iBudget.get(iMonth).remove(pAccount);
            }
            return;
        }
        if (iMonths.isEmpty()) {
            return;
        }
        BigDecimal numMonths = new BigDecimal(iMonths.size());
        pValue = pValue.setScale(2, 4);
        BigDecimal sumPerMonth = pValue.divide(numMonths, 3);
        BigDecimal remainder = pValue.subtract(sumPerMonth.multiply(numMonths));
        for (SSMonth iMonth : iMonths) {
            this.iBudget.get(iMonth).put(pAccount, sumPerMonth);
        }
        this.addValueToMonth(iMonths.get(iMonths.size() - 1), pAccount, remainder);
    }

    public void addValueToMonth(SSMonth pMonth, SSAccount pAccount, BigDecimal pValue) {
        BigDecimal current = this.iBudget.get(pMonth).get(pAccount);
        if (current != null) {
            this.iBudget.get(pMonth).put(pAccount, current.add(pValue));
        } else {
            this.iBudget.get(pMonth).put(pAccount, pValue);
        }
    }

    public BigDecimal getSumForAccount(SSAccount pAccount) {
        BigDecimal iSum = new BigDecimal(0);
        for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry : this.iBudget.entrySet()) {
            BigDecimal iValue = ssMonthMapEntry.getValue().get(pAccount);
            if (iValue == null) continue;
            iSum = iSum.add(iValue);
        }
        return iSum.signum() == 0 ? null : iSum;
    }

    public BigDecimal getSumForAccount(SSAccount pAccount, Date pFrom, Date pTo) {
        BigDecimal iSum = new BigDecimal(0);
        for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry : this.iBudget.entrySet()) {
            BigDecimal iValue = ssMonthMapEntry.getValue().get(pAccount);
            if (iValue == null || !ssMonthMapEntry.getKey().isBetween(pFrom, pTo)) continue;
            iSum = iSum.add(iValue);
        }
        return iSum.signum() == 0 ? null : iSum;
    }

    public Map<SSAccount, BigDecimal> getSumForAccounts() {
        HashMap<SSAccount, BigDecimal> sum = new HashMap<SSAccount, BigDecimal>();
        for (SSAccount account : this.getAccounts()) {
            sum.put(account, this.getSumForAccount(account));
        }
        return sum;
    }

    public Map<SSAccount, BigDecimal> getSumForAccounts(Date pFrom, Date pTo) {
        HashMap<SSAccount, BigDecimal> sum = new HashMap<SSAccount, BigDecimal>();
        for (SSAccount account : this.getAccounts()) {
            sum.put(account, this.getSumForAccount(account, pFrom, pTo));
        }
        return sum;
    }

    public void setSaldoForAccountAndMonth(SSAccount pAccount, SSMonth pMonth, BigDecimal pValue) {
        Map<SSAccount, BigDecimal> iMonthlyBudget = this.iBudget.get(pMonth);
        if (iMonthlyBudget != null) {
            if (pValue == null || pValue.signum() == 0) {
                iMonthlyBudget.put(pAccount, null);
            } else {
                iMonthlyBudget.put(pAccount, pValue);
            }
        }
    }

    public BigDecimal getValueForAccountAndMonth(SSAccount pAccount, SSMonth pMonth) {
        Map<SSAccount, BigDecimal> iMonthlyBudget = this.iBudget.get(pMonth);
        if (iMonthlyBudget != null) {
            return iMonthlyBudget.get(pAccount);
        }
        return null;
    }

    private Map<SSMonth, Map<SSAccount, BigDecimal>> createBudgetForYear() {
        HashMap<SSMonth, Map<SSAccount, BigDecimal>> iNewBudget = new HashMap<SSMonth, Map<SSAccount, BigDecimal>>();
        Map<SSAccount, BigDecimal> iSum = this.getSumForAccounts();
        List<SSMonth> iMonths = SSMonth.splitYearIntoMonths(this.iAccountingYear);
        for (SSMonth sSMonth : iMonths) {
            HashMap iMontlyBudget = new HashMap();
            iNewBudget.put(sSMonth, iMontlyBudget);
        }
        for (Map.Entry entry : iSum.entrySet()) {
            this.setSumForAccount((SSAccount)entry.getKey(), (BigDecimal)entry.getValue());
        }
        return iNewBudget;
    }

    public String toString() {
        DateFormat format = DateFormat.getDateInstance(3);
        StringBuffer b = new StringBuffer();
        b.append("Budget for ");
        b.append(format.format(this.iFrom));
        b.append(" to");
        b.append(format.format(this.iTo));
        for (SSMonth iMonth : this.getMonths()) {
            b.append("Month: ");
            b.append(iMonth);
            b.append("{\n");
            for (SSAccount iAccount : this.iBudget.get(iMonth).keySet()) {
                b.append("  Account: \n");
                b.append("  ");
                b.append(iAccount);
                b.append("    Sum:");
                b.append("    ");
                b.append(this.iBudget.get(iMonth).get(iAccount));
                b.append('\n');
            }
            b.append("}\n");
        }
        return b.toString();
    }

    private void readObject(ObjectInputStream iObjectInputStream) throws IOException, ClassNotFoundException {
        iObjectInputStream.defaultReadObject();
        if (this.iBudget == null) {
            this.iBudget = new HashMap<SSMonth, Map<SSAccount, BigDecimal>>();
        }
        if (this.iBudget.isEmpty() && !this.iFrom.equals(this.iTo)) {
            this.iFrom = new Date();
            this.iTo = new Date();
        }
    }
}

