/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSStandardText;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSInvoiceType;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSCreditInvoice
extends SSInvoice {
    static final long serialVersionUID = 1L;
    private Integer iCreditingNr;
    protected transient SSInvoice iCrediting;

    public SSCreditInvoice() {
        this.iCurrencyRate = new BigDecimal(1);
        this.iVoucher = new SSVoucher();
    }

    public SSCreditInvoice(SSInvoice iCrediting) {
        this.copyFrom(iCrediting);
        this.iCrediting = iCrediting;
        this.iCreditingNr = iCrediting.getNumber();
        this.iDate = new Date();
        this.iEntered = false;
        this.iPrinted = false;
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.setText(iCompany.getStandardText(SSStandardText.Creditinvoice));
        }
        this.generateVoucher();
    }

    public SSCreditInvoice(SSCreditInvoice iInvoice) {
        this.copyFrom(iInvoice);
    }

    public SSCreditInvoice(SSCreditInvoice iInvoice, Integer iNumber) {
        this.copyFrom(iInvoice);
        this.iNumber = iNumber;
    }

    public void copyFrom(SSCreditInvoice iInvoice) {
        super.copyFrom(iInvoice);
        this.iCreditingNr = iInvoice.iCreditingNr;
        this.iCurrencyRate = iInvoice.iCurrencyRate;
        this.iCrediting = iInvoice.iCrediting;
        this.iVoucher = new SSVoucher(iInvoice.iVoucher);
    }

    @Override
    public void doAutoIncrecement() {
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        int iNumber = SSDB.getInstance().getAutoIncrement().getNumber("creditinvoice");
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (iCreditInvoice.getNumber() == null || iCreditInvoice.getNumber() <= iNumber) continue;
            iNumber = iCreditInvoice.getNumber();
        }
        this.iNumber = iNumber + 1;
    }

    public Integer getCreditingNr() {
        return this.iCreditingNr;
    }

    public void setCreditingNr(Integer iCreditingNr) {
        this.iCreditingNr = iCreditingNr;
        this.iCrediting = null;
    }

    @Override
    public BigDecimal getCurrencyRate() {
        return this.iCurrencyRate;
    }

    @Override
    public void setCurrencyRate(BigDecimal iCurrencyRate) {
        this.iCurrencyRate = iCurrencyRate;
    }

    @Override
    public SSVoucher getVoucher() {
        return this.iVoucher;
    }

    @Override
    public void setVoucher(SSVoucher iVoucher) {
        this.iVoucher = iVoucher;
    }

    public SSInvoice getCrediting() {
        return this.getCrediting(SSDB.getInstance().getInvoices());
    }

    public SSInvoice getCrediting(List<SSInvoice> iInvoices) {
        if (this.iCrediting == null && this.iCreditingNr != null) {
            for (SSInvoice iCurrent : iInvoices) {
                if (!this.iCreditingNr.equals(iCurrent.getNumber())) continue;
                this.iCrediting = iCurrent;
            }
        }
        return this.iCrediting;
    }

    public void setCrediting(SSInvoice iCrediting) {
        this.iCrediting = iCrediting;
        this.iCreditingNr = iCrediting != null ? iCrediting.getNumber() : null;
    }

    public boolean isCrediting(SSInvoice iCrediting) {
        boolean answer = false;
        if (iCrediting != null) {
            answer = iCrediting.getNumber().equals(this.iCreditingNr);
        }
        return answer;
    }

    public boolean isCrediting(Integer iCrediting) {
        return iCrediting != null && iCrediting.equals(this.iCreditingNr);
    }

    @Override
    public SSVoucher generateVoucher() {
        String iDescription = SSBundle.getBundle().getString("creditinvoiceframe.voucherdescription");
        SSAccountPlan iAccountPlan = SSDB.getInstance().getCurrentAccountPlan();
        this.iVoucher = new SSVoucher();
        this.iVoucher.setDate(new Date());
        this.iVoucher.setNumber(0);
        this.iVoucher.setDescription(String.format(iDescription, this.iNumber));
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(this);
        Map<SSTaxCode, BigDecimal> iTaxSum = SSInvoiceMath.getTaxSum(this);
        BigDecimal iRoundingSum = SSInvoiceMath.getRounding(this);
        if (this.iType == SSInvoiceType.NORMAL) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.CustomerClaim), null, iTotalSum);
        }
        if (this.iType == SSInvoiceType.CASH) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Cash), null, iTotalSum);
        }
        if (!SSDB.getInstance().getCurrentCompany().isRoundingOff()) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Rounding), iRoundingSum);
        }
        if (!this.iTaxFree) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Tax1), iTaxSum.get(SSTaxCode.TAXRATE_1), null);
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Tax2), iTaxSum.get(SSTaxCode.TAXRATE_2), null);
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Tax3), iTaxSum.get(SSTaxCode.TAXRATE_3), null);
        }
        for (SSSaleRow sSSaleRow : this.iRows) {
            SSVoucherRow iVoucherRow = new SSVoucherRow();
            iVoucherRow.setDebet(sSSaleRow.getSum());
            iVoucherRow.setAccount(sSSaleRow.getAccount(iAccountPlan.getAccounts()));
            iVoucherRow.setProject(sSSaleRow.getProject(SSDB.getInstance().getProjects()));
            iVoucherRow.setResultUnit(sSSaleRow.getResultUnit(SSDB.getInstance().getResultUnits()));
            if (iVoucherRow.getAccountNr() == null) continue;
            this.iVoucher.addVoucherRow(iVoucherRow);
        }
        for (SSVoucherRow sSVoucherRow : this.iVoucher.getRows()) {
            if (sSVoucherRow.isDebet()) {
                if (sSVoucherRow.getDebet().compareTo(new BigDecimal(0)) != -1) continue;
                sSVoucherRow.setCredit(sSVoucherRow.getDebet().negate());
                sSVoucherRow.setDebet(null);
                continue;
            }
            if (sSVoucherRow.getCredit().compareTo(new BigDecimal(0)) != -1) continue;
            sSVoucherRow.setDebet(sSVoucherRow.getCredit().negate());
            sSVoucherRow.setCredit(null);
        }
        if (this.iCurrencyRate != null) {
            SSVoucherMath.multiplyRowsBy(this.iVoucher, this.iCurrencyRate);
        }
        this.iVoucher = SSVoucherMath.compress(this.iVoucher);
        return this.iVoucher;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SSCreditInvoice)) {
            return false;
        }
        return this.iNumber.equals(((SSCreditInvoice)obj).getNumber());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSCreditInvoice");
        sb.append("{iCrediting=").append(this.iCrediting);
        sb.append(", iCreditingNr=").append(this.iCreditingNr);
        sb.append('}');
        return sb.toString();
    }
}

