/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSInpaymentRow;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSInpayment
implements SSTableSearchable,
Serializable {
    static final long serialVersionUID = 1L;
    private Integer iNumber;
    private Date iDate;
    private String iText;
    private List<SSInpaymentRow> iRows;
    private SSVoucher iVoucher;
    private SSVoucher iDifference;
    private boolean iEntered;
    protected Map<SSDefaultAccount, Integer> iDefaultAccounts;

    public SSInpayment() {
        this.iRows = new LinkedList<SSInpaymentRow>();
        this.iVoucher = new SSVoucher();
        this.iDifference = new SSVoucher();
        this.iEntered = false;
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iDefaultAccounts.putAll(SSDB.getInstance().getCurrentCompany().getDefaultAccounts());
    }

    public SSInpayment(SSInpayment iInpayment) {
        this.copyFrom(iInpayment);
    }

    public SSInpayment(SSInpayment iInpayment, Integer iNumber) {
        this.copyFrom(iInpayment);
        this.iNumber = iNumber;
    }

    public void copyFrom(SSInpayment iInpayment) {
        this.iNumber = iInpayment.iNumber;
        this.iDate = iInpayment.iDate;
        this.iText = iInpayment.iText;
        this.iEntered = iInpayment.iEntered;
        this.iVoucher = new SSVoucher(iInpayment.iVoucher);
        this.iDifference = new SSVoucher(iInpayment.iDifference);
        this.iRows = new LinkedList<SSInpaymentRow>();
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        for (SSInpaymentRow iRow : iInpayment.iRows) {
            this.iRows.add(new SSInpaymentRow(iRow));
        }
        this.iDefaultAccounts.putAll(iInpayment.getDefaultAccounts());
    }

    public void doAutoIncrecement() {
        List<SSInpayment> iInpayments = SSDB.getInstance().getInpayments();
        int iNumber = SSDB.getInstance().getAutoIncrement().getNumber("inpayment");
        for (SSInpayment iInpayment : iInpayments) {
            if (iInpayment.iNumber <= iNumber) continue;
            iNumber = iInpayment.iNumber;
        }
        this.iNumber = iNumber + 1;
    }

    public Integer getNumber() {
        return this.iNumber;
    }

    public void setNumber(Integer iNumber) {
        this.iNumber = iNumber;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public String getText() {
        return this.iText;
    }

    public void setText(String iText) {
        this.iText = iText;
    }

    public Map<SSDefaultAccount, Integer> getDefaultAccounts() {
        SSNewCompany iCompany;
        if (this.iDefaultAccounts == null && (iCompany = SSDB.getInstance().getCurrentCompany()) != null) {
            this.iDefaultAccounts = iCompany.getDefaultAccounts();
            Object var1_1 = null;
        }
        return this.iDefaultAccounts;
    }

    public SSAccount getDefaultAccount(SSAccountPlan iAccountPlan, SSDefaultAccount iDefaultAccount) {
        Integer iAccountNumber = this.iDefaultAccounts.get(iDefaultAccount);
        if (iAccountNumber == null) {
            return null;
        }
        return iAccountPlan.getAccount(iAccountNumber);
    }

    public Integer getDefaultAccount(SSDefaultAccount iDefaultAccount) {
        return this.iDefaultAccounts.get(iDefaultAccount);
    }

    public void setDefaultAccounts(Map<SSDefaultAccount, Integer> iDefaultAccounts) {
        this.iDefaultAccounts = iDefaultAccounts;
    }

    public List<SSInpaymentRow> getRows() {
        if (this.iRows == null) {
            this.iRows = new LinkedList<SSInpaymentRow>();
        }
        return this.iRows;
    }

    public void setRows(List<SSInpaymentRow> iRows) {
        this.iRows = iRows;
    }

    public SSVoucher getVoucher() {
        return this.iVoucher;
    }

    public void setVoucher(SSVoucher iVoucher) {
        this.iVoucher = iVoucher;
    }

    public SSVoucher getDifference() {
        if (this.iDifference == null) {
            this.iDifference = new SSVoucher();
        }
        return this.iDifference;
    }

    public void setDifference(SSVoucher iDifference) {
        this.iDifference = iDifference;
    }

    public boolean isEntered() {
        return this.iEntered;
    }

    public void setEntered(boolean iEntered) {
        this.iEntered = iEntered;
    }

    public void setEntered() {
        this.iEntered = true;
    }

    public void addInvoices(List<SSInvoice> iInvoices) {
        for (SSInvoice iInvoice : iInvoices) {
            this.iRows.add(new SSInpaymentRow(iInvoice));
        }
    }

    public List<SSInvoice> getInvoices() {
        LinkedList<SSInvoice> iInvoices = new LinkedList<SSInvoice>();
        for (SSInpaymentRow iRow : this.iRows) {
            if (iRow.getInvoice(SSDB.getInstance().getInvoices()) == null) continue;
            iInvoices.add(iRow.getInvoice(SSDB.getInstance().getInvoices()));
        }
        return iInvoices;
    }

    public boolean isPaying(SSInvoice iInvoice) {
        for (SSInpaymentRow iRow : this.iRows) {
            if (!iRow.isPaying(iInvoice)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(", ");
        sb.append(this.iText);
        return sb.toString();
    }

    @Override
    public String toRenderString() {
        return this.iNumber == null ? null : this.iNumber.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSInpayment)) {
            return false;
        }
        return this.iNumber.equals(((SSInpayment)obj).iNumber);
    }

    public SSVoucher generateVoucher() {
        String iDescription = SSBundle.getBundle().getString("inpaymentframe.voucherdescription");
        SSAccountPlan iAccountPlan = SSDB.getInstance().getCurrentAccountPlan();
        BigDecimal iSum = SSInpaymentMath.getSum(this);
        BigDecimal iCurrencyRateDifference = SSInpaymentMath.getCurrencyRateDifference(this);
        BigDecimal iDifferenceSum = SSVoucherMath.getCreditMinusDebetSum(this.iDifference);
        iSum = iSum.subtract(iCurrencyRateDifference);
        iSum = iSum.subtract(iDifferenceSum);
        this.iVoucher = new SSVoucher();
        this.iVoucher.setDate(new Date());
        this.iVoucher.setNumber(0);
        this.iVoucher.setDescription(String.format(iDescription, this.iNumber));
        this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.CustomerClaim), iSum.negate());
        if (iCurrencyRateDifference.signum() > 0) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.CurrencyProfit), iCurrencyRateDifference.negate());
        } else {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.CurrencyLoss), iCurrencyRateDifference.negate());
        }
        for (SSVoucherRow iVoucherRow : this.iDifference.getRows()) {
            this.iVoucher.addVoucherRow(new SSVoucherRow(iVoucherRow));
        }
        for (SSInpaymentRow iRow : this.iRows) {
            SSVoucherRow iVoucherRow = new SSVoucherRow();
            BigDecimal iValue = SSInpaymentMath.convertToLocal(iRow, iRow.getValue());
            iVoucherRow.setValue(iValue);
            iVoucherRow.setAccount(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.InPayment));
            this.iVoucher.addVoucherRow(iVoucherRow);
        }
        this.iVoucher = SSVoucherMath.compress(this.iVoucher);
        return this.iVoucher;
    }
}

