/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSInventoryRow;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSInventory
implements Serializable {
    private static final long serialVersionUID = 5324014159041899233L;
    public Integer iNumber;
    public Date iDate;
    public String iText;
    public List<SSInventoryRow> iRows;

    public SSInventory() {
        this.iNumber = 0;
        this.iDate = new Date();
        this.iText = "";
        this.iRows = new LinkedList<SSInventoryRow>();
        this.doAutoIncrement();
    }

    public SSInventory(SSInventory iInventory) {
        this.copyFrom(iInventory);
    }

    public void doAutoIncrement() {
        this.iNumber = 1;
        List<SSInventory> iInventories = SSDB.getInstance().getInventories();
        for (SSInventory iInventory : iInventories) {
            if (iInventory.iNumber < this.iNumber) continue;
            this.iNumber = iInventory.iNumber + 1;
        }
    }

    public void copyFrom(SSInventory iInventory) {
        this.iNumber = iInventory.iNumber;
        this.iDate = iInventory.iDate;
        this.iText = iInventory.iText;
        this.iRows = new LinkedList<SSInventoryRow>();
        for (SSInventoryRow iRow : iInventory.iRows) {
            this.iRows.add(new SSInventoryRow(iRow));
        }
    }

    public Integer getNumber() {
        return this.iNumber;
    }

    public void setNumber(Integer iNumber) {
        this.iNumber = iNumber;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public String getText() {
        return this.iText;
    }

    public void setText(String iText) {
        this.iText = iText;
    }

    public List<SSInventoryRow> getRows() {
        return this.iRows;
    }

    public void setRows(List<SSInventoryRow> iRows) {
        this.iRows = iRows;
    }

    public Integer getChange(SSProduct iProduct) {
        Integer iSum = 0;
        for (SSInventoryRow iRow : this.iRows) {
            Integer iChange;
            if (!iRow.hasProduct(iProduct) || (iChange = iRow.getChange()) == null) continue;
            iSum = iSum + iChange;
        }
        return iSum;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSInventory)) {
            return false;
        }
        return this.iNumber.equals(((SSInventory)obj).iNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSInventory");
        sb.append("{iDate=").append(this.iDate);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iRows=").append(this.iRows);
        sb.append(", iText='").append(this.iText).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

