/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSInventoryRow
implements Serializable {
    private static final long serialVersionUID = 6027445105394812104L;
    private String iProductNr;
    private Integer iQuantity;
    private Integer iChange;
    private transient SSProduct iProduct;

    public SSInventoryRow() {
        this.iChange = 0;
        this.iQuantity = 0;
        this.iProductNr = null;
        this.iProduct = null;
    }

    public SSInventoryRow(SSInventoryRow iInventoryRow) {
        this.copyFrom(iInventoryRow);
    }

    public SSInventoryRow(SSProduct iProduct, int iChange) {
        this.iChange = iChange;
        this.iProduct = iProduct;
        this.iProductNr = iProduct == null ? null : iProduct.getNumber();
    }

    public void copyFrom(SSInventoryRow iInventoryRow) {
        this.iProductNr = iInventoryRow.iProductNr;
        this.iChange = iInventoryRow.iChange;
        this.iQuantity = iInventoryRow.iQuantity;
        this.iProduct = iInventoryRow.iProduct;
    }

    public String getProductNr() {
        return this.iProductNr;
    }

    public void setProductNr(String iProductNr) {
        this.iProductNr = iProductNr;
    }

    public Integer getStockQuantity() {
        return this.iQuantity;
    }

    public void setStockQuantity(Integer iQuantity) {
        this.iQuantity = iQuantity;
    }

    public Integer getInventoryQuantity() {
        if (this.iQuantity == null || this.iChange == null) {
            return null;
        }
        return this.iQuantity + this.iChange;
    }

    public void setInventoryQuantity(Integer iValue) {
        if (this.iQuantity == null || iValue == null) {
            return;
        }
        this.iChange = iValue - this.iQuantity;
    }

    public Integer getChange() {
        return this.iChange;
    }

    public void setChange(Integer iChange) {
        this.iChange = iChange;
    }

    public SSProduct getProduct() {
        return this.getProduct(SSDB.getInstance().getProducts());
    }

    public SSProduct getProduct(List<SSProduct> iProducts) {
        if (this.iProduct == null && this.iProductNr != null) {
            for (SSProduct iCurrent : iProducts) {
                if (!this.iProductNr.equals(iCurrent.getNumber())) continue;
                this.iProduct = iCurrent;
                break;
            }
        }
        return this.iProduct;
    }

    public void setProduct(SSProduct iProduct) {
        this.iProduct = iProduct;
        this.iProductNr = iProduct == null ? null : iProduct.getNumber();
    }

    public boolean hasProduct(SSProduct iProduct) {
        return this.iProductNr != null && this.iProductNr.equals(iProduct.getNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSInventoryRow");
        sb.append("{iChange=").append(this.iChange);
        sb.append(", iProduct=").append(this.iProduct);
        sb.append(", iProductNr='").append(this.iProductNr).append('\'');
        sb.append(", iQuantity=").append(this.iQuantity);
        sb.append('}');
        return sb.toString();
    }
}

