/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSAccountingYear;
import se.swedsoft.bookkeeping.data.SSBudget;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSNewAccountingYear
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private Integer iId;
    private Date iFrom;
    private Date iTo;
    private SSAccountPlan iPlan;
    private Map<SSAccount, BigDecimal> iInBalance;
    private SSBudget iBudget;

    public SSNewAccountingYear() {
        this.iId = 0;
        this.iFrom = new Date();
        this.iTo = new Date();
        this.iInBalance = new HashMap<SSAccount, BigDecimal>();
        this.iBudget = new SSBudget();
    }

    public SSNewAccountingYear(Date pFrom, Date pTo) {
        this();
        this.iFrom = pFrom;
        this.iTo = pTo;
    }

    public SSNewAccountingYear(SSNewAccountingYear pAccountingYear) {
        this();
        this.setData(pAccountingYear);
    }

    public SSNewAccountingYear(SSAccountingYear iOldYear) {
        this.iFrom = iOldYear.getFrom();
        this.iTo = iOldYear.getTo();
        this.iPlan = iOldYear.getAccountPlan();
        this.iInBalance = iOldYear.getInBalance();
        this.iBudget = iOldYear.getBudget();
    }

    public void setData(SSNewAccountingYear pAccountingYear) {
        this.iId = pAccountingYear.iId;
        this.iFrom = pAccountingYear.iFrom;
        this.iTo = pAccountingYear.iTo;
        this.iInBalance = pAccountingYear.iInBalance;
        this.iBudget = pAccountingYear.iBudget;
        this.iPlan = pAccountingYear.iPlan;
    }

    public Integer getId() {
        return this.iId;
    }

    public void setId(Integer pId) {
        this.iId = pId;
    }

    public Date getFrom() {
        return this.iFrom;
    }

    public void setFrom(Date pFrom) {
        this.iFrom = pFrom;
    }

    public Date getTo() {
        return this.iTo;
    }

    public void setTo(Date pTo) {
        this.iTo = pTo;
    }

    public SSAccountPlan getAccountPlan() {
        if (this.iPlan == null) {
            this.iPlan = new SSAccountPlan();
        }
        return this.iPlan;
    }

    public void setAccountPlan(SSAccountPlan pAccountPlan) {
        this.iPlan = pAccountPlan;
    }

    public SSBudget getBudget() {
        this.iBudget.setYear(this);
        return this.iBudget;
    }

    public void setBudget(SSBudget iBudget) {
        this.iBudget = iBudget;
    }

    public Map<SSAccount, BigDecimal> getInBalance() {
        return this.iInBalance;
    }

    public void setInBalance(Map<SSAccount, BigDecimal> pInBalance) {
        this.iInBalance = pInBalance;
    }

    public List<SSVoucher> getVouchers() {
        return SSDB.getInstance().getVouchers(this);
    }

    public List<SSAccount> getAccounts() {
        if (this.iPlan != null) {
            return this.iPlan.getAccounts();
        }
        return Collections.emptyList();
    }

    public List<SSAccount> getActiveAccounts() {
        if (this.iPlan != null) {
            return this.iPlan.getActiveAccounts();
        }
        return Collections.emptyList();
    }

    @Override
    public String toRenderString() {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        return iFormat.format(this.iFrom) + " - " + iFormat.format(this.iTo);
    }

    public String toString() {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        StringBuilder sb = new StringBuilder();
        sb.append(iFormat.format(this.iFrom));
        sb.append(' ');
        sb.append(SSBundle.getBundle().getString("date.separator"));
        sb.append(' ');
        sb.append(iFormat.format(this.iTo));
        return sb.toString();
    }

    public void setInBalance(SSAccount pAccount, BigDecimal pAmount) {
        if (this.iInBalance == null) {
            this.iInBalance = new HashMap<SSAccount, BigDecimal>();
        }
        this.iInBalance.put(pAccount, pAmount);
    }

    public BigDecimal getInBalance(SSAccount pAccount) {
        BigDecimal amount;
        if (this.iInBalance == null) {
            this.iInBalance = new HashMap<SSAccount, BigDecimal>();
        }
        if ((amount = this.iInBalance.get(pAccount)) == null) {
            amount = new BigDecimal(0);
        }
        return amount;
    }

    public static void openWarningDialogNoYearData(SSMainFrame iMainFrame) {
        String message = SSBundle.getBundle().getString("accountingYear.no.year.message");
        String title = SSBundle.getBundle().getString("accountingYear.no.year.title");
        JOptionPane.showMessageDialog(iMainFrame, message, title, 1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSNewAccountingYear)) {
            return false;
        }
        return this.iId.equals(((SSNewAccountingYear)obj).iId);
    }
}

