/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSResultUnit;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSNewResultUnit
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private String iNumber;
    private String iName;
    private String iDescription;

    public SSNewResultUnit() {
        this.iNumber = "";
        this.iName = "";
        this.iDescription = "";
    }

    public SSNewResultUnit(String number, String name) {
        this.iNumber = number;
        this.iName = name;
        this.iDescription = "";
    }

    public SSNewResultUnit(SSResultUnit iOld) {
        this.iNumber = String.valueOf(iOld.getNumber());
        this.iName = iOld.getName();
        this.iDescription = iOld.getDescription();
    }

    public String getNumber() {
        return this.iNumber;
    }

    public void setNumber(String pNumber) {
        this.iNumber = pNumber;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String pName) {
        this.iName = pName;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String pDescription) {
        this.iDescription = pDescription;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSNewResultUnit) {
            return ((SSNewResultUnit)obj).iNumber.equals(this.iNumber);
        }
        return super.equals(obj);
    }

    @Override
    public String toRenderString() {
        return this.iNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(" - ");
        sb.append(this.iName);
        sb.append(", ");
        sb.append(this.iDescription);
        return sb.toString();
    }

    public BigDecimal getResultUnitRevenueForMonth(SSMonth iMonth) {
        Double iInvoiceSum = 0.0;
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInvoice iInvoice : iInvoices) {
            if (!iMonth.isDateInMonth(iInvoice.getDate())) continue;
            for (SSSaleRow iRow : iInvoice.getRows()) {
                if (iRow.getResultUnitNr() == null || !iRow.getResultUnitNr().equals(this.iNumber) || iRow.getSum() == null) continue;
                iInvoiceSum = iInvoiceSum + iRow.getSum().doubleValue() * iInvoice.getCurrencyRate().doubleValue();
            }
        }
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        Double iCreditInvoiceSum = 0.0;
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (!iMonth.isDateInMonth(iCreditInvoice.getDate())) continue;
            for (SSSaleRow iRow : iCreditInvoice.getRows()) {
                if (iRow.getResultUnitNr() == null || !iRow.getResultUnitNr().equals(this.iNumber) || iRow.getSum() == null) continue;
                iCreditInvoiceSum = iCreditInvoiceSum + iRow.getSum().doubleValue() * iCreditInvoice.getCurrencyRate().doubleValue();
            }
        }
        return new BigDecimal(iInvoiceSum - iCreditInvoiceSum);
    }
}

