/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSOutdeliveryRow
implements Serializable {
    private static final long serialVersionUID = -9210187383331088946L;
    private String iProductNr;
    private Integer iChange;
    private transient SSProduct iProduct;

    public SSOutdeliveryRow() {
    }

    public SSOutdeliveryRow(SSOutdeliveryRow iOutdeliveryRow) {
        this.copyFrom(iOutdeliveryRow);
    }

    public SSOutdeliveryRow(SSProduct iProduct, int iChange) {
        this.iChange = iChange;
        this.iProduct = iProduct;
        this.iProductNr = iProduct == null ? null : iProduct.getNumber();
    }

    public void copyFrom(SSOutdeliveryRow iOutdeliveryRow) {
        this.iProductNr = iOutdeliveryRow.iProductNr;
        this.iChange = iOutdeliveryRow.iChange;
        this.iProduct = iOutdeliveryRow.iProduct;
    }

    public String getProductNr() {
        return this.iProductNr;
    }

    public void setProductNr(String iProductNr) {
        this.iProductNr = iProductNr;
    }

    public Integer getChange() {
        return this.iChange;
    }

    public void setChange(Integer iChange) {
        this.iChange = iChange;
    }

    public SSProduct getProduct() {
        if (this.iProduct == null && this.iProductNr != null) {
            List<SSProduct> iProducts = SSDB.getInstance().getProducts();
            for (SSProduct iCurrent : iProducts) {
                if (!this.iProductNr.equals(iCurrent.getNumber())) continue;
                this.iProduct = iCurrent;
                break;
            }
        }
        return this.iProduct;
    }

    public void setProduct(SSProduct iProduct) {
        this.iProduct = iProduct;
        this.iProductNr = iProduct == null ? null : iProduct.getNumber();
    }

    public boolean hasProduct(SSProduct iProduct) {
        return this.iProductNr != null && this.iProductNr.equals(iProduct.getNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSOutdeliveryRow");
        sb.append("{iChange=").append(this.iChange);
        sb.append(", iProduct=").append(this.iProduct);
        sb.append(", iProductNr='").append(this.iProductNr).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

