/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSProduct
implements SSTableSearchable,
Serializable {
    static final long serialVersionUID = 1L;
    private String iNumber;
    private String iDescription;
    private BigDecimal iUnitprice;
    private SSTaxCode iTaxCode;
    private String iWarehouseLocation;
    private Integer iOrderpoint;
    private Integer iOrdercount;
    private BigDecimal iPurchasePrice;
    private BigDecimal iStockPrice;
    private BigDecimal iFreight;
    private String iSupplierNr;
    private String iSupplierProductNr;
    private boolean iExpired;
    private boolean iStockGoods;
    private SSUnit iUnit;
    private BigDecimal iWeight;
    private BigDecimal iVolume;
    private Map<SSDefaultAccount, Integer> iDefaultAccounts;
    private Integer iProjectNr;
    private String iProjectNumber;
    private Integer iResultUnitNr;
    private String iResultUnitNumber;
    private List<SSProductRow> iProductRows;
    private transient SSSupplier iSupplier;
    private transient SSNewProject iProject;
    private transient SSNewResultUnit iResultUnit;
    private Map<Locale, String> iDescriptions;

    public SSProduct() {
        this.iProductRows = new LinkedList<SSProductRow>();
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iUnitprice = new BigDecimal(0);
        this.iPurchasePrice = new BigDecimal(0);
        this.iStockPrice = new BigDecimal(0);
        this.iFreight = new BigDecimal(0);
        this.iTaxCode = SSTaxCode.TAXRATE_1;
        this.iStockGoods = true;
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.iUnit = iCompany.getStandardUnit();
            this.iDefaultAccounts.put(SSDefaultAccount.Sales, iCompany.getDefaultAccount(SSDefaultAccount.Sales));
            this.iDefaultAccounts.put(SSDefaultAccount.Purchases, iCompany.getDefaultAccount(SSDefaultAccount.Purchases));
        }
    }

    public SSProduct(SSProduct iProduct) {
        this.copyFrom(iProduct);
    }

    public void copyFrom(SSProduct iProduct) {
        this.iNumber = iProduct.iNumber;
        this.iDescription = iProduct.iDescription;
        this.iUnitprice = iProduct.iUnitprice;
        this.iTaxCode = iProduct.iTaxCode;
        this.iWarehouseLocation = iProduct.iWarehouseLocation;
        this.iOrderpoint = iProduct.iOrderpoint;
        this.iOrdercount = iProduct.iOrdercount;
        this.iPurchasePrice = iProduct.iPurchasePrice;
        this.iStockPrice = iProduct.iStockPrice;
        this.iFreight = iProduct.iFreight;
        this.iSupplierNr = iProduct.iSupplierNr;
        this.iSupplierProductNr = iProduct.iSupplierProductNr;
        this.iExpired = iProduct.iExpired;
        this.iStockGoods = iProduct.iStockGoods;
        this.iUnit = iProduct.iUnit;
        this.iWeight = iProduct.iWeight;
        this.iVolume = iProduct.iVolume;
        this.iSupplier = iProduct.iSupplier;
        this.iDescriptions = new HashMap<Locale, String>();
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iProductRows = new LinkedList<SSProductRow>();
        this.iDefaultAccounts.put(SSDefaultAccount.Sales, iProduct.iDefaultAccounts.get(SSDefaultAccount.Sales));
        this.iDefaultAccounts.put(SSDefaultAccount.Purchases, iProduct.iDefaultAccounts.get(SSDefaultAccount.Purchases));
        this.iProject = iProduct.iProject;
        this.iProjectNumber = iProduct.iProjectNumber;
        this.iResultUnit = iProduct.iResultUnit;
        this.iResultUnitNumber = iProduct.iResultUnitNumber;
        for (SSProductRow iProductRow : iProduct.iProductRows) {
            this.iProductRows.add(new SSProductRow(iProductRow));
        }
        this.iDescriptions.putAll(iProduct.getDescriptions());
    }

    public String getNumber() {
        return this.iNumber;
    }

    public void setNumber(String iNumber) {
        this.iNumber = iNumber;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public String getDescription(Locale iLocale) {
        String iDescription;
        if (this.iDescriptions == null) {
            this.iDescriptions = new HashMap<Locale, String>();
        }
        if ((iDescription = this.iDescriptions.get(iLocale)) == null || iDescription.trim().length() == 0) {
            return null;
        }
        return iDescription;
    }

    public void setDescription(Locale iLocale, String iDescription) {
        if (this.iDescriptions == null) {
            this.iDescriptions = new HashMap<Locale, String>();
        }
        this.iDescriptions.put(iLocale, iDescription);
    }

    public String getResultUnitNr() {
        return this.iResultUnitNumber;
    }

    public void setResultUnitNr(String iResultUnitNr) {
        this.iResultUnitNumber = iResultUnitNr;
    }

    public String getProjectNr() {
        return this.iProjectNumber;
    }

    public void setProjectNr(String iProjectNr) {
        this.iProjectNumber = iProjectNr;
    }

    public SSNewProject getProject() {
        return this.iProject;
    }

    public SSNewProject getProject(String iNumber) {
        for (SSNewProject pProject : SSDB.getInstance().getProjects()) {
            if (!pProject.getNumber().equals(iNumber)) continue;
            return pProject;
        }
        return null;
    }

    public void setProject(SSNewProject iProject) {
        this.iProject = iProject;
        this.iProjectNumber = iProject == null ? null : iProject.getNumber();
    }

    public SSNewResultUnit getResultUnit() {
        return this.iResultUnit;
    }

    public SSNewResultUnit getResultUnit(String iNumber) {
        for (SSNewResultUnit pResultUnit : SSDB.getInstance().getResultUnits()) {
            if (!pResultUnit.getNumber().equals(iNumber)) continue;
            return pResultUnit;
        }
        return null;
    }

    public void setResultUnit(SSNewResultUnit iResultUnit) {
        this.iResultUnit = iResultUnit;
        this.iResultUnitNumber = iResultUnit == null ? null : iResultUnit.getNumber();
    }

    public void fixResultUnitAndProject() {
        if (this.iResultUnitNr != null && this.iResultUnitNumber == null) {
            this.iResultUnitNumber = this.iResultUnitNr.toString();
        }
        if (this.iProjectNr != null && this.iProjectNumber == null) {
            this.iProjectNumber = this.iProjectNr.toString();
        }
    }

    public Map<Locale, String> getDescriptions() {
        if (this.iDescriptions == null) {
            this.iDescriptions = new HashMap<Locale, String>();
        }
        return this.iDescriptions;
    }

    public void setDescriptions(Map<Locale, String> iDescriptions) {
        this.iDescriptions = iDescriptions;
    }

    public BigDecimal getSellingPrice() {
        this.iUnitprice = this.iUnitprice.setScale(2, 4);
        return this.iUnitprice;
    }

    public void setSellingPrice(BigDecimal iUnitprice) {
        this.iUnitprice = iUnitprice;
    }

    public SSTaxCode getTaxCode() {
        return this.iTaxCode;
    }

    public BigDecimal getTaxRate() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (this.iTaxCode != null && iCompany != null) {
            return iCompany.getTaxRate(this.iTaxCode);
        }
        return null;
    }

    public void setTaxCode(SSTaxCode iTaxCode) {
        this.iTaxCode = iTaxCode;
    }

    public String getWarehouseLocation() {
        return this.iWarehouseLocation;
    }

    public void setWarehouseLocation(String iWarehouseLocation) {
        this.iWarehouseLocation = iWarehouseLocation;
    }

    public Integer getOrderpoint() {
        return this.iOrderpoint;
    }

    public void setOrderpoint(Integer iOrderpoint) {
        this.iOrderpoint = iOrderpoint;
    }

    public Integer getOrdercount() {
        return this.iOrdercount;
    }

    public void setOrdercount(Integer iOrdercount) {
        this.iOrdercount = iOrdercount;
    }

    public BigDecimal getPurchasePrice() {
        return this.iPurchasePrice;
    }

    public void setPurchasePrice(BigDecimal iPurchasePrice) {
        this.iPurchasePrice = iPurchasePrice;
    }

    public BigDecimal getStockPrice() {
        return this.iStockPrice;
    }

    public void setStockPrice(BigDecimal iStockPrice) {
        this.iStockPrice = iStockPrice;
    }

    public BigDecimal getUnitFreight() {
        return this.iFreight;
    }

    public void setUnitFreight(BigDecimal iFreight) {
        this.iFreight = iFreight;
    }

    public String getSupplierNr() {
        return this.iSupplierNr;
    }

    public void setSupplierNr(String iSupplierNr) {
        this.iSupplierNr = iSupplierNr;
        this.iSupplier = null;
    }

    public SSSupplier getSupplier(List<SSSupplier> iSuppliers) {
        if (this.iSupplier == null) {
            for (SSSupplier iCurrent : iSuppliers) {
                if (!iCurrent.getNumber().equals(this.iSupplierNr)) continue;
                this.iSupplier = iCurrent;
            }
        }
        return this.iSupplier;
    }

    public void setSupplier(SSSupplier iSupplier) {
        this.iSupplier = iSupplier;
        this.iSupplierNr = iSupplier == null ? null : iSupplier.getNumber();
    }

    public String getSupplierProductNr() {
        return this.iSupplierProductNr;
    }

    public void setSupplierProductNr(String iSupplierProductNr) {
        this.iSupplierProductNr = iSupplierProductNr;
    }

    public boolean isExpired() {
        return this.iExpired;
    }

    public void setExpired(boolean iExpired) {
        this.iExpired = iExpired;
    }

    public boolean isStockProduct() {
        return this.iStockGoods;
    }

    public void setStockProduct(boolean iStockGoods) {
        this.iStockGoods = iStockGoods;
    }

    public SSUnit getUnit() {
        return this.iUnit;
    }

    public void setUnit(SSUnit iUnit) {
        this.iUnit = iUnit;
    }

    public BigDecimal getWeight() {
        if (this.iWeight == null) {
            this.iWeight = new BigDecimal(0);
        }
        return this.iWeight;
    }

    public void setWeight(BigDecimal iWeight) {
        this.iWeight = iWeight;
    }

    public BigDecimal getVolume() {
        if (this.iVolume == null) {
            this.iVolume = new BigDecimal(0);
        }
        return this.iVolume;
    }

    public void setVolume(BigDecimal iVolume) {
        this.iVolume = iVolume;
    }

    public Integer getDefaultAccount(SSDefaultAccount iDefaultAccount) {
        if (this.iDefaultAccounts == null) {
            this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        }
        if (this.iDefaultAccounts.containsKey(iDefaultAccount)) {
            return this.iDefaultAccounts.get(iDefaultAccount);
        }
        return iDefaultAccount.getDefaultAccountNumber();
    }

    public Integer getDefaultAccount(SSDefaultAccount iDefaultAccount, Integer iDefault) {
        if (this.iDefaultAccounts == null) {
            this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        }
        if (this.iDefaultAccounts.containsKey(iDefaultAccount)) {
            return this.iDefaultAccounts.get(iDefaultAccount);
        }
        return iDefault;
    }

    public void setDefaultAccount(SSDefaultAccount iDefaultAccount, Integer iAccount) {
        if (this.iDefaultAccounts == null) {
            this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        }
        this.iDefaultAccounts.put(iDefaultAccount, iAccount);
    }

    public void setDefaultAccount(SSDefaultAccount iDefaultAccount, SSAccount iAccount) {
        if (iAccount != null) {
            this.setDefaultAccount(iDefaultAccount, iAccount.getNumber());
        }
    }

    public List<SSProductRow> getParcelRows() {
        if (this.iProductRows == null) {
            this.iProductRows = new LinkedList<SSProductRow>();
        }
        return this.iProductRows;
    }

    public void setParcelRows(List<SSProductRow> iParcelRows) {
        this.iProductRows = iParcelRows;
    }

    public boolean isParcel() {
        return !this.getParcelRows().isEmpty();
    }

    public boolean equals(Object obj) {
        if (this.iNumber == null) {
            return false;
        }
        if (obj instanceof SSProduct) {
            SSProduct iProduct = (SSProduct)obj;
            return this.iNumber.equals(iProduct.iNumber);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(", ");
        sb.append(this.iDescription);
        return sb.toString();
    }

    @Override
    public String toRenderString() {
        return this.iNumber;
    }

    public BigDecimal getProductRevenueForMonth(SSMonth iMonth) {
        Double iInvoiceSum = 0.0;
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInvoice iInvoice : iInvoices) {
            if (!iMonth.isDateInMonth(iInvoice.getDate())) continue;
            for (SSSaleRow iRow : iInvoice.getRows()) {
                if (iRow.getProductNr() == null || !iRow.getProductNr().equals(this.iNumber) || iRow.getSum() == null) continue;
                iInvoiceSum = iInvoiceSum + iRow.getSum().doubleValue() * iInvoice.getCurrencyRate().doubleValue();
            }
        }
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        Double iCreditInvoiceSum = 0.0;
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (!iMonth.isDateInMonth(iCreditInvoice.getDate())) continue;
            for (SSSaleRow iRow : iCreditInvoice.getRows()) {
                if (iRow.getProductNr() == null || !iRow.getProductNr().equals(this.iNumber) || iRow.getSum() == null) continue;
                iCreditInvoiceSum = iCreditInvoiceSum + iRow.getSum().doubleValue() * iCreditInvoice.getCurrencyRate().doubleValue();
            }
        }
        return new BigDecimal(iInvoiceSum - iCreditInvoiceSum);
    }
}

