/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSProductRow
implements Serializable {
    static final long serialVersionUID = 1L;
    private String iProductNr;
    private String iDescription;
    private Integer iCount;
    private transient SSProduct iProduct;

    public SSProductRow() {
    }

    public SSProductRow(SSProductRow iProductRow) {
        this.iProductNr = iProductRow.iProductNr;
        this.iCount = iProductRow.iCount;
        this.iDescription = iProductRow.iDescription;
        this.iProduct = iProductRow.iProduct;
    }

    public String getProductNr() {
        return this.iProductNr;
    }

    public void setProduct(String iProductNr) {
        this.iProductNr = iProductNr;
        this.iProduct = null;
    }

    public String getDescription() {
        if (this.iDescription == null && this.iProduct != null) {
            return this.iProduct.getDescription();
        }
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public Integer getQuantity() {
        return this.iCount;
    }

    public void setQuantity(Integer iCount) {
        this.iCount = iCount;
    }

    public SSProduct getProduct() {
        return this.getProduct(SSDB.getInstance().getProducts());
    }

    public SSProduct getProduct(List<SSProduct> iProducts) {
        if (this.iProduct == null) {
            for (SSProduct iCurrent : iProducts) {
                if (!iCurrent.getNumber().equals(this.iProductNr)) continue;
                this.iProduct = iCurrent;
            }
        }
        return this.iProduct;
    }

    public void setProduct(SSProduct iProduct) {
        this.iProduct = iProduct;
        String string = this.iProductNr = iProduct == null ? null : iProduct.getNumber();
        if (iProduct != null) {
            this.iCount = 1;
            this.iDescription = iProduct.getDescription();
        }
    }

    public boolean hasProduct(SSProduct iProduct) {
        return this.iProductNr != null && this.iProductNr.equals(iProduct.getNumber());
    }

    public boolean isValidRow() {
        return this.iProductNr != null && this.iCount != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iProductNr);
        sb.append(", ");
        sb.append(this.iDescription);
        sb.append(", ");
        sb.append(this.iCount);
        return sb.toString();
    }
}

