/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSProject
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private int iNumber;
    private String iName;
    private String iDescription;
    private boolean iConcluded;
    private Date iConcludedDate;

    public SSProject() {
    }

    public SSProject(int pNumber, String pName, String pDescription) {
        this.iNumber = pNumber;
        this.iName = pName;
        this.iDescription = pDescription;
        this.iConcluded = false;
        this.iConcludedDate = null;
    }

    public int getNumber() {
        return this.iNumber;
    }

    public void setNumber(int number) {
        this.iNumber = number;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    public boolean getConcluded() {
        return this.iConcluded;
    }

    public void setConcluded(boolean pConcluded) {
        this.iConcluded = pConcluded;
    }

    public Date getConcludedDate() {
        return this.iConcludedDate;
    }

    public void setConcludedDate(Date pConcluded) {
        this.iConcludedDate = pConcluded;
    }

    public boolean isConcluded(Date iDate) {
        return this.iConcluded && this.iConcludedDate != null && this.iConcludedDate.getTime() <= iDate.getTime();
    }

    public String toString() {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(" - ");
        sb.append(this.iName);
        sb.append(", ");
        sb.append(this.iDescription);
        if (this.iConcluded) {
            sb.append("(Concluded ");
            sb.append(iFormat.format(this.iConcludedDate));
            sb.append(") ");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSProject) {
            return ((SSProject)obj).iNumber == this.iNumber;
        }
        return false;
    }

    @Override
    public String toRenderString() {
        return Integer.toString(this.iNumber);
    }
}

