/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSPurchaseOrderRow;
import se.swedsoft.bookkeeping.data.SSStandardText;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSPurchaseOrder
implements SSTableSearchable,
Serializable {
    private static final long serialVersionUID = 6529008747056659550L;
    protected Integer iNumber;
    private Integer iInvoiceNr;
    protected Date iDate;
    protected String iSupplierNr;
    protected String iSupplierName;
    protected Date iEstimatedDelivery;
    protected SSPaymentTerm iPaymentTerm;
    protected SSDeliveryTerm iDeliveryTerm;
    protected SSDeliveryWay iDeliveryWay;
    protected String iOurContact;
    protected String iYourContact;
    protected SSCurrency iCurrency;
    protected BigDecimal iCurrencyRate;
    protected SSAddress iDeliveryAddress;
    protected SSAddress iSupplierAddress;
    private String iText;
    protected boolean iPrinted;
    private boolean iStockInfluencing;
    protected List<SSPurchaseOrderRow> iRows;
    protected Map<SSDefaultAccount, Integer> iDefaultAccounts;
    protected transient SSSupplier iSupplier;
    private transient SSSupplierInvoice iInvoice;

    public SSPurchaseOrder() {
        this.iRows = new LinkedList<SSPurchaseOrderRow>();
        this.iDeliveryAddress = new SSAddress();
        this.iSupplierAddress = new SSAddress();
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iEstimatedDelivery = new Date();
        this.iStockInfluencing = true;
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.setDefaultAccounts(iCompany.getDefaultAccounts());
            this.iDeliveryAddress = new SSAddress(iCompany.getDeliveryAddress());
            this.iText = iCompany.getStandardText(SSStandardText.Purchaseorder);
        }
        if (this.iSupplier != null) {
            this.iCurrency = this.iSupplier.getCurrency();
            this.iCurrencyRate = this.iCurrency.getExchangeRate();
        }
    }

    public SSPurchaseOrder(SSPurchaseOrder iPurchaseOrder) {
        this.iNumber = iPurchaseOrder.iNumber;
        this.iDate = iPurchaseOrder.iDate;
        this.iSupplierNr = iPurchaseOrder.iSupplierNr;
        this.iSupplierName = iPurchaseOrder.iSupplierName;
        this.iEstimatedDelivery = iPurchaseOrder.iEstimatedDelivery;
        this.iPaymentTerm = iPurchaseOrder.iPaymentTerm;
        this.iDeliveryTerm = iPurchaseOrder.iDeliveryTerm;
        this.iDeliveryWay = iPurchaseOrder.iDeliveryWay;
        this.iOurContact = iPurchaseOrder.iOurContact;
        this.iYourContact = iPurchaseOrder.iYourContact;
        this.iCurrency = iPurchaseOrder.iCurrency;
        this.iSupplier = iPurchaseOrder.iSupplier;
        this.iText = iPurchaseOrder.iText;
        this.iInvoice = iPurchaseOrder.iInvoice;
        this.iInvoiceNr = iPurchaseOrder.iInvoiceNr;
        this.iPrinted = iPurchaseOrder.iPrinted;
        this.iCurrencyRate = iPurchaseOrder.iCurrencyRate;
        this.iDeliveryAddress = new SSAddress(iPurchaseOrder.iDeliveryAddress);
        this.iSupplierAddress = new SSAddress(iPurchaseOrder.iSupplierAddress);
        this.iRows = new LinkedList<SSPurchaseOrderRow>();
        for (SSPurchaseOrderRow iRow : iPurchaseOrder.iRows) {
            this.iRows.add(new SSPurchaseOrderRow(iRow));
        }
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iDefaultAccounts.putAll(iPurchaseOrder.getDefaultAccounts());
    }

    public SSPurchaseOrder(List<SSProduct> iProducts, SSSupplier iSupplier) {
        this.setSupplier(iSupplier);
        this.iRows = new LinkedList<SSPurchaseOrderRow>();
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iStockInfluencing = true;
        this.iEstimatedDelivery = Calendar.getInstance().getTime();
        this.iDate = Calendar.getInstance().getTime();
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.setDefaultAccounts(iCompany.getDefaultAccounts());
            this.iDeliveryAddress = new SSAddress(iCompany.getDeliveryAddress());
            this.iText = iCompany.getStandardText(SSStandardText.Purchaseorder);
        }
        if (this.iSupplier != null) {
            this.iCurrency = this.iSupplier.getCurrency();
            this.iCurrencyRate = this.iCurrency == null ? null : this.iCurrency.getExchangeRate();
        }
        for (SSProduct iProduct : iProducts) {
            SSProduct iOriginal = SSDB.getInstance().getProduct(iProduct);
            if (iOriginal == null) continue;
            SSPurchaseOrderRow iRow = new SSPurchaseOrderRow();
            iRow.setProduct(iOriginal);
            iRow.setQuantity(iProduct.getOrdercount());
            this.iRows.add(iRow);
        }
    }

    public void doAutoIncrecement() {
        List<SSPurchaseOrder> iPurchaseOrders = SSDB.getInstance().getPurchaseOrders();
        int iNumber = SSDB.getInstance().getAutoIncrement().getNumber("purchaseorder");
        for (SSPurchaseOrder iPurchaseOrder : iPurchaseOrders) {
            if (iPurchaseOrder.iNumber <= iNumber) continue;
            iNumber = iPurchaseOrder.iNumber;
        }
        this.iNumber = iNumber + 1;
    }

    public Integer getNumber() {
        return this.iNumber;
    }

    public void setNumber(Integer iNumber) {
        this.iNumber = iNumber;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public String getSupplierNr() {
        return this.iSupplierNr;
    }

    public void setSupplierNr(String iSupplierNr) {
        this.iSupplierNr = iSupplierNr;
    }

    public String getSupplierName() {
        return this.iSupplierName;
    }

    public void setSupplierName(String iSupplierName) {
        this.iSupplierName = iSupplierName;
    }

    public Date getEstimatedDelivery() {
        return this.iEstimatedDelivery;
    }

    public void setEstimatedDelivery(Date iEstimatedDelivery) {
        this.iEstimatedDelivery = iEstimatedDelivery;
    }

    public SSPaymentTerm getPaymentTerm() {
        return this.iPaymentTerm;
    }

    public void setPaymentTerm(SSPaymentTerm iPaymentTerm) {
        this.iPaymentTerm = iPaymentTerm;
    }

    public SSDeliveryTerm getDeliveryTerm() {
        return this.iDeliveryTerm;
    }

    public void setDeliveryTerm(SSDeliveryTerm iDeliveryTerm) {
        this.iDeliveryTerm = iDeliveryTerm;
    }

    public SSDeliveryWay getDeliveryWay() {
        return this.iDeliveryWay;
    }

    public void setDeliveryWay(SSDeliveryWay iDeliveryWay) {
        this.iDeliveryWay = iDeliveryWay;
    }

    public String getOurContact() {
        return this.iOurContact;
    }

    public void setOurContact(String iOurContact) {
        this.iOurContact = iOurContact;
    }

    public String getYourContact() {
        return this.iYourContact;
    }

    public void setYourContact(String iYourContact) {
        this.iYourContact = iYourContact;
    }

    public SSCurrency getCurrency() {
        return this.iCurrency;
    }

    public void setCurrency(SSCurrency iCurrency) {
        this.iCurrency = iCurrency;
    }

    public BigDecimal getCurrencyRate() {
        if (this.iCurrencyRate != null) {
            return this.iCurrencyRate;
        }
        if (this.iSupplier != null && this.iSupplier.getCurrency() != null) {
            return this.iSupplier.getCurrency().getExchangeRate();
        }
        return new BigDecimal(1);
    }

    public void setCurrencyRate(BigDecimal iCurrencyRate) {
        this.iCurrencyRate = iCurrencyRate;
    }

    public SSAddress getDeliveryAddress() {
        return this.iDeliveryAddress;
    }

    public void setDeliveryAddress(SSAddress iDeliveryAddress) {
        this.iDeliveryAddress = iDeliveryAddress;
    }

    public SSAddress getSupplierAddress() {
        return this.iSupplierAddress;
    }

    public void setSupplierAddress(SSAddress iSupplierAddress) {
        this.iSupplierAddress = iSupplierAddress;
    }

    public void setText(String iText) {
        this.iText = iText;
    }

    public String getText() {
        return this.iText;
    }

    public boolean isPrinted() {
        return this.iPrinted;
    }

    public void setPrinted(boolean iPrinted) {
        this.iPrinted = iPrinted;
    }

    public void setPrinted() {
        this.iPrinted = true;
    }

    public List<SSPurchaseOrderRow> getRows() {
        return this.iRows;
    }

    public void setRows(List<SSPurchaseOrderRow> iRows) {
        this.iRows = iRows;
    }

    public SSSupplier getSupplier() {
        return this.getSupplier(SSDB.getInstance().getSuppliers());
    }

    public SSSupplier getSupplier(List<SSSupplier> iSuppliers) {
        if (this.iSupplier == null) {
            for (SSSupplier iCurrent : iSuppliers) {
                if (!iCurrent.getNumber().equals(this.iSupplierNr)) continue;
                this.iSupplier = iCurrent;
            }
        }
        return this.iSupplier;
    }

    public void setSupplier(SSSupplier iSupplier) {
        this.iSupplier = iSupplier;
        String string = this.iSupplierNr = iSupplier == null ? null : iSupplier.getNumber();
        if (iSupplier != null) {
            this.iSupplierName = iSupplier.getName();
            this.iSupplierAddress = iSupplier.getAddress().clone();
            this.iOurContact = iSupplier.getOurContact();
            this.iYourContact = iSupplier.getYourContact();
            this.iPaymentTerm = iSupplier.getPaymentTerm();
            this.iDeliveryTerm = iSupplier.getDeliveryTerm();
            this.iDeliveryWay = iSupplier.getDeliveryWay();
            this.iCurrency = iSupplier.getCurrency();
        }
    }

    public Map<SSDefaultAccount, Integer> getDefaultAccounts() {
        if (this.iDefaultAccounts == null) {
            this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        }
        return this.iDefaultAccounts;
    }

    public void setDefaultAccounts(Map<SSDefaultAccount, Integer> iDefaultAccounts) {
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iDefaultAccounts.putAll(iDefaultAccounts);
    }

    public Integer getInvoiceNr() {
        return this.iInvoiceNr;
    }

    public void setInvoiceNr(Integer iInvoiceNr) {
        this.iInvoiceNr = iInvoiceNr;
        this.iInvoice = null;
    }

    public SSSupplierInvoice getInvoice() {
        return this.getInvoice(SSDB.getInstance().getSupplierInvoices());
    }

    public SSSupplierInvoice getInvoice(List<SSSupplierInvoice> iInvoices) {
        if (this.iInvoice == null && this.iInvoiceNr != null) {
            for (SSSupplierInvoice iCurrent : iInvoices) {
                if (!this.iInvoiceNr.equals(iCurrent.getNumber())) continue;
                this.iInvoice = iCurrent;
            }
        }
        return this.iInvoice;
    }

    public void setInvoice(SSSupplierInvoice iInvoice) {
        this.iInvoice = iInvoice;
        this.iInvoiceNr = iInvoice == null ? null : iInvoice.getNumber();
    }

    public boolean isStockInfluencing() {
        return this.iStockInfluencing;
    }

    public void setStockInfluencing(boolean iStockInfluencing) {
        this.iStockInfluencing = iStockInfluencing;
    }

    public BigDecimal getSum() {
        BigDecimal iSum = new BigDecimal(0);
        for (SSPurchaseOrderRow iRow : this.iRows) {
            BigDecimal iRowSum = iRow.getSum();
            if (iRowSum == null) continue;
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSPurchaseOrder) {
            SSPurchaseOrder iPurchaseOrder = (SSPurchaseOrder)obj;
            return iPurchaseOrder.iNumber.equals(this.iNumber);
        }
        return false;
    }

    public int hashCode() {
        return this.iNumber;
    }

    @Override
    public String toRenderString() {
        return String.valueOf(this.iNumber);
    }

    public boolean hasInvoice() {
        return this.iInvoiceNr != null;
    }

    public boolean hasInvoice(SSSupplierInvoice iInvoice) {
        return this.iInvoiceNr != null && this.iInvoiceNr.equals(iInvoice.getNumber());
    }

    public boolean hasSupplier(SSSupplier iSupplier) {
        return this.iSupplierNr != null && this.iSupplierNr.equals(iSupplier.getNumber());
    }
}

