/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSPurchaseOrderRow
implements Serializable {
    private static final long serialVersionUID = 4891634413753480921L;
    private String iProductNr;
    private String iDescription;
    private String iSupplierArticleNr;
    private BigDecimal iUnitprice;
    private Integer iQuantity;
    private SSUnit iUnit;
    private Integer iAccountNr;
    private transient SSProduct iProduct;

    public SSPurchaseOrderRow() {
    }

    public SSPurchaseOrderRow(SSPurchaseOrderRow iPurchaseOrderRow) {
        this.iProductNr = iPurchaseOrderRow.iProductNr;
        this.iDescription = iPurchaseOrderRow.iDescription;
        this.iSupplierArticleNr = iPurchaseOrderRow.iSupplierArticleNr;
        this.iUnitprice = iPurchaseOrderRow.iUnitprice;
        this.iQuantity = iPurchaseOrderRow.iQuantity;
        this.iUnit = iPurchaseOrderRow.iUnit;
        this.iProduct = iPurchaseOrderRow.iProduct;
        this.iAccountNr = iPurchaseOrderRow.iAccountNr;
    }

    public String getProductNr() {
        return this.iProductNr;
    }

    public void setProductNr(String iProductNr) {
        this.iProductNr = iProductNr;
        this.iProduct = null;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public String getDescription(Locale iLocale) {
        String iProductDescription;
        if (this.getProduct() != null && (iProductDescription = this.iProduct.getDescription(iLocale)) != null) {
            return iProductDescription;
        }
        return this.iDescription;
    }

    public String getSupplierArticleNr() {
        return this.iSupplierArticleNr;
    }

    public void setSupplierArticleNr(String iSupplierArticleNr) {
        this.iSupplierArticleNr = iSupplierArticleNr;
    }

    public BigDecimal getUnitPrice() {
        return this.iUnitprice;
    }

    public void setUnitPrice(BigDecimal iUnitprice) {
        this.iUnitprice = iUnitprice;
    }

    public Integer getQuantity() {
        return this.iQuantity;
    }

    public void setQuantity(Integer iQuantity) {
        this.iQuantity = iQuantity;
    }

    public SSUnit getUnit() {
        return this.iUnit;
    }

    public void setUnit(SSUnit iUnit) {
        this.iUnit = iUnit;
    }

    public SSProduct getProduct() {
        return this.getProduct(SSDB.getInstance().getProducts());
    }

    public SSProduct getProduct(List<SSProduct> iProducts) {
        if (this.iProduct == null && this.iProductNr != null) {
            for (SSProduct iCurrent : iProducts) {
                if (!iCurrent.getNumber().equals(this.iProductNr)) continue;
                this.iProduct = iCurrent;
            }
        }
        return this.iProduct;
    }

    public void setProduct(SSProduct iProduct) {
        this.iProduct = iProduct;
        String string = this.iProductNr = iProduct == null ? null : iProduct.getNumber();
        if (iProduct != null) {
            this.iDescription = iProduct.getDescription();
            this.iUnitprice = iProduct.getPurchasePrice();
            this.iUnit = iProduct.getUnit();
            this.iSupplierArticleNr = iProduct.getSupplierProductNr();
            this.iAccountNr = iProduct.getDefaultAccount(SSDefaultAccount.Purchases);
            this.iQuantity = 1;
        }
    }

    public Integer getAccountNr() {
        return this.iAccountNr;
    }

    public void setAccountNr(Integer iAccountNr) {
        this.iAccountNr = iAccountNr;
    }

    public boolean hasProduct(SSProduct iProduct) {
        return this.iProductNr != null && this.iProductNr.equals(iProduct.getNumber());
    }

    public BigDecimal getSum() {
        if (this.iUnitprice == null || this.iQuantity == null) {
            return null;
        }
        return this.iUnitprice.multiply(new BigDecimal(this.iQuantity));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSPurchaseOrderRow");
        sb.append("{iAccountNr=").append(this.iAccountNr);
        sb.append(", iDescription='").append(this.iDescription).append('\'');
        sb.append(", iProduct=").append(this.iProduct);
        sb.append(", iProductNr='").append(this.iProductNr).append('\'');
        sb.append(", iQuantity=").append(this.iQuantity);
        sb.append(", iSupplierArticleNr='").append(this.iSupplierArticleNr).append('\'');
        sb.append(", iUnit=").append(this.iUnit);
        sb.append(", iUnitprice=").append(this.iUnitprice);
        sb.append('}');
        return sb.toString();
    }
}

