/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSIndeliveryMath;
import se.swedsoft.bookkeeping.calc.math.SSInventoryMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSOrderMath;
import se.swedsoft.bookkeeping.calc.math.SSOutdeliveryMath;
import se.swedsoft.bookkeeping.calc.math.SSPurchaseOrderMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.calc.util.SSFilter;
import se.swedsoft.bookkeeping.calc.util.SSFilterFactory;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSIndelivery;
import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSStock {
    private Map<SSProduct, Integer> iQuantity = new HashMap<SSProduct, Integer>();
    private Map<SSProduct, Integer> iReserved = new HashMap<SSProduct, Integer>();
    private Map<SSProduct, Integer> iOrdered = new HashMap<SSProduct, Integer>();

    public SSStock(boolean update) {
        if (update) {
            this.update();
        }
    }

    public SSStock() {
        this(false);
    }

    public void update() {
        List<SSOrder> iOrders = SSDB.getInstance().getOrders();
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        List<SSPurchaseOrder> iPurchaseOrders = SSDB.getInstance().getPurchaseOrders();
        List<SSSupplierInvoice> iSupplierInvoices = SSDB.getInstance().getSupplierInvoices();
        List<SSSupplierCreditInvoice> iSupplierCreditInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        List<SSInventory> iInventories = SSDB.getInstance().getInventories();
        List<SSIndelivery> iIndeliveries = SSDB.getInstance().getIndeliveries();
        List<SSOutdelivery> iOutdeliveries = SSDB.getInstance().getOutdeliveries();
        iOrders = SSOrderMath.getOrdersWithoutInvoice(iOrders);
        iPurchaseOrders = SSPurchaseOrderMath.getOrdersWithoutInvoice(iPurchaseOrders);
        iInvoices = SSFilterFactory.doFilter(iInvoices, new SSFilter<SSInvoice>(){

            @Override
            public boolean applyFilter(SSInvoice iInvoice) {
                return iInvoice.isStockInfluencing();
            }
        });
        iCreditInvoices = SSFilterFactory.doFilter(iCreditInvoices, new SSFilter<SSCreditInvoice>(){

            @Override
            public boolean applyFilter(SSCreditInvoice iCreditInvoice) {
                return iCreditInvoice.isStockInfluencing();
            }
        });
        iPurchaseOrders = SSFilterFactory.doFilter(iPurchaseOrders, new SSFilter<SSPurchaseOrder>(){

            @Override
            public boolean applyFilter(SSPurchaseOrder iPurchaseOrder) {
                return iPurchaseOrder.isStockInfluencing();
            }
        });
        iSupplierInvoices = SSFilterFactory.doFilter(iSupplierInvoices, new SSFilter<SSSupplierInvoice>(){

            @Override
            public boolean applyFilter(SSSupplierInvoice iSupplierInvoice) {
                return iSupplierInvoice.isStockInfluencing();
            }
        });
        iSupplierCreditInvoices = SSFilterFactory.doFilter(iSupplierCreditInvoices, new SSFilter<SSSupplierCreditInvoice>(){

            @Override
            public boolean applyFilter(SSSupplierCreditInvoice iSupplierCreditInvoice) {
                return iSupplierCreditInvoice.isStockInfluencing();
            }
        });
        this.calculate(iOrders, iInvoices, iCreditInvoices, iPurchaseOrders, iSupplierInvoices, iSupplierCreditInvoices, iInventories, iIndeliveries, iOutdeliveries);
    }

    public void update(final Date iDate) {
        List<SSOrder> iOrders = SSDB.getInstance().getOrders();
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        List<SSPurchaseOrder> iPurchaseOrders = SSDB.getInstance().getPurchaseOrders();
        List<SSSupplierInvoice> iSupplierInvoices = SSDB.getInstance().getSupplierInvoices();
        List<SSSupplierCreditInvoice> iSupplierCreditInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        List<SSInventory> iInventories = SSDB.getInstance().getInventories();
        List<SSIndelivery> iIndeliveries = SSDB.getInstance().getIndeliveries();
        List<SSOutdelivery> iOutdeliveries = SSDB.getInstance().getOutdeliveries();
        iOrders = SSOrderMath.getOrdersWithoutInvoice(iOrders);
        iPurchaseOrders = SSPurchaseOrderMath.getOrdersWithoutInvoice(iPurchaseOrders);
        iOrders = SSFilterFactory.doFilter(iOrders, new SSFilter<SSOrder>(){

            @Override
            public boolean applyFilter(SSOrder iOrder) {
                return SSOrderMath.inPeriod(iOrder, iDate);
            }
        });
        iInvoices = SSFilterFactory.doFilter(iInvoices, new SSFilter<SSInvoice>(){

            @Override
            public boolean applyFilter(SSInvoice iInvoice) {
                return iInvoice.isStockInfluencing() && SSInvoiceMath.inPeriod(iInvoice, iDate);
            }
        });
        iCreditInvoices = SSFilterFactory.doFilter(iCreditInvoices, new SSFilter<SSCreditInvoice>(){

            @Override
            public boolean applyFilter(SSCreditInvoice iCreditInvoice) {
                return iCreditInvoice.isStockInfluencing() && SSInvoiceMath.inPeriod(iCreditInvoice, iDate);
            }
        });
        iPurchaseOrders = SSFilterFactory.doFilter(iPurchaseOrders, new SSFilter<SSPurchaseOrder>(){

            @Override
            public boolean applyFilter(SSPurchaseOrder iPurchaseOrder) {
                return iPurchaseOrder.isStockInfluencing() && SSPurchaseOrderMath.inPeriod(iPurchaseOrder, iDate);
            }
        });
        iSupplierInvoices = SSFilterFactory.doFilter(iSupplierInvoices, new SSFilter<SSSupplierInvoice>(){

            @Override
            public boolean applyFilter(SSSupplierInvoice iSupplierInvoice) {
                return iSupplierInvoice.isStockInfluencing() && SSSupplierInvoiceMath.inPeriod(iSupplierInvoice, iDate);
            }
        });
        iSupplierCreditInvoices = SSFilterFactory.doFilter(iSupplierCreditInvoices, new SSFilter<SSSupplierCreditInvoice>(){

            @Override
            public boolean applyFilter(SSSupplierCreditInvoice iSupplierCreditInvoice) {
                return iSupplierCreditInvoice.isStockInfluencing() && SSSupplierInvoiceMath.inPeriod(iSupplierCreditInvoice, iDate);
            }
        });
        iInventories = SSFilterFactory.doFilter(iInventories, new SSFilter<SSInventory>(){

            @Override
            public boolean applyFilter(SSInventory iInventory) {
                return SSInventoryMath.inPeriod(iInventory, iDate);
            }
        });
        iIndeliveries = SSFilterFactory.doFilter(iIndeliveries, new SSFilter<SSIndelivery>(){

            @Override
            public boolean applyFilter(SSIndelivery iIndelivery) {
                return SSIndeliveryMath.inPeriod(iIndelivery, iDate);
            }
        });
        iOutdeliveries = SSFilterFactory.doFilter(iOutdeliveries, new SSFilter<SSOutdelivery>(){

            @Override
            public boolean applyFilter(SSOutdelivery iOutdelivery) {
                return SSOutdeliveryMath.inPeriod(iOutdelivery, iDate);
            }
        });
        this.calculate(iOrders, iInvoices, iCreditInvoices, iPurchaseOrders, iSupplierInvoices, iSupplierCreditInvoices, iInventories, iIndeliveries, iOutdeliveries);
    }

    public void update(final Date iFrom, final Date iTo) {
        List<SSOrder> iOrders = SSDB.getInstance().getOrders();
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        List<SSPurchaseOrder> iPurchaseOrders = SSDB.getInstance().getPurchaseOrders();
        List<SSSupplierInvoice> iSupplierInvoices = SSDB.getInstance().getSupplierInvoices();
        List<SSSupplierCreditInvoice> iSupplierCreditInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        List<SSInventory> iInventories = SSDB.getInstance().getInventories();
        List<SSIndelivery> iIndeliveries = SSDB.getInstance().getIndeliveries();
        List<SSOutdelivery> iOutdeliveries = SSDB.getInstance().getOutdeliveries();
        iOrders = SSOrderMath.getOrdersWithoutInvoice(iOrders);
        iPurchaseOrders = SSPurchaseOrderMath.getOrdersWithoutInvoice(iPurchaseOrders);
        iOrders = SSFilterFactory.doFilter(iOrders, new SSFilter<SSOrder>(){

            @Override
            public boolean applyFilter(SSOrder iOrder) {
                return SSOrderMath.inPeriod(iOrder, iFrom, iTo);
            }
        });
        iInvoices = SSFilterFactory.doFilter(iInvoices, new SSFilter<SSInvoice>(){

            @Override
            public boolean applyFilter(SSInvoice iInvoice) {
                return iInvoice.isStockInfluencing() && SSInvoiceMath.inPeriod(iInvoice, iFrom, iTo);
            }
        });
        iCreditInvoices = SSFilterFactory.doFilter(iCreditInvoices, new SSFilter<SSCreditInvoice>(){

            @Override
            public boolean applyFilter(SSCreditInvoice iCreditInvoice) {
                return iCreditInvoice.isStockInfluencing() && SSInvoiceMath.inPeriod(iCreditInvoice, iFrom, iTo);
            }
        });
        iPurchaseOrders = SSFilterFactory.doFilter(iPurchaseOrders, new SSFilter<SSPurchaseOrder>(){

            @Override
            public boolean applyFilter(SSPurchaseOrder iPurchaseOrder) {
                return iPurchaseOrder.isStockInfluencing() && SSPurchaseOrderMath.inPeriod(iPurchaseOrder, iFrom, iTo);
            }
        });
        iSupplierInvoices = SSFilterFactory.doFilter(iSupplierInvoices, new SSFilter<SSSupplierInvoice>(){

            @Override
            public boolean applyFilter(SSSupplierInvoice iSupplierInvoice) {
                return iSupplierInvoice.isStockInfluencing() && SSSupplierInvoiceMath.inPeriod(iSupplierInvoice, iFrom, iTo);
            }
        });
        iSupplierCreditInvoices = SSFilterFactory.doFilter(iSupplierCreditInvoices, new SSFilter<SSSupplierCreditInvoice>(){

            @Override
            public boolean applyFilter(SSSupplierCreditInvoice iSupplierCreditInvoice) {
                return iSupplierCreditInvoice.isStockInfluencing() && SSSupplierInvoiceMath.inPeriod(iSupplierCreditInvoice, iFrom, iTo);
            }
        });
        iInventories = SSFilterFactory.doFilter(iInventories, new SSFilter<SSInventory>(){

            @Override
            public boolean applyFilter(SSInventory iInventory) {
                return SSInventoryMath.inPeriod(iInventory, iFrom, iTo);
            }
        });
        iIndeliveries = SSFilterFactory.doFilter(iIndeliveries, new SSFilter<SSIndelivery>(){

            @Override
            public boolean applyFilter(SSIndelivery iIndelivery) {
                return SSIndeliveryMath.inPeriod(iIndelivery, iFrom, iTo);
            }
        });
        iOutdeliveries = SSFilterFactory.doFilter(iOutdeliveries, new SSFilter<SSOutdelivery>(){

            @Override
            public boolean applyFilter(SSOutdelivery iOutdelivery) {
                return SSOutdeliveryMath.inPeriod(iOutdelivery, iFrom, iTo);
            }
        });
        this.calculate(iOrders, iInvoices, iCreditInvoices, iPurchaseOrders, iSupplierInvoices, iSupplierCreditInvoices, iInventories, iIndeliveries, iOutdeliveries);
    }

    private void calculate(List<SSOrder> iOrders, List<SSInvoice> iInvoices, List<SSCreditInvoice> iCreditInvoices, List<SSPurchaseOrder> iPurchaseOrders, List<SSSupplierInvoice> iSupplierInvoices, List<SSSupplierCreditInvoice> iSupplierCreditInvoices, List<SSInventory> iInventories, List<SSIndelivery> iIndeliveries, List<SSOutdelivery> iOutdeliveries) {
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>(SSDB.getInstance().getProducts());
        Map<String, Integer> iOrderCount = SSOrderMath.getStockInfluencing(iOrders);
        Map<String, Integer> iInvoiceCount = SSInvoiceMath.getStockInfluencing(iInvoices);
        Map<String, Integer> iCreditInvoiceCount = SSCreditInvoiceMath.getStockInfluencing(iCreditInvoices);
        Map<String, Integer> iPurchaseOrderCount = SSPurchaseOrderMath.getStockInfluencing(iPurchaseOrders);
        Map<String, Integer> iSupplierInvoiceCount = SSSupplierInvoiceMath.getStockInfluencing(iSupplierInvoices);
        Map<String, Integer> iSupplierCreditInvoiceCount = SSSupplierCreditInvoiceMath.getStockInfluencing(iSupplierCreditInvoices);
        Map<String, Integer> iInventoryCount = SSInventoryMath.getStockInfluencing(iInventories);
        Map<String, Integer> iIndeliveryCount = SSIndeliveryMath.getStockInfluencing(iIndeliveries);
        Map<String, Integer> iOutdeliveryCount = SSOutdeliveryMath.getStockInfluencing(iOutdeliveries);
        for (SSProduct iProduct : iProducts) {
            if (!iProduct.isStockProduct()) continue;
            Integer iReserved = 0;
            iReserved = iOrderCount.get(iProduct.getNumber()) == null ? iReserved : iReserved + iOrderCount.get(iProduct.getNumber());
            Integer iQuantity = 0;
            iQuantity = iInvoiceCount.get(iProduct.getNumber()) == null ? iQuantity : iQuantity - iInvoiceCount.get(iProduct.getNumber());
            iQuantity = iCreditInvoiceCount.get(iProduct.getNumber()) == null ? iQuantity : iQuantity + iCreditInvoiceCount.get(iProduct.getNumber());
            Integer iOrdered = 0;
            iOrdered = iPurchaseOrderCount.get(iProduct.getNumber()) == null ? iOrdered : iOrdered + iPurchaseOrderCount.get(iProduct.getNumber());
            iQuantity = iSupplierInvoiceCount.get(iProduct.getNumber()) == null ? iQuantity : iQuantity + iSupplierInvoiceCount.get(iProduct.getNumber());
            iQuantity = iSupplierCreditInvoiceCount.get(iProduct.getNumber()) == null ? iQuantity : iQuantity - iSupplierCreditInvoiceCount.get(iProduct.getNumber());
            iQuantity = iInventoryCount.get(iProduct.getNumber()) == null ? iQuantity : iQuantity + iInventoryCount.get(iProduct.getNumber());
            iQuantity = iIndeliveryCount.get(iProduct.getNumber()) == null ? iQuantity : iQuantity + iIndeliveryCount.get(iProduct.getNumber());
            iQuantity = iOutdeliveryCount.get(iProduct.getNumber()) == null ? iQuantity : iQuantity - iOutdeliveryCount.get(iProduct.getNumber());
            this.iQuantity.put(iProduct, iQuantity);
            this.iOrdered.put(iProduct, iOrdered);
            this.iReserved.put(iProduct, iReserved);
        }
        iProducts = null;
        iOrderCount = null;
        iInvoiceCount = null;
        iCreditInvoiceCount = null;
        iPurchaseOrderCount = null;
        iSupplierInvoiceCount = null;
        iSupplierCreditInvoiceCount = null;
        iInventoryCount = null;
        iIndeliveryCount = null;
        iOutdeliveryCount = null;
    }

    public Integer getQuantity(SSProduct iProduct) {
        return this.iQuantity.containsKey(iProduct) ? this.iQuantity.get(iProduct) : 0;
    }

    public Integer getOrdered(SSProduct iProduct) {
        return this.iOrdered.containsKey(iProduct) ? this.iOrdered.get(iProduct) : 0;
    }

    public Integer getReserved(SSProduct iProduct) {
        return this.iReserved.containsKey(iProduct) ? this.iReserved.get(iProduct) : 0;
    }

    public Integer getAvaiable(SSProduct iProduct) {
        return this.getQuantity(iProduct) - this.getReserved(iProduct);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSStock");
        sb.append("{iOrdered=").append(this.iOrdered);
        sb.append(", iQuantity=").append(this.iQuantity);
        sb.append(", iReserved=").append(this.iReserved);
        sb.append('}');
        return sb.toString();
    }
}

