/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSSupplier
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private String iNumber;
    private String iName;
    private String iPhone;
    private String iPhone2;
    private String iTeleFax;
    private String iEmail;
    private String iHomepage;
    private String iRegistrationNumber;
    private String iYourContact;
    private String iOurContact;
    private String iOurCustomerNr;
    private String iBankAccountNumber;
    private String iPlusAccountNumber;
    private Integer iOutpaymentNumber;
    private SSCurrency iCurrency;
    private SSPaymentTerm iPaymentTerm;
    private SSDeliveryTerm iDeliveryTerm;
    private SSDeliveryWay iDeliveryWay;
    private SSAddress iAddress;
    private String iComment;

    public SSSupplier() {
        this.iAddress = new SSAddress();
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.iOurContact = iCompany.getContactPerson();
            this.iCurrency = iCompany.getCurrency();
            this.iPaymentTerm = iCompany.getPaymentTerm();
            this.iDeliveryTerm = iCompany.getDeliveryTerm();
            this.iDeliveryWay = iCompany.getDeliveryWay();
        }
    }

    public SSSupplier(SSSupplier iSupplier) {
        this.iNumber = iSupplier.iNumber;
        this.iName = iSupplier.iName;
        this.iPhone = iSupplier.iPhone;
        this.iPhone2 = iSupplier.iPhone2;
        this.iTeleFax = iSupplier.iTeleFax;
        this.iEmail = iSupplier.iEmail;
        this.iHomepage = iSupplier.iHomepage;
        this.iRegistrationNumber = iSupplier.iRegistrationNumber;
        this.iYourContact = iSupplier.iYourContact;
        this.iOurContact = iSupplier.iOurContact;
        this.iOurCustomerNr = iSupplier.iOurCustomerNr;
        this.iBankAccountNumber = iSupplier.iBankAccountNumber;
        this.iPlusAccountNumber = iSupplier.iPlusAccountNumber;
        this.iCurrency = iSupplier.iCurrency;
        this.iPaymentTerm = iSupplier.iPaymentTerm;
        this.iDeliveryTerm = iSupplier.iDeliveryTerm;
        this.iDeliveryWay = iSupplier.iDeliveryWay;
        this.iAddress = new SSAddress(iSupplier.iAddress);
    }

    public String getNumber() {
        return this.iNumber;
    }

    public void setNumber(String iSupplierNr) {
        this.iNumber = iSupplierNr;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String iName) {
        this.iName = iName;
    }

    public String getPhone1() {
        return this.iPhone;
    }

    public void setPhone1(String iPhone) {
        this.iPhone = iPhone;
    }

    public String getPhone2() {
        return this.iPhone2;
    }

    public void setPhone2(String iPhone2) {
        this.iPhone2 = iPhone2;
    }

    public String getTelefax() {
        return this.iTeleFax;
    }

    public void setTelefax(String iTelefax) {
        this.iTeleFax = iTelefax;
    }

    public String getEMail() {
        return this.iEmail;
    }

    public void setEMail(String iEmail) {
        this.iEmail = iEmail;
    }

    public String getHomepage() {
        return this.iHomepage;
    }

    public void setHomepage(String iHomepage) {
        this.iHomepage = iHomepage;
    }

    public String getRegistrationNumber() {
        return this.iRegistrationNumber;
    }

    public void setRegistrationNumber(String iRegistrationNumber) {
        this.iRegistrationNumber = iRegistrationNumber;
    }

    public String getYourContact() {
        return this.iYourContact;
    }

    public void setYourContact(String iYourContact) {
        this.iYourContact = iYourContact;
    }

    public String getOurContact() {
        return this.iOurContact;
    }

    public void setOurContact(String iOurContact) {
        this.iOurContact = iOurContact;
    }

    public String getBankgiro() {
        return this.iBankAccountNumber;
    }

    public void setBankGiro(String iBankAccountNumber) {
        this.iBankAccountNumber = iBankAccountNumber;
    }

    public String getPlusgiro() {
        return this.iPlusAccountNumber;
    }

    public void setPlusGiro(String iPlusAccountNumber) {
        this.iPlusAccountNumber = iPlusAccountNumber;
    }

    public Integer getOutpaymentNumber() {
        return this.iOutpaymentNumber;
    }

    public void setOutpaymentNumber(Integer iOutpaymentNumber) {
        this.iOutpaymentNumber = iOutpaymentNumber;
    }

    public SSCurrency getCurrency() {
        return SSDB.getInstance().getCurrency(this.iCurrency);
    }

    public void setCurrency(SSCurrency iCurrency) {
        this.iCurrency = iCurrency;
    }

    public SSPaymentTerm getPaymentTerm() {
        return this.iPaymentTerm;
    }

    public void setPaymentTerm(SSPaymentTerm iPaymentTerm) {
        this.iPaymentTerm = iPaymentTerm;
    }

    public SSDeliveryTerm getDeliveryTerm() {
        return this.iDeliveryTerm;
    }

    public void setDeliveryTerm(SSDeliveryTerm iDeliveryTerm) {
        this.iDeliveryTerm = iDeliveryTerm;
    }

    public SSDeliveryWay getDeliveryWay() {
        return this.iDeliveryWay;
    }

    public void setDeliveryWay(SSDeliveryWay iDeliveryWay) {
        this.iDeliveryWay = iDeliveryWay;
    }

    public SSAddress getAddress() {
        return this.iAddress;
    }

    public void setAddress(SSAddress iAddress) {
        this.iAddress = iAddress;
    }

    public String getOurCustomerNr() {
        return this.iOurCustomerNr;
    }

    public void setOurCustomerNr(String iOurCustomerNr) {
        this.iOurCustomerNr = iOurCustomerNr;
    }

    public String getComment() {
        return this.iComment;
    }

    public void setComment(String iComment) {
        this.iComment = iComment;
    }

    public boolean equals(Object obj) {
        if (this.iNumber == null) {
            return super.equals(obj);
        }
        if (obj instanceof SSSupplier) {
            SSSupplier iSupplier = (SSSupplier)obj;
            return this.iNumber.equals(iSupplier.iNumber);
        }
        return false;
    }

    public int hashCode() {
        if (this.iNumber != null) {
            return this.iNumber.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public String toRenderString() {
        return this.iNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(", ");
        sb.append(this.iName);
        return sb.toString();
    }

    public BigDecimal getSupplierRevenueForMonth(SSMonth iMonth) {
        Double iSupplierInvoiceSum = 0.0;
        for (SSSupplierInvoice iSupplierInvoice : SSDB.getInstance().getSupplierInvoices()) {
            if (!iMonth.isDateInMonth(iSupplierInvoice.getDate()) || iSupplierInvoice.getSupplierNr() == null || !iSupplierInvoice.getSupplierNr().equals(this.iNumber)) continue;
            iSupplierInvoiceSum = iSupplierInvoiceSum + SSSupplierInvoiceMath.getNetSum(iSupplierInvoice).doubleValue() * iSupplierInvoice.getCurrencyRate().doubleValue();
        }
        Double iSupplierCreditInvoiceSum = 0.0;
        for (SSSupplierCreditInvoice iSupplierCreditInvoice : SSDB.getInstance().getSupplierCreditInvoices()) {
            if (!iMonth.isDateInMonth(iSupplierCreditInvoice.getDate()) || iSupplierCreditInvoice.getSupplierNr() == null || !iSupplierCreditInvoice.getSupplierNr().equals(this.iNumber)) continue;
            iSupplierCreditInvoiceSum = iSupplierCreditInvoiceSum + SSSupplierInvoiceMath.getNetSum(iSupplierCreditInvoice).doubleValue() * iSupplierCreditInvoice.getCurrencyRate().doubleValue();
        }
        return new BigDecimal(iSupplierInvoiceSum - iSupplierCreditInvoiceSum);
    }
}

