/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSSupplierCreditInvoice
extends SSSupplierInvoice {
    static final long serialVersionUID = 1L;
    protected Integer iCreditingNr;
    protected transient SSSupplierInvoice iCrediting;

    public SSSupplierCreditInvoice() {
    }

    public SSSupplierCreditInvoice(SSSupplierCreditInvoice iSSSupplierCreditInvoice) {
        this.copyFrom(iSSSupplierCreditInvoice);
    }

    public SSSupplierCreditInvoice(SSSupplierInvoice iSupplierInvoice) {
        super(iSupplierInvoice);
        this.iDate = new Date();
        this.iCreditingNr = iSupplierInvoice.getNumber();
        this.iCrediting = iSupplierInvoice;
    }

    @Override
    public void doAutoIncrecement() {
        List<SSSupplierCreditInvoice> iInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        int iNumber = SSDB.getInstance().getAutoIncrement().getNumber("suppliercreditinvoice");
        for (SSSupplierCreditInvoice iSupplierInvoice : iInvoices) {
            if (iSupplierInvoice.getNumber() <= iNumber) continue;
            iNumber = iSupplierInvoice.getNumber();
        }
        this.iNumber = iNumber + 1;
    }

    public void copyFrom(SSSupplierCreditInvoice iSSSupplierCreditInvoice) {
        super.copyFrom(iSSSupplierCreditInvoice);
        this.iCreditingNr = iSSSupplierCreditInvoice.iCreditingNr;
        this.iCrediting = iSSSupplierCreditInvoice.iCrediting;
    }

    public Integer getCreditingNr() {
        return this.iCreditingNr;
    }

    public void setCreditingNr(Integer iCreditingNr) {
        this.iCreditingNr = iCreditingNr;
    }

    public SSSupplierInvoice getCrediting() {
        return this.getCrediting(SSDB.getInstance().getSupplierInvoices());
    }

    public SSSupplierInvoice getCrediting(List<SSSupplierInvoice> iSupplierInvoices) {
        if (this.iCrediting == null) {
            for (SSSupplierInvoice iCurrent : iSupplierInvoices) {
                if (!iCurrent.getNumber().equals(this.iCreditingNr)) continue;
                this.iCrediting = iCurrent;
            }
        }
        return this.iCrediting;
    }

    public void setCrediting(SSSupplierInvoice iCrediting) {
        this.iCrediting = iCrediting;
        this.iCreditingNr = iCrediting == null ? null : iCrediting.getNumber();
    }

    public boolean isCrediting(SSSupplierInvoice iCrediting) {
        boolean answer = false;
        if (iCrediting != null) {
            answer = iCrediting.getNumber().equals(this.iCreditingNr);
        }
        return answer;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.iNumber == null) {
            return false;
        }
        if (obj instanceof SSSupplierCreditInvoice) {
            SSSupplierCreditInvoice iSale = (SSSupplierCreditInvoice)obj;
            return this.iNumber.equals(iSale.iNumber);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(", ");
        sb.append(this.iDate);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.iNumber;
    }

    @Override
    public String toRenderString() {
        return this.iNumber == null ? "" : this.iNumber.toString();
    }

    @Override
    public SSVoucher generateVoucher() {
        this.iVoucher = new SSVoucher();
        String iDescription = SSBundle.getBundle().getString("suppliercreditinvoiceframe.voucherdescription");
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSAccountPlan iAccountPlan = SSDB.getInstance().getCurrentAccountPlan();
        this.iVoucher = new SSVoucher();
        this.iVoucher.setDate(new Date());
        this.iVoucher.setNumber(0);
        this.iVoucher.setDescription(String.format(iDescription, this.iNumber));
        BigDecimal iTotalSum = SSSupplierInvoiceMath.getTotalSum(this);
        BigDecimal iCorrectionSum = SSVoucherMath.getCreditMinusDebetSum(this.iCorrection);
        iTotalSum = iTotalSum.subtract(iCorrectionSum);
        this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.SupplierDebt), iTotalSum, null);
        this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Rounding), this.iRoundingSum.negate());
        this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.IncommingTax), null, this.iTaxSum);
        for (SSVoucherRow sSVoucherRow : this.iCorrection.getRows()) {
            this.iVoucher.addVoucherRow(new SSVoucherRow(sSVoucherRow));
        }
        for (SSSupplierInvoiceRow sSSupplierInvoiceRow : this.iRows) {
            SSVoucherRow iVoucherRow = new SSVoucherRow();
            iVoucherRow.setCredit(sSSupplierInvoiceRow.getSum());
            iVoucherRow.setAccount(sSSupplierInvoiceRow.getAccount(iAccountPlan.getAccounts()));
            iVoucherRow.setProject(sSSupplierInvoiceRow.getProject(SSDB.getInstance().getProjects()));
            iVoucherRow.setResultUnit(sSSupplierInvoiceRow.getResultUnit(SSDB.getInstance().getResultUnits()));
            if (iVoucherRow.getAccountNr() == null) continue;
            this.iVoucher.addVoucherRow(iVoucherRow);
        }
        for (SSVoucherRow sSVoucherRow : this.iVoucher.getRows()) {
            if (sSVoucherRow.isDebet()) {
                if (sSVoucherRow.getDebet().compareTo(new BigDecimal(0)) != -1) continue;
                sSVoucherRow.setCredit(sSVoucherRow.getDebet().negate());
                sSVoucherRow.setDebet(null);
                continue;
            }
            if (sSVoucherRow.getCredit().compareTo(new BigDecimal(0)) != -1) continue;
            sSVoucherRow.setDebet(sSVoucherRow.getCredit().negate());
            sSVoucherRow.setCredit(null);
        }
        if (this.iCurrencyRate != null) {
            SSVoucherMath.multiplyRowsBy(this.iVoucher, this.iCurrencyRate);
        }
        this.iVoucher = SSVoucherMath.compress(this.iVoucher);
        return this.iVoucher;
    }
}

