/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSPurchaseOrderRow;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSSupplierInvoice
implements SSTableSearchable,
Serializable {
    static final long serialVersionUID = 1L;
    protected Integer iNumber;
    protected Date iDate;
    protected Date iDueDate;
    protected SSPaymentTerm iPaymentTerm;
    private String iSupplierNr;
    private String iSupplierName;
    private String iReferencenumber;
    protected SSCurrency iCurrency;
    protected BigDecimal iCurrencyRate;
    protected BigDecimal iTaxSum;
    protected BigDecimal iRoundingSum;
    protected SSVoucher iVoucher;
    protected SSVoucher iCorrection;
    protected boolean iEntered;
    private boolean iStockInfluencing;
    private boolean iBGCEntered;
    protected List<SSSupplierInvoiceRow> iRows;
    protected Map<SSDefaultAccount, Integer> iDefaultAccounts;
    protected transient SSSupplier iSupplier;

    public SSSupplierInvoice() {
        this.iRows = new LinkedList<SSSupplierInvoiceRow>();
        this.iDate = this.getLastDate();
        this.iDueDate = this.getLastDate();
        this.iCurrencyRate = new BigDecimal(1);
        this.iVoucher = new SSVoucher();
        this.iCorrection = new SSVoucher();
        this.iTaxSum = new BigDecimal(0);
        this.iRoundingSum = new BigDecimal(0);
        this.iEntered = false;
        this.iStockInfluencing = true;
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iDefaultAccounts.putAll(SSDB.getInstance().getCurrentCompany().getDefaultAccounts());
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.iCurrency = iCompany.getCurrency();
        }
    }

    public SSSupplierInvoice(SSSupplierInvoice iSupplierInvoice) {
        this.copyFrom(iSupplierInvoice);
    }

    public SSSupplierInvoice(SSPurchaseOrder iPurchaseOrder) {
        this.iDate = this.getLastDate();
        this.iSupplier = iPurchaseOrder.iSupplier;
        this.iNumber = iPurchaseOrder.iNumber;
        this.iSupplier = iPurchaseOrder.iSupplier;
        this.iSupplierNr = iPurchaseOrder.iSupplierNr;
        this.iSupplierName = iPurchaseOrder.iSupplierName;
        this.iCurrency = iPurchaseOrder.iCurrency;
        this.iCurrencyRate = iPurchaseOrder.getCurrencyRate();
        this.iVoucher = new SSVoucher();
        this.iCorrection = new SSVoucher();
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iRows = new LinkedList<SSSupplierInvoiceRow>();
        this.iRoundingSum = new BigDecimal(0);
        for (SSDefaultAccount iDefaultAccount : iPurchaseOrder.getDefaultAccounts().keySet()) {
            this.iDefaultAccounts.put(iDefaultAccount, iPurchaseOrder.getDefaultAccounts().get(iDefaultAccount));
        }
        this.generateVoucher();
    }

    public void copyFrom(SSSupplierInvoice iSupplierInvoice) {
        this.iNumber = iSupplierInvoice.iNumber;
        this.iDate = iSupplierInvoice.iDate;
        this.iPaymentTerm = iSupplierInvoice.iPaymentTerm;
        this.iDueDate = iSupplierInvoice.iDueDate;
        this.iSupplierNr = iSupplierInvoice.iSupplierNr;
        this.iSupplierName = iSupplierInvoice.iSupplierName;
        this.iReferencenumber = iSupplierInvoice.iReferencenumber;
        this.iCurrency = iSupplierInvoice.iCurrency;
        this.iCurrencyRate = iSupplierInvoice.iCurrencyRate;
        this.iTaxSum = iSupplierInvoice.iTaxSum;
        this.iRoundingSum = iSupplierInvoice.iRoundingSum;
        this.iStockInfluencing = iSupplierInvoice.iStockInfluencing;
        this.iEntered = iSupplierInvoice.iEntered;
        this.iBGCEntered = iSupplierInvoice.iBGCEntered;
        this.iVoucher = new SSVoucher(iSupplierInvoice.iVoucher);
        this.iCorrection = new SSVoucher(iSupplierInvoice.iCorrection);
        this.iSupplier = iSupplierInvoice.iSupplier;
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        for (SSDefaultAccount iDefaultAccount : iSupplierInvoice.getDefaultAccounts().keySet()) {
            this.iDefaultAccounts.put(iDefaultAccount, iSupplierInvoice.getDefaultAccounts().get(iDefaultAccount));
        }
        this.iRows = new LinkedList<SSSupplierInvoiceRow>();
        for (SSSupplierInvoiceRow iRow : iSupplierInvoice.iRows) {
            this.iRows.add(new SSSupplierInvoiceRow(iRow));
        }
    }

    public void doAutoIncrecement() {
        List<SSSupplierInvoice> iInvoices = SSDB.getInstance().getSupplierInvoices();
        int iMax = SSDB.getInstance().getAutoIncrement().getNumber("supplierinvoice");
        for (SSSupplierInvoice iSupplierInvoice : iInvoices) {
            if (iSupplierInvoice.iNumber <= iMax) continue;
            iMax = iSupplierInvoice.iNumber;
        }
        this.iNumber = iMax + 1;
    }

    public Date getLastDate() {
        List<SSSupplierInvoice> iSupplierInvoices = SSDB.getInstance().getSupplierInvoices();
        Date iMax = null;
        if (!iSupplierInvoices.isEmpty()) {
            iMax = iSupplierInvoices.get((int)0).iDate;
            for (SSSupplierInvoice iInvoice : iSupplierInvoices) {
                if (!iInvoice.iDate.after(iMax)) continue;
                iMax = iInvoice.iDate;
            }
        }
        return iMax;
    }

    public Integer getNumber() {
        return this.iNumber;
    }

    public void setNumber(Integer iNumber) {
        this.iNumber = iNumber;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public Date getDueDate() {
        return this.iDueDate;
    }

    public void setDueDate(Date iDueDate) {
        this.iDueDate = iDueDate;
    }

    public void setDueDate() {
        Calendar iCalendar = Calendar.getInstance();
        if (this.iPaymentTerm != null) {
            if (this.iDate == null) {
                this.iDate = new Date();
            }
            iCalendar.setTime(this.iDate);
            iCalendar.add(5, this.iPaymentTerm.decodeValue());
            this.iDueDate = iCalendar.getTime();
        } else {
            this.iDueDate = this.iDate;
        }
    }

    public void setPaymentTerm(SSPaymentTerm iPaymentTerm) {
        this.iPaymentTerm = iPaymentTerm;
    }

    public String getSupplierNr() {
        return this.iSupplierNr;
    }

    public void setSupplierNr(String iSupplierNr) {
        this.iSupplierNr = iSupplierNr;
    }

    public String getSupplierName() {
        return this.iSupplierName;
    }

    public void setSupplierName(String iSupplierName) {
        this.iSupplierName = iSupplierName;
    }

    public String getReferencenumber() {
        return this.iReferencenumber;
    }

    public void setReferencenumber(String iReferencenumber) {
        this.iReferencenumber = iReferencenumber;
    }

    public SSCurrency getCurrency() {
        return this.iCurrency;
    }

    public void setCurrency(SSCurrency iCurrency) {
        this.iCurrency = iCurrency;
    }

    public BigDecimal getCurrencyRate() {
        return this.iCurrencyRate;
    }

    public void setCurrencyRate(BigDecimal iCurrencyRate) {
        this.iCurrencyRate = iCurrencyRate;
    }

    public BigDecimal getTaxSum() {
        if (this.iTaxSum == null) {
            this.iTaxSum = new BigDecimal(0);
        }
        return this.iTaxSum;
    }

    public void setTaxSum(BigDecimal iTaxSum) {
        this.iTaxSum = iTaxSum;
    }

    public BigDecimal getRoundingSum() {
        if (this.iRoundingSum == null) {
            this.iRoundingSum = new BigDecimal(0);
        }
        return this.iRoundingSum;
    }

    public void setRoundingSum(BigDecimal iRoundingSum) {
        this.iRoundingSum = iRoundingSum;
    }

    public SSSupplier getSupplier(List<SSSupplier> iSuppliers) {
        if (this.iSupplier == null) {
            for (SSSupplier iCurrent : iSuppliers) {
                if (!iCurrent.getNumber().equals(this.iSupplierNr)) continue;
                this.iSupplier = iCurrent;
            }
        }
        return this.iSupplier;
    }

    public SSSupplier getSupplier() {
        return this.iSupplier;
    }

    public void setSupplier(SSSupplier iSupplier) {
        this.iSupplier = iSupplier;
        String string = this.iSupplierNr = iSupplier == null ? null : iSupplier.getNumber();
        if (iSupplier != null) {
            this.iSupplierName = iSupplier.getName();
            this.iCurrency = iSupplier.getCurrency();
        }
    }

    public List<SSSupplierInvoiceRow> getRows() {
        return this.iRows;
    }

    public void setRows(List<SSSupplierInvoiceRow> iRows) {
        this.iRows = iRows;
    }

    public void append(SSSupplierInvoice iSupplierInvoice) {
        for (SSSupplierInvoiceRow iRow : iSupplierInvoice.iRows) {
            this.iRows.add(new SSSupplierInvoiceRow(iRow));
        }
    }

    public void append(SSPurchaseOrder iPurchaseOrder) {
        for (SSPurchaseOrderRow iRow : iPurchaseOrder.getRows()) {
            SSSupplierInvoiceRow iMatchingRow = SSSupplierInvoiceMath.getMatchingRow(this, iRow);
            if (iMatchingRow != null) {
                Integer iQuantity = iMatchingRow.getQuantity();
                if (iQuantity != null) {
                    iMatchingRow.setQuantity(iQuantity + iRow.getQuantity());
                    continue;
                }
                iMatchingRow.setQuantity(iRow.getQuantity());
                continue;
            }
            this.iRows.add(new SSSupplierInvoiceRow(iRow));
        }
    }

    public Map<SSDefaultAccount, Integer> getDefaultAccounts() {
        SSNewCompany iCompany;
        if (this.iDefaultAccounts == null && (iCompany = SSDB.getInstance().getCurrentCompany()) != null) {
            this.iDefaultAccounts = iCompany.getDefaultAccounts();
            Object var1_1 = null;
        }
        return this.iDefaultAccounts;
    }

    public SSAccount getDefaultAccount(SSAccountPlan iAccountPlan, SSDefaultAccount iDefaultAccount) {
        Integer iAccountNumber = this.iDefaultAccounts.get(iDefaultAccount);
        if (iAccountNumber == null) {
            return null;
        }
        return iAccountPlan.getAccount(iAccountNumber);
    }

    public Integer getDefaultAccount(SSDefaultAccount iDefaultAccount) {
        return this.iDefaultAccounts.get(iDefaultAccount);
    }

    public void setDefaultAccounts(Map<SSDefaultAccount, Integer> iDefaultAccounts) {
        this.iDefaultAccounts = iDefaultAccounts;
    }

    public SSVoucher getVoucher() {
        return this.iVoucher;
    }

    public void setVoucher(SSVoucher iVoucher) {
        this.iVoucher = iVoucher;
    }

    public SSVoucher getCorrection() {
        return this.iCorrection;
    }

    public void setCorrection(SSVoucher iCorrection) {
        this.iCorrection = iCorrection;
    }

    public boolean isEntered() {
        return this.iEntered;
    }

    public void setEntered(boolean iEntered) {
        this.iEntered = iEntered;
    }

    public void setEntered() {
        this.iEntered = true;
    }

    public boolean isBGCEntered() {
        return this.iBGCEntered;
    }

    public void setBGCEntered(boolean iBGCEntered) {
        this.iBGCEntered = iBGCEntered;
    }

    public void setBGCEntered() {
        this.iBGCEntered = true;
    }

    public boolean isStockInfluencing() {
        return this.iStockInfluencing;
    }

    public void setStockInfluencing(boolean iStockInfluencing) {
        this.iStockInfluencing = iStockInfluencing;
    }

    public boolean equals(Object obj) {
        if (this.iNumber == null) {
            return false;
        }
        if (obj instanceof SSSupplierInvoice) {
            SSSupplierInvoice iSale = (SSSupplierInvoice)obj;
            return this.iNumber.equals(iSale.iNumber);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(", ");
        sb.append(this.iDate);
        return sb.toString();
    }

    public int hashCode() {
        return this.iNumber;
    }

    @Override
    public String toRenderString() {
        return this.iNumber == null ? "" : this.iNumber.toString();
    }

    public boolean hasSupplier(SSSupplier iSupplier) {
        return this.iSupplierNr != null && this.iSupplierNr.equals(iSupplier.getNumber());
    }

    public boolean hasProduct(SSProduct iProduct) {
        for (SSSupplierInvoiceRow iRow : this.iRows) {
            if (!iRow.hasProduct(iProduct)) continue;
            return true;
        }
        return false;
    }

    public SSVoucher generateVoucher() {
        this.iVoucher = new SSVoucher();
        String iDescription = SSBundle.getBundle().getString("supplierinvoiceframe.voucherdescription");
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSAccountPlan iAccountPlan = SSDB.getInstance().getCurrentAccountPlan();
        this.iVoucher = new SSVoucher();
        this.iVoucher.setDate(new Date());
        this.iVoucher.setNumber(0);
        this.iVoucher.setDescription(String.format(iDescription, this.iNumber));
        BigDecimal iTotalSum = SSSupplierInvoiceMath.getTotalSum(this);
        BigDecimal iCorrectionSum = SSVoucherMath.getCreditMinusDebetSum(this.iCorrection);
        iTotalSum = iTotalSum.subtract(iCorrectionSum);
        this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.SupplierDebt), null, iTotalSum);
        this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Rounding), this.iRoundingSum);
        this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.IncommingTax), this.iTaxSum, null);
        for (SSVoucherRow sSVoucherRow : this.iCorrection.getRows()) {
            this.iVoucher.addVoucherRow(new SSVoucherRow(sSVoucherRow));
        }
        for (SSSupplierInvoiceRow sSSupplierInvoiceRow : this.iRows) {
            SSVoucherRow iVoucherRow = new SSVoucherRow();
            iVoucherRow.setDebet(sSSupplierInvoiceRow.getSum());
            iVoucherRow.setAccount(sSSupplierInvoiceRow.getAccount(iAccountPlan.getAccounts()));
            iVoucherRow.setProject(sSSupplierInvoiceRow.getProject(SSDB.getInstance().getProjects()));
            iVoucherRow.setResultUnit(sSSupplierInvoiceRow.getResultUnit(SSDB.getInstance().getResultUnits()));
            if (iVoucherRow.getAccountNr() == null) continue;
            this.iVoucher.addVoucherRow(iVoucherRow);
        }
        for (SSVoucherRow sSVoucherRow : this.iVoucher.getRows()) {
            if (sSVoucherRow.isDebet()) {
                if (sSVoucherRow.getDebet().compareTo(new BigDecimal(0)) != -1) continue;
                sSVoucherRow.setCredit(sSVoucherRow.getDebet().negate());
                sSVoucherRow.setDebet(null);
                continue;
            }
            if (sSVoucherRow.getCredit().compareTo(new BigDecimal(0)) != -1) continue;
            sSVoucherRow.setDebet(sSVoucherRow.getCredit().negate());
            sSVoucherRow.setCredit(null);
        }
        if (this.iCurrencyRate != null) {
            SSVoucherMath.multiplyRowsBy(this.iVoucher, this.iCurrencyRate);
        }
        this.iVoucher = SSVoucherMath.compress(this.iVoucher);
        return this.iVoucher;
    }
}

