/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSPurchaseOrderRow;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSSupplierInvoiceRow
implements SSTableSearchable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String iProductNr;
    private String iDescription;
    private BigDecimal iUnitprice;
    private Integer iQuantity;
    private SSUnit iUnit;
    private BigDecimal iUnitFreight;
    private Integer iAccountNr;
    private String iProjectNumber;
    private Integer iProjectNr;
    private String iResultUnitNumber;
    private Integer iResultUnitNr;
    private transient SSProduct iProduct;
    private transient SSAccount iAccount;
    private transient SSNewProject iProject;
    private transient SSNewResultUnit iResultUnit;

    public SSSupplierInvoiceRow() {
    }

    public SSSupplierInvoiceRow(SSSupplierInvoiceRow iSupplierInvoiceRow) {
        this.iDescription = iSupplierInvoiceRow.iDescription;
        this.iProductNr = iSupplierInvoiceRow.iProductNr;
        this.iUnitprice = iSupplierInvoiceRow.iUnitprice;
        this.iQuantity = iSupplierInvoiceRow.iQuantity;
        this.iUnit = iSupplierInvoiceRow.iUnit;
        this.iUnitFreight = iSupplierInvoiceRow.iUnitFreight;
        this.iAccountNr = iSupplierInvoiceRow.iAccountNr;
        this.iProjectNumber = iSupplierInvoiceRow.iProjectNumber;
        this.iResultUnitNumber = iSupplierInvoiceRow.iResultUnitNumber;
        this.iProduct = iSupplierInvoiceRow.iProduct;
        this.iAccount = iSupplierInvoiceRow.iAccount;
        this.iProject = iSupplierInvoiceRow.iProject;
        this.iResultUnit = iSupplierInvoiceRow.iResultUnit;
    }

    public SSSupplierInvoiceRow(SSProduct iProduct) {
        this.iProductNr = iProduct.getNumber();
        this.iDescription = iProduct.getDescription();
        this.iUnitprice = iProduct.getSellingPrice();
        this.iUnit = iProduct.getUnit();
        this.iAccountNr = iProduct.getDefaultAccount(SSDefaultAccount.Sales);
        this.iProduct = iProduct;
        this.iQuantity = null;
        this.iAccount = null;
    }

    public SSSupplierInvoiceRow(SSPurchaseOrderRow iRow) {
        this.iDescription = iRow.getDescription();
        this.iProductNr = iRow.getProductNr();
        this.iUnitprice = iRow.getUnitPrice();
        this.iQuantity = iRow.getQuantity();
        this.iUnit = iRow.getUnit();
        this.iAccountNr = iRow.getAccountNr();
    }

    public String getProductNr() {
        return this.iProductNr;
    }

    public void setProductNr(String iProductNr) {
        this.iProductNr = iProductNr;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public BigDecimal getUnitprice() {
        return this.iUnitprice;
    }

    public void setUnitprice(BigDecimal iUnitprice) {
        this.iUnitprice = iUnitprice;
    }

    public BigDecimal getUnitFreight() {
        return this.iUnitFreight;
    }

    public void setUnitFreight(BigDecimal iUnitFreight) {
        this.iUnitFreight = iUnitFreight;
    }

    public Integer getQuantity() {
        return this.iQuantity;
    }

    public void setQuantity(Integer iQuantity) {
        this.iQuantity = iQuantity;
    }

    public SSUnit getUnit() {
        return this.iUnit;
    }

    public void setUnit(SSUnit iUnit) {
        this.iUnit = iUnit;
    }

    public Integer getAccountNr() {
        return this.iAccountNr;
    }

    public void setAccountNr(Integer iAccountNr) {
        this.iAccountNr = iAccountNr;
        this.iAccount = null;
    }

    public String getResultUnitNr() {
        return this.iResultUnitNumber;
    }

    public void setResultUnitNr(String iResultUnitNr) {
        this.iResultUnitNumber = iResultUnitNr;
        this.iResultUnit = null;
    }

    public void fixResultUnitAndProject() {
        if (this.iResultUnitNr != null && this.iResultUnitNumber == null) {
            this.iResultUnitNumber = this.iResultUnitNr.toString();
        }
        if (this.iProjectNr != null && this.iProjectNumber == null) {
            this.iProjectNumber = this.iProjectNr.toString();
        }
    }

    public String getProjectNr() {
        return this.iProjectNumber;
    }

    public void setProjectNr(String iProjectNr) {
        this.iProjectNumber = iProjectNr;
        this.iProject = null;
    }

    public SSAccount getAccount(List<SSAccount> iAccounts) {
        if (this.iAccount == null && this.iAccountNr != null) {
            for (SSAccount iCurrent : iAccounts) {
                if (!this.iAccountNr.equals(iCurrent.getNumber())) continue;
                this.iAccount = iCurrent;
            }
        }
        return this.iAccount;
    }

    public void setAccount(SSAccount iAccount) {
        this.iAccount = iAccount;
        this.iAccountNr = iAccount == null ? Integer.valueOf(-1) : iAccount.getNumber();
    }

    public SSProduct getProduct() {
        return this.getProduct(SSDB.getInstance().getProducts());
    }

    public SSProduct getProduct(List<SSProduct> iProducts) {
        if (this.iProduct == null) {
            for (SSProduct iCurrent : iProducts) {
                String iNumber = iCurrent.getNumber();
                if (iNumber == null || !iNumber.equals(this.iProductNr)) continue;
                this.iProduct = iCurrent;
                break;
            }
        }
        return this.iProduct;
    }

    public void setProduct(SSProduct iProduct) {
        this.iProduct = iProduct;
        String string = this.iProductNr = iProduct == null ? null : iProduct.getNumber();
        if (iProduct != null) {
            this.iDescription = iProduct.getDescription();
            this.iUnitprice = iProduct.getPurchasePrice();
            this.iUnitFreight = iProduct.getUnitFreight();
            this.iUnit = iProduct.getUnit();
            this.iAccountNr = iProduct.getDefaultAccount(SSDefaultAccount.Purchases);
            this.iAccount = null;
            this.iQuantity = 1;
        }
    }

    public SSNewResultUnit getResultUnit(List<SSNewResultUnit> iResultUnits) {
        if (this.iResultUnit == null) {
            for (SSNewResultUnit iCurrent : iResultUnits) {
                String iNumber = iCurrent.getNumber();
                if (iNumber == null || !iNumber.equals(this.iResultUnitNumber)) continue;
                this.iResultUnit = iCurrent;
                break;
            }
        }
        return this.iResultUnit;
    }

    public void setResultUnit(SSNewResultUnit iResultUnit) {
        this.iResultUnit = iResultUnit;
        this.iResultUnitNumber = iResultUnit == null ? null : iResultUnit.getNumber();
    }

    public SSNewProject getProject(List<SSNewProject> iProjects) {
        if (this.iProject == null) {
            for (SSNewProject iCurrent : iProjects) {
                String iNumber = iCurrent.getNumber();
                if (iNumber == null || !iNumber.equals(this.iProjectNumber)) continue;
                this.iProject = iCurrent;
                break;
            }
        }
        return this.iProject;
    }

    public void setProject(SSNewProject iProject) {
        this.iProject = iProject;
        this.iProjectNumber = iProject == null ? null : iProject.getNumber();
    }

    public boolean hasProduct(SSProduct iProduct) {
        return this.iProductNr != null && this.iProductNr.equals(iProduct.getNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iProductNr);
        sb.append(", ");
        sb.append(this.iDescription);
        sb.append(", ");
        sb.append(this.iUnitprice);
        sb.append(", ");
        sb.append(this.iQuantity);
        sb.append(' ');
        sb.append(this.iUnit);
        sb.append(" (");
        sb.append(this.iProduct);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String toRenderString() {
        return this.iProductNr;
    }

    public BigDecimal getSum() {
        if (this.iUnitprice == null || this.iQuantity == null) {
            return null;
        }
        return this.iUnitprice.multiply(new BigDecimal(this.iQuantity));
    }
}

