/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSVoucher
implements Serializable,
Cloneable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private int iNumber;
    private Date iDate;
    private String iDescription;
    private SSVoucher iCorrects;
    private SSVoucher iCorrectedBy;
    private List<SSVoucherRow> iVoucherRows;

    public SSVoucher() {
        this.iDate = SSVoucherMath.getNextVoucherDate();
        this.iVoucherRows = new ArrayList<SSVoucherRow>();
        this.doAutoIncrecement();
    }

    public SSVoucher(Integer iNumber) {
        this.iDate = SSVoucherMath.getNextVoucherDate();
        this.iVoucherRows = new ArrayList<SSVoucherRow>();
        this.iNumber = iNumber;
    }

    public SSVoucher(SSVoucher voucher) {
        this.copyFrom(voucher);
    }

    public void copyFrom(SSVoucher pVoucher) {
        this.iNumber = pVoucher.iNumber;
        this.iDate = pVoucher.iDate;
        this.iDescription = pVoucher.iDescription;
        this.iCorrects = pVoucher.iCorrects;
        this.iCorrectedBy = pVoucher.iCorrectedBy;
        this.iVoucherRows = new LinkedList<SSVoucherRow>();
        for (SSVoucherRow iVoucherRow : pVoucher.iVoucherRows) {
            this.iVoucherRows.add(new SSVoucherRow(iVoucherRow));
        }
    }

    public int getNumber() {
        return this.iNumber;
    }

    public void setNumber(int number) {
        this.iNumber = number;
    }

    public void doAutoIncrecement() {
        int iNumber = SSVoucherMath.getMaxNumber();
        this.iNumber = iNumber + 1;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date date) {
        this.iDate = date;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    public SSVoucher getCorrects() {
        return this.iCorrects;
    }

    public void setCorrects(SSVoucher corrects) {
        this.iCorrects = corrects;
    }

    public SSVoucher getCorrectedBy() {
        return this.iCorrectedBy;
    }

    public void setCorrectedBy(SSVoucher correctedBy) {
        this.iCorrectedBy = correctedBy;
    }

    public List<SSVoucherRow> getRows() {
        return this.iVoucherRows;
    }

    public void addVoucherRow(SSVoucherRow pVoucherRow) {
        this.iVoucherRows.add(pVoucherRow);
    }

    public void addVoucherRow(SSAccount iAccount, BigDecimal iDebet, BigDecimal iCredit) {
        SSVoucherRow iVoucherRow = new SSVoucherRow();
        iVoucherRow.setAccount(iAccount);
        iVoucherRow.setDebet(iDebet);
        iVoucherRow.setCredit(iCredit);
        this.iVoucherRows.add(iVoucherRow);
    }

    public void addVoucherRow(SSAccount iAccount, BigDecimal iValue) {
        if (iValue == null || iValue.signum() == 0) {
            return;
        }
        SSVoucherRow iVoucherRow = new SSVoucherRow();
        iVoucherRow.setAccount(iAccount);
        if (iValue.signum() > 0) {
            iVoucherRow.setDebet(iValue);
            iVoucherRow.setCredit(null);
        } else {
            iVoucherRow.setDebet(null);
            iVoucherRow.setCredit(iValue.abs());
        }
        this.iVoucherRows.add(iVoucherRow);
    }

    public boolean removeVoucherRow(SSVoucherRow row) {
        return this.iVoucherRows.remove(row);
    }

    public void setVoucherRows(List<SSVoucherRow> rows) {
        this.iVoucherRows = rows;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSVoucher) {
            SSVoucher iVoucher = (SSVoucher)obj;
            return this.iNumber == iVoucher.iNumber;
        }
        return super.equals(obj);
    }

    public String toString() {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(", ");
        sb.append(this.iDescription);
        sb.append(", ");
        sb.append(iFormat.format(this.iDate));
        return sb.toString();
    }

    @Override
    public String toRenderString() {
        return Integer.toString(this.iNumber);
    }

    public void dispose() {
    }
}

