/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.backup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import se.swedsoft.bookkeeping.data.backup.util.SSBackupType;

public class SSBackup
implements Serializable {
    static final long serialVersionUID = 1L;
    private String iFilename;
    private Date iDate;
    private SSBackupType iType;

    public SSBackup(SSBackupType pType) {
        this.iType = pType;
    }

    public String getFilename() {
        return this.iFilename;
    }

    public void setFilename(String iFilename) {
        this.iFilename = iFilename;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public SSBackupType getType() {
        return this.iType;
    }

    public void setType(SSBackupType iType) {
        this.iType = iType;
    }

    public void delete() {
        File iFile = new File(this.iFilename);
        if (iFile.exists()) {
            iFile.delete();
        }
    }

    public boolean exists() {
        File iFile = new File(this.iFilename);
        return iFile.exists();
    }

    public static SSBackup loadBackup(File iFile) throws IOException, ClassNotFoundException {
        SSBackup iBackup = null;
        try (ObjectInputStream iObjectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(iFile)));){
            iBackup = (SSBackup)iObjectInputStream.readObject();
        }
        return iBackup;
    }

    public static void storeBackup(File iFile, SSBackup iBackup) throws IOException {
        ObjectOutputStream iObjectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(iFile)));
        iObjectOutputStream.writeObject(iBackup);
        iObjectOutputStream.flush();
        iObjectOutputStream.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iFilename);
        sb.append(", ");
        sb.append(this.iDate);
        sb.append(", ");
        sb.append((Object)this.iType);
        return super.toString();
    }
}

