/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.backup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import se.swedsoft.bookkeeping.app.Path;
import se.swedsoft.bookkeeping.data.backup.SSBackup;
import se.swedsoft.bookkeeping.data.backup.SSBackupData;

public class SSBackupDatabase {
    private static final File iFile = new File(Path.get(Path.USER_DATA), "backup.history");
    private static SSBackupDatabase cInstance;
    private SSBackupData iData;

    public static SSBackupDatabase getInstance() {
        if (cInstance == null) {
            cInstance = new SSBackupDatabase();
        }
        return cInstance;
    }

    private SSBackupDatabase() {
        if (iFile.exists()) {
            this.loadDatabase();
        } else {
            this.newDatabase();
        }
    }

    public void notifyUpdated() {
        this.storeDatabase();
    }

    private void newDatabase() {
        this.iData = new SSBackupData();
    }

    private void loadDatabase() {
        ObjectInputStream iObjectInputStream = null;
        try {
            iObjectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(iFile)));
            this.iData = (SSBackupData)iObjectInputStream.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (iObjectInputStream != null) {
                try {
                    iObjectInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void storeDatabase() {
        try {
            ObjectOutputStream iObjectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(iFile)));
            iObjectOutputStream.writeObject(this.iData);
            iObjectOutputStream.flush();
            iObjectOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<SSBackup> getBackups() {
        if (this.iData == null) {
            throw new RuntimeException("Backupdatabase not loaded");
        }
        return this.iData.getBackups();
    }

    public void add(SSBackup backup) {
        this.iData.getBackups().add(backup);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.backup.SSBackupDatabase");
        sb.append("{iData=").append(this.iData);
        sb.append('}');
        return sb.toString();
    }
}

