/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.backup.util;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.backup.SSBackup;
import se.swedsoft.bookkeeping.data.backup.util.SSBackupType;
import se.swedsoft.bookkeeping.data.backup.util.SSBackupUtils;
import se.swedsoft.bookkeeping.data.backup.util.SSBackupZip;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSSystemCompany;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.frame.SSInternalFrame;
import se.swedsoft.bookkeeping.util.SSException;

public class SSBackupFactory {
    private SSBackupFactory() {
    }

    public static String getDefaultFileName() {
        Date iDate = new Date();
        DateFormat iDateFormat = DateFormat.getDateInstance(3);
        DateFormat iTimeFormat = DateFormat.getTimeInstance(3);
        String iFileName = "backup." + iDateFormat.format(iDate) + '.' + iTimeFormat.format(iDate) + ".zip";
        iFileName = iFileName.replace(":", "");
        iFileName = iFileName.replace("-", "");
        return iFileName;
    }

    public static String getDefaultFileName(SSNewCompany iCompany) {
        Date iDate = new Date();
        DateFormat iDateFormat = DateFormat.getDateInstance(3);
        DateFormat iTimeFormat = DateFormat.getTimeInstance(3);
        String iFileName = "backup." + iCompany.getName() + '.' + iDateFormat.format(iDate) + '.' + iTimeFormat.format(iDate) + ".zip";
        iFileName = iFileName.replace(":", "");
        iFileName = iFileName.replace("-", "");
        return iFileName;
    }

    public static SSBackup createBackup(String pFilename) {
        SSBackup iBackup = new SSBackup(SSBackupType.FULL);
        iBackup.setDate(new Date());
        iBackup.setFilename(pFilename);
        List<SSBackupZip.ArchiveFile> iFiles = SSBackupUtils.getFiles();
        try {
            File iBackupFile = File.createTempFile("backup", null);
            SSBackup.storeBackup(iBackupFile, iBackup);
            iFiles.add(new SSBackupZip.ArchiveFile(iBackupFile, "backup.info"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        System.out.println("Creating backup, adding files {");
        SSBackupFactory.printFiles(iFiles);
        System.out.println("}");
        try {
            SSBackupZip.compressFiles(pFilename, iFiles);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return iBackup;
    }

    public static SSBackup createBackup(String pFilename, SSSystemCompany pCompany) {
        return null;
    }

    public static void restoreBackup(String pFilename) throws SSException {
        try {
            File iBackupFile = File.createTempFile("backup", null);
            if (!SSBackupZip.extractFile(pFilename, new SSBackupZip.ArchiveFile(iBackupFile, "backup.info"))) {
                throw new SSException(SSBundle.getBundle(), "backupframe.importbackup.invalid");
            }
            SSBackup iBackup = SSBackup.loadBackup(iBackupFile);
            if (iBackup.getType() == SSBackupType.FULL) {
                SSBackupFactory.restoreBackup(pFilename, iBackup);
            }
            iBackupFile.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private static void restoreBackup(String pFilename, SSBackup iBackup) throws IOException {
        SSInternalFrame.closeAllFrames();
        String iDirectory = "db" + File.separator;
        SSDB.getInstance().delete();
        List<SSBackupZip.ArchiveFile> iFiles = SSBackupUtils.getFiles(pFilename, iDirectory);
        SSBackupZip.extractFiles(pFilename, iFiles);
        try {
            SSDB.getInstance().loadLocalDatabase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void restoreBackup(String pFilename, SSBackup iBackup, SSSystemCompany iRestoredCompany) {
        SSInternalFrame.closeAllFrames();
        if (iRestoredCompany.isCurrent()) {
            // empty if block
        }
    }

    private static void printFiles(List<SSBackupZip.ArchiveFile> iFiles) {
        for (SSBackupZip.ArchiveFile iFile : iFiles) {
            System.out.println("  " + iFile);
        }
    }
}

