/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.base;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSSaleRow
implements SSTableSearchable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String iProductNr;
    private String iDescription;
    private BigDecimal iUnitprice;
    private Integer iCount;
    private SSUnit iUnit;
    private BigDecimal iDiscount;
    private SSTaxCode iTaxCode;
    private Integer iAccountNr;
    private String iProjectNumber;
    private Integer iProjectNr;
    private String iResultUnitNumber;
    private Integer iResultUnitNr;
    private transient SSProduct iProduct;
    private transient SSAccount iAccount;
    private transient SSNewProject iProject;
    private transient SSNewResultUnit iResultUnit;

    public SSSaleRow() {
    }

    public SSSaleRow(SSSaleRow iTenderRow) {
        this.iDescription = iTenderRow.iDescription;
        this.iProductNr = iTenderRow.iProductNr;
        this.iUnitprice = iTenderRow.iUnitprice;
        this.iCount = iTenderRow.iCount;
        this.iUnit = iTenderRow.iUnit;
        this.iDiscount = iTenderRow.iDiscount;
        this.iTaxCode = iTenderRow.iTaxCode;
        this.iProduct = iTenderRow.iProduct;
        this.iAccountNr = iTenderRow.iAccountNr;
        this.iProjectNumber = iTenderRow.iProjectNumber;
        this.iResultUnitNumber = iTenderRow.iResultUnitNumber;
        this.iAccount = iTenderRow.iAccount;
        this.iProject = iTenderRow.iProject;
        this.iResultUnit = iTenderRow.iResultUnit;
    }

    public SSSaleRow(SSProduct iProduct) {
        this.iProductNr = iProduct.getNumber();
        this.iDescription = iProduct.getDescription();
        this.iUnitprice = iProduct.getSellingPrice();
        this.iUnit = iProduct.getUnit();
        this.iTaxCode = iProduct.getTaxCode();
        this.iAccountNr = iProduct.getDefaultAccount(SSDefaultAccount.Sales);
        this.iProduct = iProduct;
        this.iDiscount = null;
        this.iCount = null;
        this.iAccount = null;
    }

    public String getProductNr() {
        return this.iProductNr;
    }

    public void setProductNr(String iProductNr) {
        this.iProductNr = iProductNr;
        this.iProduct = null;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public String getDescription(Locale iLocale) {
        String iProductDescription;
        if (this.getProduct() != null && (iProductDescription = this.iProduct.getDescription(iLocale)) != null) {
            return iProductDescription;
        }
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public BigDecimal getUnitprice() {
        return this.iUnitprice;
    }

    public void setUnitprice(BigDecimal iUnitprice) {
        this.iUnitprice = iUnitprice;
    }

    public Integer getQuantity() {
        return this.iCount;
    }

    public void setQuantity(Integer iCount) {
        this.iCount = iCount;
    }

    public SSUnit getUnit() {
        return this.iUnit;
    }

    public void setUnit(SSUnit iUnit) {
        this.iUnit = iUnit;
    }

    public BigDecimal getDiscount() {
        return this.iDiscount;
    }

    public void setDiscount(BigDecimal iDiscount) {
        this.iDiscount = iDiscount;
    }

    public BigDecimal getNormalizedDiscount() {
        return this.iDiscount == null ? new BigDecimal(0) : this.iDiscount.scaleByPowerOfTen(-2);
    }

    public SSTaxCode getTaxCode() {
        return this.iTaxCode;
    }

    public void setTaxCode(SSTaxCode iTaxCode) {
        this.iTaxCode = iTaxCode;
    }

    public Integer getAccountNr() {
        return this.iAccountNr;
    }

    public void setAccountNr(Integer iAccountNr) {
        this.iAccountNr = iAccountNr;
        this.iAccount = null;
    }

    public String getResultUnitNr() {
        return this.iResultUnitNumber;
    }

    public void setResultUnitNr(String iResultUnitNr) {
        this.iResultUnitNumber = iResultUnitNr;
        this.iResultUnit = null;
    }

    public void fixResultUnitAndProject() {
        if (this.iResultUnitNr != null && this.iResultUnitNumber == null) {
            this.iResultUnitNumber = this.iResultUnitNr.toString();
        }
        if (this.iProjectNr != null && this.iProjectNumber == null) {
            this.iProjectNumber = this.iProjectNr.toString();
        }
    }

    public String getProjectNr() {
        return this.iProjectNumber;
    }

    public void setProjectNr(String iProjectNr) {
        this.iProjectNumber = iProjectNr;
        this.iProject = null;
    }

    public SSAccount getAccount(List<SSAccount> iAccounts) {
        if (this.iAccount == null && this.iAccountNr != null) {
            for (SSAccount iCurrent : iAccounts) {
                if (!this.iAccountNr.equals(iCurrent.getNumber())) continue;
                this.iAccount = iCurrent;
            }
        }
        return this.iAccount;
    }

    public void setAccount(SSAccount iAccount) {
        this.iAccount = iAccount;
        this.iAccountNr = iAccount == null ? Integer.valueOf(-1) : iAccount.getNumber();
    }

    public SSProduct getProduct() {
        return this.getProduct(SSDB.getInstance().getProducts());
    }

    public SSProduct getProduct(List<SSProduct> iProducts) {
        if (this.iProduct == null && this.iProductNr != null) {
            for (SSProduct iCurrent : iProducts) {
                if (!this.iProductNr.equals(iCurrent.getNumber())) continue;
                this.iProduct = iCurrent;
                break;
            }
        }
        return this.iProduct;
    }

    public void setProduct(SSProduct iProduct) {
        this.iProductNr = iProduct.getNumber();
        this.iDescription = iProduct.getDescription();
        this.iUnitprice = iProduct.getSellingPrice();
        this.iUnit = iProduct.getUnit();
        this.iTaxCode = iProduct.getTaxCode();
        this.iAccountNr = iProduct.getDefaultAccount(SSDefaultAccount.Sales);
        this.iCount = 1;
        this.iAccount = null;
        this.iProduct = iProduct;
    }

    public void setProductOnly(SSProduct iProduct) {
        this.iProductNr = iProduct.getNumber();
        this.iDescription = iProduct.getDescription();
        this.iUnitprice = iProduct.getSellingPrice();
        this.iUnit = iProduct.getUnit();
        this.iTaxCode = iProduct.getTaxCode();
        this.iAccountNr = iProduct.getDefaultAccount(SSDefaultAccount.Sales);
        this.iAccount = null;
        this.iProduct = iProduct;
        this.iProject = iProduct.getProject();
        this.iProjectNumber = iProduct.getProjectNr();
        this.iResultUnit = iProduct.getResultUnit();
        this.iResultUnitNumber = iProduct.getResultUnitNr();
    }

    public SSNewResultUnit getResultUnit(List<SSNewResultUnit> iResultUnits) {
        if (this.iResultUnit == null) {
            for (SSNewResultUnit iCurrent : iResultUnits) {
                String iNumber = iCurrent.getNumber();
                if (iNumber == null || !iNumber.equals(this.iResultUnitNumber)) continue;
                this.iResultUnit = iCurrent;
                break;
            }
        }
        return this.iResultUnit;
    }

    public void setResultUnit(SSNewResultUnit iResultUnit) {
        this.iResultUnit = iResultUnit;
        this.iResultUnitNumber = iResultUnit == null ? null : iResultUnit.getNumber();
    }

    public SSNewProject getProject(List<SSNewProject> iProjects) {
        if (this.iProject == null) {
            for (SSNewProject iCurrent : iProjects) {
                String iNumber = iCurrent.getNumber();
                if (iNumber == null || !iNumber.equals(this.iProjectNumber)) continue;
                this.iProject = iCurrent;
                break;
            }
        }
        return this.iProject;
    }

    public void setProject(SSNewProject iProject) {
        this.iProject = iProject;
        this.iProjectNumber = iProject == null ? null : iProject.getNumber();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iProductNr);
        sb.append(", ");
        sb.append(this.iDescription);
        sb.append(", ");
        sb.append(this.iUnitprice);
        sb.append(", ");
        sb.append(this.iCount);
        sb.append(' ');
        sb.append(this.iUnit);
        sb.append(", ");
        sb.append(this.iDiscount);
        sb.append(", ");
        sb.append(this.iTaxCode);
        sb.append(" (");
        sb.append(this.iProduct);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String toRenderString() {
        return this.iProductNr;
    }

    public boolean hasProduct(SSProduct iProduct) {
        return this.iProductNr != null && this.iProductNr.equals(iProduct.getNumber());
    }

    public BigDecimal getSum() {
        if (this.iUnitprice == null || this.iCount == null) {
            return null;
        }
        BigDecimal iSum = this.iUnitprice.multiply(new BigDecimal(this.iCount));
        if (this.iDiscount == null) {
            return iSum;
        }
        return iSum.subtract(iSum.multiply(this.getNormalizedDiscount()));
    }
}

