/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSCurrency
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private String iCode;
    private String iDescription;
    private BigDecimal iExchangeRate;

    public SSCurrency() {
        this.iCode = null;
        this.iDescription = null;
        this.iExchangeRate = new BigDecimal(1);
    }

    public SSCurrency(String iCode, String iDescription) {
        this.iCode = iCode;
        this.iDescription = iDescription;
        this.iExchangeRate = new BigDecimal(1);
    }

    public SSCurrency(SSCurrency iCurrency) {
        this.copyFrom(iCurrency);
    }

    public void copyFrom(SSCurrency iCurrency) {
        this.iCode = iCurrency.iCode;
        this.iDescription = iCurrency.iDescription;
        this.iExchangeRate = iCurrency.iExchangeRate;
    }

    public String getName() {
        return this.iCode;
    }

    public void setName(String pCode) {
        this.iCode = pCode;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String pDescription) {
        this.iDescription = pDescription;
    }

    public BigDecimal getExchangeRate() {
        if (this.iExchangeRate == null) {
            this.iExchangeRate = new BigDecimal(1);
        }
        return this.iExchangeRate;
    }

    public void setExchangeRate(BigDecimal iExchangeRate) {
        this.iExchangeRate = iExchangeRate;
    }

    @Override
    public String toRenderString() {
        return this.iCode;
    }

    public String toString() {
        return this.iCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSCurrency)) {
            return false;
        }
        return this.iCode.equals(((SSCurrency)obj).iCode);
    }

    public static List<SSCurrency> getDefaultCurrencies() {
        LinkedList<SSCurrency> iCurrencies = new LinkedList<SSCurrency>();
        iCurrencies.add(new SSCurrency("EUR", "Euro"));
        iCurrencies.add(new SSCurrency("SEK", "Svenska kronor"));
        iCurrencies.add(new SSCurrency("USD", "US Dollar"));
        return iCurrencies;
    }
}

