/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.common;

import java.io.Serializable;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;

public enum SSDefaultAccount implements Serializable
{
    CustomerClaim(1510),
    InPayment(1930),
    OutPayment(1930),
    Cash(1910),
    SupplierDebt(2440),
    Tax1(2611),
    Tax2(2621),
    Tax3(2631),
    Sales(3051),
    Purchases(4010),
    CurrencyProfit(3960),
    CurrencyLoss(7960),
    Rounding(3740),
    InterestProfit(8300),
    IncommingTax(2640);

    private static final long serialVersionUID = 6209981489711135940L;
    private int iDefaultAccountNumber;

    private SSDefaultAccount(int pDefaultAccountNumber) {
        this.iDefaultAccountNumber = pDefaultAccountNumber;
    }

    public int getDefaultAccountNumber() {
        return this.iDefaultAccountNumber;
    }

    public void setDefaultAccountNumber(int iDefaultAccountNumber) {
        this.iDefaultAccountNumber = iDefaultAccountNumber;
    }

    public SSAccount getAccount(SSAccountPlan iAccountPlan) {
        return iAccountPlan.getAccount(this.iDefaultAccountNumber);
    }

    public SSAccount getAccount(List<SSAccount> iAccounts) {
        for (SSAccount iAccount : iAccounts) {
            if (iAccount.getNumber() != this.iDefaultAccountNumber) continue;
            return iAccount;
        }
        return null;
    }
}

