/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.common;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSVATCode
implements SSTableSearchable {
    private String iName = null;
    private String iDescription = null;
    public static SSVATCode VAT_NULL = new SSVATCode();
    private static List<SSVATCode> iValues;

    private SSVATCode() {
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String iName) {
        this.iName = iName;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public void setBundle(String iBundle) {
        this.iDescription = SSBundle.getBundle().getString(iBundle);
    }

    @Override
    public String toRenderString() {
        return this.iName;
    }

    public String toString() {
        return this.iName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSVATCode) {
            SSVATCode iVATCode = (SSVATCode)obj;
            return this.iName != null && this.iName.equalsIgnoreCase(iVATCode.iName);
        }
        if (obj instanceof String) {
            String iVATCode = (String)obj;
            return this.iName != null && this.iName.equalsIgnoreCase(iVATCode);
        }
        return false;
    }

    public static List<SSVATCode> getValues() {
        if (iValues == null) {
            iValues = new LinkedList<SSVATCode>();
            DOMParser iParser = new DOMParser();
            try {
                InputStream istream = SSVATCode.class.getResourceAsStream("/vatcodes.xml");
                iParser.parse(new InputSource(istream));
                NodeList iNodes = iParser.getDocument().getDocumentElement().getElementsByTagName("vatcode");
                for (int i = 0; i < iNodes.getLength(); ++i) {
                    Node iNode = iNodes.item(i);
                    String iName = iNode.getAttributes().getNamedItem("name").getNodeValue();
                    String iDescription = iNode.getAttributes().getNamedItem("description").getNodeValue();
                    SSVATCode iVatCode = new SSVATCode();
                    iVatCode.iName = iName;
                    iVatCode.iDescription = iDescription;
                    iValues.add(iVatCode);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return iValues;
    }

    public static SSVATCode decode(String iVATCode) {
        for (SSVATCode iVatCode : SSVATCode.getValues()) {
            if (!iVatCode.equals(iVATCode)) continue;
            return iVatCode;
        }
        return null;
    }
}

