/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import se.swedsoft.bookkeeping.app.Path;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.system.SSSystemCompany;
import se.swedsoft.bookkeeping.data.system.SSSystemYear;

public class SSCompanyConfig {
    private SSCompanyConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLastOpenCompany(SSSystemCompany iLastCompany) {
        File iFile = new File(Path.get(Path.APP_BASE), "lastcompanyopen.config");
        if (iFile.exists()) {
            iFile.delete();
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(iFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(iLastCompany);
            if (iLastCompany.getCurrentYear() != null) {
                oos.writeObject(iLastCompany.getCurrentYear());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSSystemCompany openLastOpenCompany() {
        File iFile = new File(Path.get(Path.APP_BASE), "lastcompanyopen.config");
        if (!iFile.exists()) {
            return null;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        SSSystemCompany iSystemCompany = null;
        try {
            fis = new FileInputStream(iFile);
            ois = new ObjectInputStream(fis);
            iSystemCompany = (SSSystemCompany)ois.readObject();
            SSSystemYear iSystemYear = (SSSystemYear)ois.readObject();
            if (iSystemCompany != null && iSystemYear != null) {
                for (SSSystemYear iCurrent : iSystemCompany.getYears()) {
                    if (!iCurrent.getId().equals(iSystemYear.getId())) continue;
                    iCurrent.setCurrent(true);
                }
            }
        }
        catch (IOException e) {
            iFile.delete();
            SSSystemCompany sSSystemCompany = iSystemCompany;
            return sSSystemCompany;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return iSystemCompany;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCompanySetting(SSNewCompany iCompany) {
        if (iCompany == null) {
            return;
        }
        File iFile = new File(Path.get(Path.APP_BASE), "companysettings.config");
        Vector<Serializable> iVector = new Vector<Serializable>();
        iVector.add(iCompany);
        ObjectInputStream ois = null;
        FileInputStream fis = null;
        try {
            if (!iFile.exists()) {
                return;
            }
            try {
                fis = new FileInputStream(iFile);
                ois = new ObjectInputStream(fis);
                while (true) {
                    SSSystemCompany iSystemCompany = (SSSystemCompany)ois.readObject();
                    SSSystemYear iSystemYear = (SSSystemYear)ois.readObject();
                    if (iSystemCompany == null || iSystemCompany.getId().equals(iCompany.getId())) continue;
                    iVector.add(iSystemCompany);
                    iVector.add(iSystemYear);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (iFile.exists()) {
                    iFile.delete();
                }
                FileOutputStream fos = new FileOutputStream(iFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                for (Object e : iVector) {
                    oos.writeObject(e);
                }
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSSystemCompany openCompanySetting(SSSystemCompany iCompany) {
        File iFile = new File(Path.get(Path.APP_BASE), "companysettings.config");
        if (!iFile.exists()) {
            return null;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        SSSystemCompany iSystemCompany = null;
        try {
            fis = new FileInputStream(iFile);
            ois = new ObjectInputStream(fis);
            SSSystemYear iSystemYear = null;
            do {
                iSystemCompany = (SSSystemCompany)ois.readObject();
                iSystemYear = (SSSystemYear)ois.readObject();
            } while (iSystemCompany == null || !iSystemCompany.getId().equals(iCompany.getId()));
            if (iSystemYear != null) {
                for (SSSystemYear iCurrent : iSystemCompany.getYears()) {
                    if (!iCurrent.getId().equals(iSystemYear.getId())) continue;
                    iCurrent.setCurrent(true);
                }
            }
            SSSystemCompany sSSystemCompany = iSystemCompany;
            return sSSystemCompany;
        }
        catch (IOException e) {
            SSSystemCompany sSSystemCompany = null;
            return sSSystemCompany;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return iSystemCompany;
    }

    private static ObjectOutputStream appendableObjectOutputStream(File f) throws IOException {
        boolean append;
        FileOutputStream fos = new FileOutputStream(f, true);
        boolean bl = append = f.exists() && f.length() > 0L;
        if (append) {
            return new ObjectOutputStream(fos){

                @Override
                protected void writeStreamHeader() throws IOException {
                }
            };
        }
        return new ObjectOutputStream(fos);
    }

    public static void deleteFiles() {
        File iFile1 = new File(Path.get(Path.APP_BASE), "lastcompanyopen.config");
        File iFile2 = new File(Path.get(Path.APP_BASE), "companysettings.config");
        if (iFile1.exists()) {
            iFile1.delete();
        }
        if (iFile2.exists()) {
            iFile2.delete();
        }
    }
}

