/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.system;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.PrintWriter;
import java.net.SocketException;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;

public class SSDBUtils {
    private static Integer iLocalRevisionNumber = 1;

    private SSDBUtils() {
    }

    private static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static void backup(File iFile) {
        File iBackupFile = SSDBUtils.getBackupFile(iFile);
        if (iFile.exists() && !iBackupFile.exists()) {
            try {
                SSDBUtils.copyFile(iFile, iBackupFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Failed to copy " + iFile + " to " + iBackupFile);
            }
        }
    }

    public static void removeBackup(File iFile) {
        File iBackupFile = SSDBUtils.getBackupFile(iFile);
        if (iBackupFile.exists()) {
            iBackupFile.delete();
        }
    }

    public static boolean restoreBackup(File iFile) {
        File iBackupFile = SSDBUtils.getBackupFile(iFile);
        if (iBackupFile.exists()) {
            if (iFile.exists()) {
                iFile.delete();
            }
            return iBackupFile.renameTo(iFile);
        }
        return false;
    }

    public static Integer getRevisionNumber() {
        try {
            if (!SSDB.getInstance().getLocking()) {
                return iLocalRevisionNumber;
            }
            PrintWriter iOut = SSDB.getInstance().getWriter();
            BufferedReader iIn = SSDB.getInstance().getReader();
            iOut.println("getrevisionnumber");
            iOut.flush();
            String iAnswer = iIn.readLine();
            return Integer.parseInt(iAnswer);
        }
        catch (SocketException e) {
            new SSErrorDialog(SSMainFrame.getInstance(), "connectionlostrestart");
            System.exit(0);
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void setRevisionNumber(Integer iNumber) {
        if (!SSDB.getInstance().getLocking()) {
            iLocalRevisionNumber = iNumber;
            return;
        }
        PrintWriter iOut = SSDB.getInstance().getWriter();
        iOut.println("setrevisionnumber");
        iOut.flush();
        iOut.println(iNumber.toString());
        iOut.flush();
    }

    private static File getBackupFile(File iFile) {
        return new File(iFile.getParent(), iFile.getName() + ".backup");
    }

    public static boolean deleteFile(String pFilename) {
        File iFile = new File(pFilename);
        if (iFile.exists()) {
            return iFile.delete();
        }
        return false;
    }

    public static void backup(String pFileName) {
        File iFile = new File(pFileName);
        File iBackupFile = SSDBUtils.getBackupFile(iFile);
        if (iFile.exists()) {
            if (iBackupFile.exists()) {
                iBackupFile.delete();
            }
            iFile.renameTo(iBackupFile);
        }
    }

    public static void removeBackup(String pFileName) {
        File iBackupFile = SSDBUtils.getBackupFile(new File(pFileName));
        if (iBackupFile.exists()) {
            iBackupFile.delete();
        }
    }

    public static void restoreBackup(String pFileName) {
        File iFile = new File(pFileName);
        File iBackupFile = SSDBUtils.getBackupFile(iFile);
        if (iBackupFile.exists()) {
            if (iFile.exists()) {
                iFile.delete();
            }
            iBackupFile.renameTo(iFile);
        }
    }

    public static void SaveToFile(File iFile, Object iObject) throws IOException {
        FileOutputStream fos = null;
        FilterOutputStream iBufferedOutputStream = null;
        ObjectOutputStream iObjectOutputStream = null;
        try {
            fos = new FileOutputStream(iFile);
            iBufferedOutputStream = new BufferedOutputStream(fos);
            iObjectOutputStream = new ObjectOutputStream(iBufferedOutputStream);
            iObjectOutputStream.writeObject(iObject);
            iObjectOutputStream.flush();
            iObjectOutputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            if (fos != null) {
                fos.close();
            }
            if (iBufferedOutputStream != null) {
                iBufferedOutputStream.close();
            }
            if (iObjectOutputStream != null) {
                iObjectOutputStream.close();
            }
            throw new IOException(e1.getMessage());
        }
    }

    public static Object LoadFromFile(File iFile) throws IOException {
        FileInputStream fis = null;
        BufferedInputStream iBufferedInputStream = null;
        ObjectInputStream iObjectInputStream = null;
        try {
            fis = new FileInputStream(iFile);
            iBufferedInputStream = new BufferedInputStream(fis);
            iObjectInputStream = new SSObjectInputStream(iBufferedInputStream);
            Object iObject = null;
            try {
                iObject = iObjectInputStream.readObject();
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            iObjectInputStream.close();
            return iObject;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            if (fis != null) {
                fis.close();
            }
            if (iBufferedInputStream != null) {
                iBufferedInputStream.close();
            }
            if (iObjectInputStream != null) {
                iObjectInputStream.close();
            }
            throw new IOException(e1.getMessage());
        }
        return null;
    }

    public static SSNewCompany loadCompany(String pFilename) {
        try {
            BufferedInputStream iBufferedInputStream = new BufferedInputStream(new FileInputStream(pFilename));
            SSObjectInputStream iObjectInputStream = new SSObjectInputStream(iBufferedInputStream);
            return (SSNewCompany)iObjectInputStream.readObject();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void storeCompany(String pFilename, SSNewCompany pCompany) throws IOException {
        BufferedOutputStream iBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(pFilename));
        ObjectOutputStream iObjectOutputStream = new ObjectOutputStream(iBufferedOutputStream);
        iObjectOutputStream.writeObject(pCompany);
        iObjectOutputStream.flush();
        iObjectOutputStream.close();
    }

    public static SSNewAccountingYear loadYear(String pFilename) {
        try {
            BufferedInputStream iBufferedInputStream = new BufferedInputStream(new FileInputStream(pFilename));
            ObjectInputStream iObjectInputStream = new ObjectInputStream(iBufferedInputStream);
            SSNewAccountingYear iYear = (SSNewAccountingYear)iObjectInputStream.readObject();
            if (iYear == null) {
                return new SSNewAccountingYear();
            }
            return iYear;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void storeYear(String pFilename, SSNewAccountingYear pYear) throws IOException {
        BufferedOutputStream iBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(pFilename));
        ObjectOutputStream iObjectOutputStream = new ObjectOutputStream(iBufferedOutputStream);
        iObjectOutputStream.writeObject(pYear);
        iObjectOutputStream.flush();
        iObjectOutputStream.close();
    }

    private static class SSObjectInputStream
    extends ObjectInputStream {
        public SSObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (desc.getSerialVersionUID() == -673623580724335542L) {
                return null;
            }
            return super.resolveClass(desc);
        }
    }
}

